/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.onlinedisplays.blocks;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.zeith.hammerlib.api.blocks.ICustomBlockItem;
import org.zeith.hammerlib.api.forge.BlockAPI;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.Network;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.onlinedisplays.OnlineDisplays;
import org.zeith.onlinedisplays.client.render.ister.DisplayISTER;
import org.zeith.onlinedisplays.net.PacketOpenDisplayConfig;
import org.zeith.onlinedisplays.tiles.TileDisplay;
import org.zeith.onlinedisplays.util.ImageData;

public class BlockDisplay
extends BaseEntityBlock
implements ICustomBlockItem {
    VoxelShape SHAPE = BlockDisplay.m_49796_((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0);

    public BlockDisplay(BlockBehaviour.Properties props) {
        super(props);
    }

    public ItemStack save(TileDisplay display) {
        ItemStack st = new ItemStack((ItemLike)this);
        if (display != null && !StringUtil.m_14408_((String)((String)display.imageHash.get()))) {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128365_("HL", (Tag)display.writeNBT(new CompoundTag()));
            st.m_41700_("BlockEntityTag", (Tag)nbt);
            String hash = (String)display.imageHash.get();
            ImageData id = OnlineDisplays.PROXY.getImageContainer(display.m_58904_()).load(hash);
            if (id != null) {
                CompoundTag dsp = new CompoundTag();
                ListTag lore = new ListTag();
                lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)id.getFileName()).m_130948_(Style.f_131099_.m_178520_(0x22FFFF)))));
                lore.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)OnlineDisplays.info("emissive." + display.isEmissive.get()).m_130948_(Style.f_131099_.m_178520_((Boolean)display.isEmissive.get() != false ? 0xFFFF11 : 0x666666)))));
                dsp.m_128365_("Lore", (Tag)lore);
                st.m_41700_("display", (Tag)dsp);
            }
        }
        return st;
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        TileDisplay display = (TileDisplay)((Object)Cast.cast((Object)builder.m_287261_(LootContextParams.f_81462_), TileDisplay.class));
        return Collections.singletonList(this.save(display));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext ctx) {
        if (reader instanceof Level) {
            Level lvl = (Level)reader;
            if (!OnlineDisplays.getModSettings().survivalMode && lvl.f_46443_ && !OnlineDisplays.PROXY.isCreative()) {
                return Shapes.m_83040_();
            }
        }
        return this.SHAPE;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext ctx) {
        return Shapes.m_83040_();
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext ctx) {
        return this.SHAPE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource rng) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        boolean flag = false;
        if (player != null) {
            for (ItemStack st : player.m_6167_()) {
                if (st.m_41720_() != this.m_5456_()) continue;
                flag = true;
                break;
            }
        }
        if (flag) {
            level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_194652_, state), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult res) {
        if (!level.f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            TileDisplay tile = (TileDisplay)((Object)Cast.cast((Object)level.m_7702_(pos), TileDisplay.class));
            if (tile != null) {
                if (tile.canEdit(sp)) {
                    Network.sendTo((Player)player, (IPacket)new PacketOpenDisplayConfig(tile));
                } else {
                    sp.m_240418_((Component)OnlineDisplays.info("no_access").m_130940_(ChatFormatting.RED), true);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileDisplay(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState p_153213_, BlockEntityType<T> p_153214_) {
        return BlockAPI.ticker((Level)level);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        if (player == null || player.m_6144_()) {
            return new ItemStack((ItemLike)this);
        }
        return this.save((TileDisplay)((Object)Cast.cast((Object)level.m_7702_(pos), TileDisplay.class)));
    }

    public BlockItem createBlockItem() {
        return new BlockItem((Block)this, new Item.Properties()){

            public void initializeClient(Consumer<IClientItemExtensions> consumer) {
                consumer.accept(new IClientItemExtensions(){

                    public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                        return DisplayISTER.INSTANCE;
                    }
                });
            }
        };
    }
}

