/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.onlinedisplays.client.gui;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.Network;
import org.zeith.hammerlib.net.lft.TransportSessionBuilder;
import org.zeith.onlinedisplays.OnlineDisplays;
import org.zeith.onlinedisplays.client.gui.FileBrowserScreen;
import org.zeith.onlinedisplays.client.texture.IDisplayableTexture;
import org.zeith.onlinedisplays.init.BlocksOD;
import org.zeith.onlinedisplays.mixins.client.ImageButtonAccessor;
import org.zeith.onlinedisplays.net.PacketRequestDisplaySync;
import org.zeith.onlinedisplays.net.PacketSetEmissiveFlag;
import org.zeith.onlinedisplays.net.PacketUpdateTransforms;
import org.zeith.onlinedisplays.net.PacketUpdateURL;
import org.zeith.onlinedisplays.net.UploadLocalFileSession;
import org.zeith.onlinedisplays.tiles.TileDisplay;

public class GuiDisplayConfig
extends Screen {
    public static final Predicate<String> URL_MATCHER = ((Predicate<String>)Objects::nonNull).and(OnlineDisplays.URL_TEST.or(str -> str.startsWith("local/")));
    protected final int xSize = 176;
    protected final int ySize = 166;
    protected int guiLeft;
    protected int guiTop;
    public final ResourceLocation texture = OnlineDisplays.id("textures/gui/display.png");
    public TileDisplay display;
    EditBox url;
    EditBox tx;
    EditBox ty;
    EditBox tz;
    EditBox rx;
    EditBox ry;
    EditBox rz;
    EditBox sx;
    EditBox sy;
    ImageButtonAccessor emissiveToggle;

    public GuiDisplayConfig(TileDisplay display) {
        super((Component)BlocksOD.DISPLAY.m_49954_());
        this.display = display;
    }

    public void setURL(String value) {
        if (this.url != null) {
            this.url.m_94144_(value);
        }
    }

    protected void m_7856_() {
        this.guiLeft = (this.f_96543_ - 176) / 2;
        this.guiTop = (this.f_96544_ - 166) / 2;
        super.m_7856_();
        String pv = this.url != null ? this.url.m_94155_() : (String)this.display.imageURL.get();
        this.url = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.guiLeft + 7, this.guiTop + 19, 142, 18, (Component)Component.m_237119_()));
        this.url.m_257544_(Tooltip.m_257550_((Component)OnlineDisplays.gui("url")));
        this.url.m_94199_(1024);
        this.url.m_94144_(pv);
        if (pv != null) {
            boolean validURL = URL_MATCHER.test(pv);
            this.url.m_94202_(validURL ? 0x22FF11 : 0xFF2211);
        }
        int xBase = 7;
        int yBase = 52;
        pv = this.tx != null ? this.tx.m_94155_() : Float.toString(this.display.matrix.translateX);
        this.tx = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.guiLeft + xBase, this.guiTop + yBase, 40, 18, (Component)Component.m_237119_()));
        this.tx.m_257544_(Tooltip.m_257550_((Component)OnlineDisplays.gui("translate_x")));
        this.tx.m_94199_(10);
        this.tx.m_94144_(pv);
        this.tx.m_94198_();
        pv = this.ty != null ? this.ty.m_94155_() : Float.toString(this.display.matrix.translateY);
        this.ty = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.guiLeft + xBase + 60, this.guiTop + yBase, 40, 18, (Component)Component.m_237119_()));
        this.ty.m_257544_(Tooltip.m_257550_((Component)OnlineDisplays.gui("translate_y")));
        this.ty.m_94199_(10);
        this.ty.m_94144_(pv);
        this.ty.m_94198_();
        pv = this.tz != null ? this.tz.m_94155_() : Float.toString(this.display.matrix.translateZ);
        this.tz = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.guiLeft + xBase + 120, this.guiTop + yBase, 40, 18, (Component)Component.m_237119_()));
        this.tz.m_257544_(Tooltip.m_257550_((Component)OnlineDisplays.gui("translate_z")));
        this.tz.m_94199_(10);
        this.tz.m_94144_(pv);
        this.tz.m_94198_();
        xBase = 7;
        yBase = 85;
        pv = this.rx != null ? this.rx.m_94155_() : Float.toString(this.display.matrix.rotateX);
        this.rx = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.guiLeft + xBase, this.guiTop + yBase, 40, 18, (Component)Component.m_237119_()));
        this.rx.m_257544_(Tooltip.m_257550_((Component)OnlineDisplays.gui("rotate_x")));
        this.rx.m_94199_(10);
        this.rx.m_94144_(pv);
        this.rx.m_94198_();
        pv = this.ry != null ? this.ry.m_94155_() : Float.toString(this.display.matrix.rotateY);
        this.ry = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.guiLeft + xBase + 60, this.guiTop + yBase, 40, 18, (Component)Component.m_237119_()));
        this.ry.m_257544_(Tooltip.m_257550_((Component)OnlineDisplays.gui("rotate_y")));
        this.ry.m_94199_(10);
        this.ry.m_94144_(pv);
        this.ry.m_94198_();
        pv = this.rz != null ? this.rz.m_94155_() : Float.toString(this.display.matrix.rotateZ);
        this.rz = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.guiLeft + xBase + 120, this.guiTop + yBase, 40, 18, (Component)Component.m_237119_()));
        this.rz.m_257544_(Tooltip.m_257550_((Component)OnlineDisplays.gui("rotate_z")));
        this.rz.m_94199_(10);
        this.rz.m_94144_(pv);
        this.rz.m_94198_();
        xBase = 67;
        yBase = 118;
        pv = this.sx != null ? this.sx.m_94155_() : Float.toString(this.display.matrix.scaleX);
        this.sx = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.guiLeft + xBase, this.guiTop + yBase, 40, 18, (Component)Component.m_237119_()));
        this.sx.m_257544_(Tooltip.m_257550_((Component)OnlineDisplays.gui("scale_x")));
        this.sx.m_94199_(10);
        this.sx.m_94144_(pv);
        this.sx.m_94198_();
        pv = this.sy != null ? this.sy.m_94155_() : Float.toString(this.display.matrix.scaleY);
        this.sy = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.guiLeft + xBase + 60, this.guiTop + yBase, 40, 18, (Component)Component.m_237119_()));
        this.sy.m_257544_(Tooltip.m_257550_((Component)OnlineDisplays.gui("scale_y")));
        this.sy.m_94199_(10);
        this.sy.m_94144_(pv);
        this.sy.m_94198_();
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)OnlineDisplays.gui("apply"), btn -> this.applyChanges()).m_252987_(this.guiLeft + 176 - 80 - 6, this.guiTop + 166 - 26, 80, 20).m_257505_(Tooltip.m_257550_((Component)OnlineDisplays.gui("apply"))).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)OnlineDisplays.gui("aspect"), btn -> this.applyAspectRatio()).m_252987_(this.guiLeft + 6, this.guiTop + 166 - 26, 80, 20).m_257505_(Tooltip.m_257550_((Component)OnlineDisplays.gui("aspect"))).m_253136_());
        ((ImageButton)this.m_142416_((GuiEventListener)new ImageButton(this.guiLeft + 7 + 143, this.guiTop + 18, 20, 20, 0, 0, 20, OnlineDisplays.id("textures/gui/choose_file.png"), 40, 40, btn -> this.beginSelectingLocalFile(), OnlineDisplays.EMPTY_TXT))).m_257544_(Tooltip.m_257550_((Component)OnlineDisplays.gui("local_file")));
        this.emissiveToggle = (ImageButtonAccessor)this.m_142416_((GuiEventListener)new ImageButton(this.guiLeft + 7, this.guiTop + 117, 20, 20, 0, 0, 20, OnlineDisplays.id("textures/gui/emissive.png"), 40, 40, btn -> this.toggleEmissive(), OnlineDisplays.EMPTY_TXT));
        ((ImageButton)this.emissiveToggle).m_257544_(Tooltip.m_257550_((Component)OnlineDisplays.gui("emissive")));
        this.updateEmissive();
    }

    public void updateEmissive() {
        this.emissiveToggle.setXTexStart((Boolean)this.display.isEmissive.get() != false ? 0 : 20);
    }

    private void toggleEmissive() {
        boolean nv = (Boolean)this.display.isEmissive.get() == false;
        this.display.isEmissive.set((Object)nv);
        Network.sendToServer((IPacket)new PacketSetEmissiveFlag(this.display, nv));
        this.updateEmissive();
    }

    private void beginSelectingLocalFile() {
        FileBrowserScreen scr = new FileBrowserScreen(file -> new TransportSessionBuilder().addData(UploadLocalFileSession.generate(file, this.display)).setAcceptor(UploadLocalFileSession.class).build().sendToServer(), null);
        this.f_96541_.pushGuiLayer((Screen)scr);
    }

    private void applyChanges() {
        String cachedURL = this.url.m_94155_();
        Network.sendToServer((IPacket)new PacketUpdateTransforms(this.display));
        if (!Objects.equals(cachedURL, this.display.imageURL.get())) {
            this.display.updateURL(cachedURL);
            Network.sendToServer((IPacket)new PacketUpdateURL(this.display));
        }
    }

    private void applyAspectRatio() {
        IDisplayableTexture tex = this.display.image;
        if (tex == null) {
            return;
        }
        TileDisplay.DisplayMatrix matrix = this.display.matrix;
        float curAR = matrix.scaleX / matrix.scaleY;
        float desiredAR = (float)tex.getWidth() / (float)tex.getHeight();
        if ((double)Math.abs(curAR - desiredAR) < 1.0E-4) {
            return;
        }
        if (matrix.scaleX > matrix.scaleY) {
            float ratioW = (float)tex.getHeight() / (float)tex.getWidth();
            this.sy.m_94144_(Float.toString(ratioW * matrix.scaleX));
        } else {
            float ratioH = (float)tex.getWidth() / (float)tex.getHeight();
            this.sx.m_94144_(Float.toString(ratioH * matrix.scaleY));
        }
    }

    public void m_7861_() {
        Network.sendToServer((IPacket)new PacketRequestDisplaySync(this.display));
        super.m_7861_();
    }

    public Optional<Float> tryParseAndColorize(EditBox tf) {
        try {
            float v = Float.parseFloat(tf.m_94155_());
            if (!Float.isFinite(v)) {
                throw new NumberFormatException();
            }
            tf.m_94202_(0x22FF11);
            return Optional.of(Float.valueOf(v));
        }
        catch (Throwable e) {
            tf.m_94202_(0xFF2211);
            return Optional.empty();
        }
    }

    public void m_86600_() {
        super.m_86600_();
        this.display.matrix.translateX = this.tryParseAndColorize(this.tx).orElse(Float.valueOf(this.display.matrix.translateX)).floatValue();
        this.display.matrix.translateY = this.tryParseAndColorize(this.ty).orElse(Float.valueOf(this.display.matrix.translateY)).floatValue();
        this.display.matrix.translateZ = this.tryParseAndColorize(this.tz).orElse(Float.valueOf(this.display.matrix.translateZ)).floatValue();
        this.display.matrix.rotateX = this.tryParseAndColorize(this.rx).orElse(Float.valueOf(this.display.matrix.rotateX)).floatValue();
        this.display.matrix.rotateY = this.tryParseAndColorize(this.ry).orElse(Float.valueOf(this.display.matrix.rotateY)).floatValue();
        this.display.matrix.rotateZ = this.tryParseAndColorize(this.rz).orElse(Float.valueOf(this.display.matrix.rotateZ)).floatValue();
        this.display.matrix.scaleX = this.tryParseAndColorize(this.sx).orElse(Float.valueOf(this.display.matrix.scaleX)).floatValue();
        this.display.matrix.scaleY = this.tryParseAndColorize(this.sy).orElse(Float.valueOf(this.display.matrix.scaleY)).floatValue();
        boolean validURL = URL_MATCHER.test(this.url.m_94155_());
        this.url.m_94202_(validURL ? 0x22FF11 : 0xFF2211);
    }

    public void m_88315_(GuiGraphics mat, int mouseX, int mouseY, float partial) {
        this.m_280273_(mat);
        mat.m_280218_(this.texture, this.guiLeft, this.guiTop, 0, 0, 176, 166);
        mat.m_280614_(this.f_96547_, this.m_96636_(), this.guiLeft + 8, this.guiTop + 6, 0x3F3F3F, false);
        super.m_88315_(mat, mouseX, mouseY, partial);
    }

    public boolean m_6375_(double x, double y, int btn) {
        return super.m_6375_(x, y, btn);
    }

    public boolean m_7933_(int k1, int k2, int wtf) {
        InputConstants.Key key = InputConstants.m_84827_((int)k1, (int)k2);
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(key) && !this.url.m_93696_()) {
            this.m_7379_();
            return true;
        }
        boolean f = super.m_7933_(k1, k2, wtf);
        if (this.url.m_93696_()) {
            String cachedURL = this.url.m_94155_();
            boolean validURL = URL_MATCHER.test(cachedURL);
            this.url.m_94202_(validURL ? 0x22FF11 : 0xFF2211);
        }
        return f;
    }

    public boolean m_7043_() {
        return false;
    }
}

