/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.onlinedisplays.client.render.ister;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.zeith.onlinedisplays.client.resources.data.DrawableAreaMetadataSection;
import org.zeith.onlinedisplays.client.texture.ClientImageStorage;
import org.zeith.onlinedisplays.client.texture.IDisplayableTexture;
import org.zeith.onlinedisplays.client.texture.OnlineTextureParser;
import org.zeith.onlinedisplays.mixins.client.BakedOverrideAccessor;
import org.zeith.onlinedisplays.mixins.client.ItemOverridesAccessor;

public class DisplayISTER
extends BlockEntityWithoutLevelRenderer {
    public static final BlockEntityWithoutLevelRenderer INSTANCE = new DisplayISTER();
    private Map<ResourceLocation, DrawableAreaMetadataSection> metadataSectionMap = new HashMap<ResourceLocation, DrawableAreaMetadataSection>();

    public DisplayISTER() {
        super(null, null);
        ((ReloadableResourceManager)Minecraft.m_91087_().m_91098_()).m_7217_((PreparableReloadListener)this);
    }

    public void m_6213_(ResourceManager p_172555_) {
        this.metadataSectionMap.clear();
    }

    public Optional<DrawableAreaMetadataSection> getSectionFrom(TextureAtlasSprite tex) {
        ResourceLocation rl = tex.m_245424_().m_246162_();
        DrawableAreaMetadataSection meta = null;
        if (this.metadataSectionMap.containsKey(rl)) {
            return Optional.ofNullable(this.metadataSectionMap.get(rl));
        }
        try {
            ResourceLocation rl2 = new ResourceLocation(rl.m_135827_(), "textures/%s.png".formatted(rl.m_135815_()));
            meta = (DrawableAreaMetadataSection)Minecraft.m_91087_().m_91098_().m_215593_(rl2).m_215509_().m_214059_((MetadataSectionSerializer)DrawableAreaMetadataSection.SERIALIZER).orElseThrow();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.metadataSectionMap.put(rl, meta);
        return Optional.ofNullable(meta);
    }

    public TextureAtlasSprite renderAllOverrides(ItemStack stack, PoseStack pose, MultiBufferSource bufferSource, int uv2, int overlay) {
        ItemOverrides.BakedOverride[] overrides;
        Minecraft mc = Minecraft.m_91087_();
        ItemRenderer ir = mc.m_91291_();
        BakedModel isterModel = ir.m_174264_(stack, (Level)mc.f_91073_, (LivingEntity)mc.f_91074_, 0);
        for (ItemOverrides.BakedOverride override : overrides = ((ItemOverridesAccessor)isterModel.m_7343_()).getOverrides()) {
            BakedModel overridenModel = ((BakedOverrideAccessor)override).getModel();
            if (overridenModel == null) continue;
            for (BakedModel model : overridenModel.getRenderPasses(stack, true)) {
                for (RenderType pass : model.getRenderTypes(stack, true)) {
                    VertexConsumer buf = bufferSource.m_6299_(pass);
                    ir.m_115189_(overridenModel, stack, uv2, overlay, pose, buf);
                }
            }
        }
        return isterModel.getParticleIcon(ModelData.EMPTY);
    }

    public void m_108829_(ItemStack stack, ItemDisplayContext tt, PoseStack mat, MultiBufferSource src, int uv2, int overlay) {
        TextureAtlasSprite tex = this.renderAllOverrides(stack, mat, src, uv2, overlay);
        if (tex == null) {
            return;
        }
        DrawableAreaMetadataSection meta = this.getSectionFrom(tex).orElse(null);
        if (meta == null) {
            return;
        }
        CompoundTag beTag = stack.m_41737_("BlockEntityTag");
        if (beTag == null) {
            return;
        }
        beTag = beTag.m_128469_("HL");
        String hash = beTag.m_128461_("dataHash");
        String url = beTag.m_128461_("url");
        if (hash.isEmpty() || !ClientImageStorage.isHashedOrRequest(hash, url)) {
            return;
        }
        boolean emissive = beTag.m_128471_("emissive");
        IDisplayableTexture tx = OnlineTextureParser.getTextureByHash(hash);
        if (tx != null) {
            float min;
            float normalY;
            RenderType type = RenderType.m_110473_((ResourceLocation)tx.getPath(System.currentTimeMillis()));
            VertexConsumer builder = src.m_6299_(type);
            boolean gui = tt == ItemDisplayContext.GUI;
            boolean thirdPerson = tt == ItemDisplayContext.THIRD_PERSON_LEFT_HAND || tt == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
            float normalX = 0.0f;
            float f = normalY = gui ? -1.0f : 0.0f;
            float normalZ = gui ? 0.0f : (thirdPerson ? 1.0f : -1.0f);
            float w = meta.textureWidth;
            float h = meta.textureHeight;
            float aspectRatio = (float)tx.getWidth() / (float)tx.getHeight();
            mat.m_85836_();
            float x = (float)meta.x / w;
            float y = (float)meta.y / h;
            float viewW = (float)meta.width / w;
            float viewH = (float)meta.height / h;
            float xWRef = (float)meta.width / w;
            float yHRef = (float)meta.height / h;
            float xW = xWRef;
            float yH = yHRef;
            xW = min = Math.min(xW, yH);
            yH = min;
            if (aspectRatio > 1.0f) {
                yH /= aspectRatio;
            } else {
                xW *= aspectRatio;
            }
            if (xW < xWRef && yH < yHRef) {
                float upscaleRate = Math.min(xWRef / xW, yHRef / yH);
                xW *= upscaleRate;
                yH *= upscaleRate;
            }
            mat.m_85837_((double)(x += (viewW - xW) / 2.0f), (double)(y += (viewH - yH) / 2.0f), 0.531875);
            mat.m_85841_(xW, yH, xW);
            PoseStack.Pose matrixstack$entry = mat.m_85850_();
            Matrix4f pose = matrixstack$entry.m_252922_();
            Matrix3f normal = matrixstack$entry.m_252943_();
            if (emissive) {
                uv2 = 0xF000F0;
            }
            builder.m_252986_(pose, 0.0f, 0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 1.0f).m_86008_(overlay).m_85969_(uv2).m_252939_(normal, normalX, normalY, normalZ).m_5752_();
            builder.m_252986_(pose, 0.0f, 1.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 0.0f).m_86008_(overlay).m_85969_(uv2).m_252939_(normal, normalX, normalY, normalZ).m_5752_();
            builder.m_252986_(pose, 1.0f, 1.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 0.0f).m_86008_(overlay).m_85969_(uv2).m_252939_(normal, normalX, normalY, normalZ).m_5752_();
            builder.m_252986_(pose, 1.0f, 0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 1.0f).m_86008_(overlay).m_85969_(uv2).m_252939_(normal, normalX, normalY, normalZ).m_5752_();
            mat.m_85849_();
        }
    }
}

