/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.onlinedisplays.client.texture;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.StringUtil;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.Network;
import org.zeith.onlinedisplays.OnlineDisplays;
import org.zeith.onlinedisplays.api.IImageDataContainer;
import org.zeith.onlinedisplays.net.PacketRequestImageData;
import org.zeith.onlinedisplays.util.ImageData;

public class ClientImageStorage {
    public static final IImageDataContainer INSTANCE = new IImageDataContainer(){

        @Override
        public ImageData load(String hash) {
            return ClientImageStorage.load(hash);
        }

        @Override
        public boolean has(String hash) {
            return ClientImageStorage.getHashFile(hash).isFile();
        }

        @Override
        public void save(ImageData data) {
            ClientImageStorage.save(data);
        }
    };
    static final Map<String, Boolean> HASHED = new HashMap<String, Boolean>();
    static final Set<String> REQUESTED = new HashSet<String>();

    public static File getImageCacheDir() {
        File hid = new File(OnlineDisplays.getModDir(), "image_cache");
        if (!hid.isDirectory()) {
            hid.mkdirs();
        }
        return hid;
    }

    public static void clearRequestFlag(String hash) {
        REQUESTED.remove(hash);
    }

    private static File getHashFile(String hash) {
        File fl = new File(ClientImageStorage.getImageCacheDir(), hash.substring(0, 2));
        if (!fl.isDirectory()) {
            fl.mkdirs();
        }
        fl = new File(fl, hash + ".bin");
        return fl;
    }

    public static boolean isHashedOrRequest(String hash, String url) {
        if (ClientImageStorage.isHashed(hash)) {
            return true;
        }
        if (!REQUESTED.contains(hash)) {
            Network.sendToServer((IPacket)new PacketRequestImageData(hash, url));
            REQUESTED.add(hash);
        }
        return false;
    }

    public static boolean isHashed(String hash) {
        return HASHED.computeIfAbsent(hash, h -> ClientImageStorage.getHashFile(h).isFile());
    }

    public static String save(ImageData data) {
        String hash = data.getHash();
        File fl = ClientImageStorage.getHashFile(hash);
        if (fl.isFile()) {
            return hash;
        }
        try (DataOutputStream dos = new DataOutputStream(new FileOutputStream(fl));){
            data.write(dos);
        }
        catch (IOException e) {
            OnlineDisplays.LOG.fatal("Failed to save image", (Throwable)e);
            fl.delete();
        }
        if (fl.isFile()) {
            REQUESTED.remove(hash);
            HASHED.remove(hash);
        }
        return hash;
    }

    public static ImageData load(String hash) {
        if (StringUtil.m_14408_((String)hash)) {
            return null;
        }
        File fl = ClientImageStorage.getHashFile(hash);
        if (fl.isFile()) {
            ImageData imageData;
            DataInputStream in = new DataInputStream(new FileInputStream(fl));
            try {
                imageData = new ImageData(in);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    OnlineDisplays.LOG.fatal("Failed to read image", (Throwable)e);
                }
            }
            in.close();
            return imageData;
        }
        return null;
    }
}

