/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.onlinedisplays.net;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.zeith.hammerlib.net.INBTPacket;
import org.zeith.hammerlib.net.MainThreaded;
import org.zeith.hammerlib.net.PacketContext;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.onlinedisplays.client.gui.GuiDisplayConfig;
import org.zeith.onlinedisplays.tiles.TileDisplay;

@MainThreaded
public class PacketOpenDisplayConfig
implements INBTPacket {
    private BlockPos pos;
    private TileDisplay.DisplayMatrix mat;
    private String url;

    public PacketOpenDisplayConfig(TileDisplay tile) {
        this.pos = tile.m_58899_();
        this.mat = tile.matrix;
        this.url = (String)tile.imageURL.get();
    }

    public PacketOpenDisplayConfig() {
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeLong(this.pos.m_121878_());
        buf.m_130079_(this.mat.serializeNBT());
        buf.m_130070_(this.url != null ? this.url : "");
    }

    public void read(FriendlyByteBuf buf) {
        this.pos = BlockPos.m_122022_((long)buf.readLong());
        this.mat = new TileDisplay.DisplayMatrix();
        this.mat.deserializeNBT(buf.m_130260_());
        this.url = buf.m_130277_();
        if (this.url.isEmpty()) {
            this.url = null;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientExecute(PacketContext ctx) {
        TileDisplay display;
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        if (level != null && (display = (TileDisplay)((Object)Cast.cast((Object)level.m_7702_(this.pos), TileDisplay.class))) != null) {
            display.matrix.deserializeNBT(this.mat.serializeNBT());
            display.updateURL(this.url);
            mc.m_91152_((Screen)new GuiDisplayConfig(display));
        }
    }
}

