/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.onlinedisplays.net;

import java.util.Locale;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.PacketContext;
import org.zeith.onlinedisplays.OnlineDisplays;
import org.zeith.onlinedisplays.level.LevelImageStorage;
import org.zeith.onlinedisplays.net.TransferImageSession;
import org.zeith.onlinedisplays.util.ImageData;

public class PacketRequestImageData
implements IPacket {
    String hash;
    String optURL;

    public PacketRequestImageData(String hash, String optURL) {
        this.hash = hash;
        this.optURL = optURL;
    }

    public PacketRequestImageData() {
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130070_(this.hash);
        buf.m_130070_(this.optURL);
    }

    public void read(FriendlyByteBuf buf) {
        this.hash = buf.m_130277_();
        this.optURL = buf.m_130277_();
    }

    public void serverExecute(PacketContext ctx) {
        ServerPlayer sender = ctx.getSender();
        if (sender != null) {
            ServerLevel level = sender.m_284548_();
            ImageData image = LevelImageStorage.get(level).load(this.hash);
            if (image != null) {
                UUID id = sender.m_20148_();
                TransferImageSession.sendTo(image, p -> p.m_20148_().equals(id));
                OnlineDisplays.LOG.info("Sending " + image.getFileName() + " to " + sender.m_7755_().getString());
            } else {
                OnlineDisplays.LOG.error("Unable to find " + this.hash + ", requested by " + sender.m_7755_().getString());
                if (this.optURL != null && !this.optURL.isEmpty() && !this.optURL.toLowerCase(Locale.ROOT).startsWith("local/")) {
                    OnlineDisplays.LOG.info("Downloading hash from " + this.optURL);
                    LevelImageStorage.get(level).queueDownload(this.optURL, sender.m_20148_());
                }
            }
        }
    }
}

