/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.onlinedisplays.net;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.util.function.Predicate;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import org.zeith.hammerlib.net.MainThreaded;
import org.zeith.hammerlib.net.PacketContext;
import org.zeith.hammerlib.net.lft.ITransportAcceptor;
import org.zeith.hammerlib.net.lft.TransportSession;
import org.zeith.hammerlib.net.lft.TransportSessionBuilder;
import org.zeith.onlinedisplays.OnlineDisplays;
import org.zeith.onlinedisplays.util.ImageData;

@MainThreaded
public class TransferImageSession
implements ITransportAcceptor {
    ImageData imageData;
    Exception error;
    boolean valid;

    public static void sendTo(ImageData data, Predicate<ServerPlayer> predicate) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        try {
            data.write(out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TransportSession session = new TransportSessionBuilder().setAcceptor(TransferImageSession.class).addData(baos.toByteArray()).build();
        MinecraftServer mcs = (MinecraftServer)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.SERVER);
        if (mcs != null) {
            for (ServerPlayer mp : mcs.m_6846_().m_11314_()) {
                if (!predicate.test(mp)) continue;
                if (OnlineDisplays.PROXY.isLocalPlayer(mp)) {
                    TransferImageSession local = new TransferImageSession();
                    local.valid = true;
                    local.imageData = data;
                    OnlineDisplays.PROXY.applyClientPicture(local, null);
                    OnlineDisplays.LOG.info("Applied image " + data.getHash() + " to host (" + mp.m_36316_().getName() + ") using memory connection.");
                    continue;
                }
                session.sendTo(mp);
            }
        }
    }

    public void read(InputStream readable, int length) {
        try (DataInputStream in = new DataInputStream(readable);){
            this.imageData = new ImageData(in);
            this.valid = true;
        }
        catch (Exception e) {
            this.valid = false;
            this.error = e;
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public Exception getError() {
        return this.error;
    }

    public ImageData getImageData() {
        return this.imageData;
    }

    public void onTransmissionComplete(PacketContext ctx) {
        OnlineDisplays.PROXY.applyClientPicture(this, ctx);
    }
}

