/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.onlinedisplays.net;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import net.minecraft.core.BlockPos;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraftforge.common.util.LogicalSidedProvider;
import org.zeith.hammerlib.net.MainThreaded;
import org.zeith.hammerlib.net.PacketContext;
import org.zeith.hammerlib.net.lft.ITransportAcceptor;
import org.zeith.onlinedisplays.OnlineDisplays;
import org.zeith.onlinedisplays.tiles.TileDisplay;

@MainThreaded
public class UploadLocalFileSession
implements ITransportAcceptor {
    BlockPos position;
    byte[] imageData;
    String fileName;
    Exception error;
    boolean valid;

    public static byte[] generate(File file, TileDisplay tile) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        try {
            out.writeLong(tile.m_58899_().m_121878_());
            out.writeUTF(file.getName());
            byte[] image = Files.readAllBytes(file.toPath());
            out.writeInt(image.length);
            out.write(image);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return baos.toByteArray();
    }

    public void read(InputStream readable, int length) {
        try (DataInputStream in = new DataInputStream(readable);){
            int r;
            this.position = BlockPos.m_122022_((long)in.readLong());
            OnlineDisplays.LOG.info("Reading LOCAL display image for " + this.position);
            this.fileName = in.readUTF();
            this.imageData = new byte[in.readInt()];
            int ptr = 0;
            while ((r = in.read(this.imageData, ptr, this.imageData.length - ptr)) > 0) {
                ptr += r;
            }
            if (ptr < this.imageData.length) {
                this.imageData = null;
                throw new EOFException();
            }
            this.valid = true;
        }
        catch (Exception e) {
            this.valid = false;
            this.error = e;
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public BlockPos getPosition() {
        return this.position;
    }

    public String getFileName() {
        return this.fileName;
    }

    public byte[] getImageData() {
        return this.imageData;
    }

    public Exception getError() {
        return this.error;
    }

    public void onTransmissionComplete(PacketContext ctx) {
        BlockableEventLoop executor = (BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(ctx.getSide());
        executor.m_18689_(() -> OnlineDisplays.PROXY.uploadServerPicture(this, ctx));
    }
}

