/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.onlinedisplays.proxy;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.LogicalSide;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.Network;
import org.zeith.hammerlib.net.PacketContext;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.onlinedisplays.OnlineDisplays;
import org.zeith.onlinedisplays.api.IImageDataContainer;
import org.zeith.onlinedisplays.client.texture.IDisplayableTexture;
import org.zeith.onlinedisplays.level.LevelImageStorage;
import org.zeith.onlinedisplays.net.PacketUpdateURL;
import org.zeith.onlinedisplays.net.TransferImageSession;
import org.zeith.onlinedisplays.net.UploadLocalFileSession;
import org.zeith.onlinedisplays.tiles.TileDisplay;

public class CommonODProxy {
    public void construct() {
    }

    public boolean isLocalPlayer(ServerPlayer player) {
        return false;
    }

    public IImageDataContainer getImageContainer(Level world) {
        if (world instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)world;
            return LevelImageStorage.get(sl);
        }
        return IImageDataContainer.DUMMY;
    }

    public IDisplayableTexture resolveTexture(TileDisplay display) {
        return null;
    }

    public boolean isCurrentlyEditing(TileDisplay display) {
        return false;
    }

    public boolean isCreative() {
        return false;
    }

    public void applyClientPicture(TransferImageSession session, PacketContext ctx) {
    }

    public void uploadServerPicture(UploadLocalFileSession session, PacketContext ctx) {
        if (ctx.getSide() == LogicalSide.SERVER) {
            if (session.isValid()) {
                OnlineDisplays.LOG.info("Saving " + session.getFileName() + " byte[" + session.getImageData().length + "] image for " + session.getPosition());
                ServerPlayer sender = ctx.getSender();
                if (sender != null) {
                    BlockEntity be = sender.m_9236_().m_7702_(session.getPosition());
                    TileDisplay display = (TileDisplay)((Object)Cast.cast((Object)be, TileDisplay.class));
                    if (display != null) {
                        display.setLocalImage(session.getImageData(), session.getFileName(), sender.m_7755_());
                        Network.sendTo((ServerPlayer)sender, (IPacket)new PacketUpdateURL(display));
                    } else {
                        OnlineDisplays.LOG.warn("Unable to find display block at " + session.getPosition() + " (found " + be + ")");
                    }
                } else {
                    OnlineDisplays.LOG.warn("Unable to find image sender for " + session.getPosition());
                }
            } else {
                OnlineDisplays.LOG.error("Failed to load display at " + session.getPosition(), (Throwable)session.getError());
            }
        }
    }
}

