/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.onlinedisplays.tiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringUtil;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.zeith.hammerlib.api.io.IAutoNBTSerializable;
import org.zeith.hammerlib.api.io.NBTSerializable;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.Network;
import org.zeith.hammerlib.net.properties.IProperty;
import org.zeith.hammerlib.net.properties.PropertyBool;
import org.zeith.hammerlib.net.properties.PropertyString;
import org.zeith.hammerlib.tiles.TileSyncableTickable;
import org.zeith.hammerlib.util.java.DirectStorage;
import org.zeith.onlinedisplays.OnlineDisplays;
import org.zeith.onlinedisplays.client.texture.IDisplayableTexture;
import org.zeith.onlinedisplays.init.TilesOD;
import org.zeith.onlinedisplays.level.LevelImageStorage;
import org.zeith.onlinedisplays.net.PacketClearRequestFlag;
import org.zeith.onlinedisplays.net.PacketRequestDisplaySync;
import org.zeith.onlinedisplays.util.ImageData;

public class TileDisplay
extends TileSyncableTickable {
    @NBTSerializable
    private String url = "";
    @NBTSerializable
    private String fileName = "";
    @NBTSerializable
    private boolean loaded;
    @NBTSerializable
    private boolean emissive;
    @NBTSerializable
    public final DisplayMatrix matrix = new DisplayMatrix();
    @NBTSerializable
    private String dataHash = "";
    public final PropertyString imageURL = new PropertyString(DirectStorage.create($ -> {
        this.url = $;
    }, () -> this.url));
    public final PropertyString imageHash = new PropertyString(DirectStorage.create($ -> {
        this.dataHash = $;
    }, () -> this.dataHash));
    public final PropertyBool isLoaded = new PropertyBool(DirectStorage.create($ -> {
        this.loaded = $;
    }, () -> this.loaded));
    public final PropertyBool isEmissive = new PropertyBool(DirectStorage.create($ -> {
        this.emissive = $;
    }, () -> this.emissive));
    public boolean isSynced;
    public IDisplayableTexture image;

    public TileDisplay(BlockPos pos, BlockState state) {
        super(TilesOD.DISPLAY, pos, state);
        this.dispatcher.registerProperty("url", (IProperty)this.imageURL);
        this.dispatcher.registerProperty("hash", (IProperty)this.imageHash);
        this.dispatcher.registerProperty("loaded", (IProperty)this.isLoaded);
        this.dispatcher.registerProperty("emissive", (IProperty)this.isEmissive);
    }

    public boolean canEdit(ServerPlayer player) {
        return player != null && (player.m_7500_() || OnlineDisplays.getModSettings().survivalMode) && !player.m_36187_(this.f_58857_, this.f_58858_, player.f_8941_.m_9290_());
    }

    public void update() {
        Level level;
        MinecraftServer server;
        if (this.isOnClient()) {
            if (!this.isSynced) {
                Network.sendToServer((IPacket)new PacketRequestDisplaySync(this));
                this.isSynced = true;
            } else if (this.image == null || !Objects.equals(this.image.getHash(), this.imageHash.get())) {
                this.image = OnlineDisplays.PROXY.resolveTexture(this);
            }
        }
        if (this.isOnServer() && this.atTickRate(20) && (server = this.f_58857_.m_7654_()) != null && (level = this.f_58857_) instanceof ServerLevel) {
            ClientboundBlockEntityDataPacket pkt;
            String hash;
            ServerLevel sw = (ServerLevel)level;
            LevelImageStorage storage = LevelImageStorage.get(sw);
            if (!StringUtil.m_14408_((String)((String)this.imageURL.get())) && OnlineDisplays.URL_TEST.test((String)this.imageURL.get()) && (hash = (String)storage.queueDownload((String)this.imageURL.get(), new UUID[0]).orElse(null)) != null) {
                this.imageHash.set((Object)hash);
            }
            if ((pkt = this.getUpdatePacket()) != null) {
                sw.m_7726_().f_8325_.m_183262_(new ChunkPos(this.f_58858_), false).forEach(e -> e.f_8906_.m_9829_((Packet)pkt));
            }
        }
    }

    public void updateURL(String url) {
        this.updateURL(url, false);
    }

    public void updateURL(String url, boolean reDownload) {
        if (url == null) {
            url = "";
        }
        if (Objects.equals(this.imageURL.get(), url) && !reDownload) {
            return;
        }
        this.imageURL.set((Object)url);
        if (url.startsWith("local/")) {
            this.isLoaded.set((Object)false);
            this.imageHash.set((Object)url.substring(6));
            return;
        }
        if (!this.f_58857_.f_46443_) {
            this.isLoaded.set((Object)false);
            this.imageHash.set((Object)"");
        }
    }

    public void setLocalImage(byte[] newValue, String fileName, Object sender) {
        this.isLoaded.set((Object)(newValue != null && newValue.length > 0 ? 1 : 0));
        if (newValue == null) {
            this.imageHash.set((Object)"");
            return;
        }
        ImageData id = new ImageData(fileName, newValue);
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            LevelImageStorage.get(sl).save(id);
        }
        String hash = id.getHash();
        this.updateURL("local/" + hash);
        this.imageHash.set((Object)hash);
        Network.sendToAll((IPacket)new PacketClearRequestFlag(hash));
        this.sync();
        OnlineDisplays.LOG.info("Uploaded " + fileName + " (" + hash + ") from " + sender);
    }

    public void updateCache(byte[] newValue, String fileName) {
        this.isLoaded.set((Object)(newValue != null && newValue.length > 0 ? 1 : 0));
        if (newValue == null) {
            this.imageHash.set((Object)"");
            return;
        }
        ImageData id = new ImageData(fileName, newValue);
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            LevelImageStorage.get(sl).save(id);
        }
        String hash = id.getHash();
        this.imageHash.set((Object)hash);
        Network.sendToAll((IPacket)new PacketClearRequestFlag(hash));
        this.sync();
        OnlineDisplays.LOG.info("Downloaded " + fileName + " (" + hash + ")");
    }

    public AABB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        if (OnlineDisplays.PROXY.isCurrentlyEditing(this)) {
            return;
        }
        super.onDataPacket(net, packet);
    }

    public static class DisplayMatrix
    implements IAutoNBTSerializable {
        @NBTSerializable(value="sx")
        public float scaleX = 1.0f;
        @NBTSerializable(value="sy")
        public float scaleY = 1.0f;
        @NBTSerializable(value="tx")
        public float translateX;
        @NBTSerializable(value="ty")
        public float translateY;
        @NBTSerializable(value="tz")
        public float translateZ;
        @NBTSerializable(value="rx")
        public float rotateX;
        @NBTSerializable(value="ry")
        public float rotateY;
        @NBTSerializable(value="rz")
        public float rotateZ;

        @OnlyIn(value=Dist.CLIENT)
        public void apply(PoseStack pose) {
            pose.m_252880_(this.translateX, this.translateY, this.translateZ);
            pose.m_252781_(Axis.f_252436_.m_252977_(this.rotateY));
            pose.m_252781_(Axis.f_252529_.m_252977_(this.rotateX));
            pose.m_252781_(Axis.f_252403_.m_252977_(this.rotateZ));
            pose.m_85841_(this.scaleX, this.scaleY, 1.0f);
        }
    }
}

