/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.webp4j;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Optional;
import org.zeith.hammerlib.util.java.OSArch;
import org.zeith.onlinedisplays.OnlineDisplays;

public class WebP {
    private final File webPExe;

    public WebP(File workDir) {
        if (!workDir.isDirectory()) {
            workDir.mkdirs();
        }
        boolean isWindows = OSArch.getArchitecture().getType() == OSArch.OSType.WINDOWS;
        this.webPExe = new File(workDir, "dwebp" + (isWindows ? ".exe" : ""));
    }

    public File getWebPExe() throws IOException {
        if (!this.webPExe.isFile()) {
            String file = "windows";
            OSArch.ArchDistro arch = OSArch.getArchitecture();
            if (arch.getType() == OSArch.OSType.UNIX) {
                file = "linux";
            } else if (arch == OSArch.ArchDistro.MACOS_INTEL) {
                file = "mac_intel";
            } else if (arch == OSArch.ArchDistro.MACOS_APPLE) {
                file = "mac_arm";
            }
            try (InputStream in = WebP.class.getResourceAsStream("/assets/onlinedisplays/dwebp/" + file);){
                Files.copy(in, this.webPExe.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        return this.webPExe;
    }

    public Optional<byte[]> convert(File webpFile) throws IOException {
        int code;
        File pngFile = File.createTempFile("onlinedisplays_webp", "tmpnet.png");
        try {
            String webpPath;
            block8: {
                File webp = this.getWebPExe().getAbsoluteFile();
                webpPath = webp.getCanonicalPath();
                if (!webp.canExecute()) {
                    if (!webp.setExecutable(true)) {
                        OnlineDisplays.LOG.warn("Unable to make " + webpPath + " as executable via java, attempting chmod.");
                        try {
                            ProcessBuilder chmodProcessBuilder = new ProcessBuilder("chmod", "+x", webpPath);
                            Process chmodProcess = chmodProcessBuilder.start();
                            int chmodExitCode = chmodProcess.waitFor();
                            if (chmodExitCode != 0) {
                                throw new IOException("Failed to add executable permissions to the app file: " + webpPath);
                            }
                            break block8;
                        }
                        catch (IOException | InterruptedException e) {
                            IOException ie;
                            throw e instanceof IOException ? (ie = (IOException)e) : new IOException(e);
                        }
                    }
                    OnlineDisplays.LOG.info("Marked " + webpPath + " as executable OK.");
                }
            }
            Object[] command = new String[]{webpPath, webpFile.getAbsoluteFile().getCanonicalPath(), "-mt", "-o", pngFile.getAbsoluteFile().getCanonicalPath()};
            OnlineDisplays.LOG.info("Launching dwebp with command: " + Arrays.toString(command));
            code = new ProcessBuilder((String[])command).start().waitFor();
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
        if (code != 0 || !pngFile.isFile()) {
            webpFile.delete();
            pngFile.delete();
            throw new IOException("Unable to convert webp image. Code " + code);
        }
        byte[] raster = pngFile.isFile() ? Files.readAllBytes(pngFile.toPath()) : null;
        pngFile.delete();
        return Optional.ofNullable(raster);
    }
}

