/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.block.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeList;
import thelm.packagedauto.api.IPackageRecipeListItem;
import thelm.packagedauto.block.EncoderBlock;
import thelm.packagedauto.block.entity.BaseBlockEntity;
import thelm.packagedauto.inventory.EncoderItemHandler;
import thelm.packagedauto.inventory.EncoderPatternItemHandler;
import thelm.packagedauto.menu.EncoderMenu;

public class EncoderBlockEntity
extends BaseBlockEntity {
    public static final BlockEntityType<EncoderBlockEntity> TYPE_INSTANCE = BlockEntityType.Builder.m_155273_(EncoderBlockEntity::new, (Block[])new Block[]{EncoderBlock.INSTANCE}).m_58966_(null);
    public static int patternSlots = 20;
    public static Set<String> disabledRecipeTypes = Set.of();
    public final EncoderPatternItemHandler[] patternItemHandlers = new EncoderPatternItemHandler[patternSlots];
    public int patternIndex;

    public EncoderBlockEntity(BlockPos pos, BlockState state) {
        super(TYPE_INSTANCE, pos, state);
        this.setItemHandler(new EncoderItemHandler(this));
        for (int i = 0; i < this.patternItemHandlers.length; ++i) {
            this.patternItemHandlers[i] = new EncoderPatternItemHandler(this);
        }
    }

    @Override
    protected Component getDefaultName() {
        return Component.m_237115_((String)"block.packagedauto.encoder");
    }

    public void m_142339_(Level level) {
        super.m_142339_(level);
        for (EncoderPatternItemHandler inv : this.patternItemHandlers) {
            inv.updateRecipeInfo(false);
        }
    }

    @Override
    public void loadSync(CompoundTag nbt) {
        super.loadSync(nbt);
        this.patternIndex = nbt.m_128445_("PatternIndex");
        for (int i = 0; i < this.patternItemHandlers.length; ++i) {
            this.patternItemHandlers[i].load(nbt.m_128469_(String.format("Pattern%02d", i)));
        }
    }

    @Override
    public CompoundTag saveSync(CompoundTag nbt) {
        super.saveSync(nbt);
        nbt.m_128344_("PatternIndex", (byte)this.patternIndex);
        for (int i = 0; i < this.patternItemHandlers.length; ++i) {
            CompoundTag subNBT = new CompoundTag();
            this.patternItemHandlers[i].save(subNBT);
            nbt.m_128365_(String.format("Pattern%02d", i), (Tag)subNBT);
        }
        return nbt;
    }

    public void setPatternIndex(int patternIndex) {
        this.patternIndex = patternIndex;
        this.sync(false);
        this.m_6596_();
    }

    public void saveRecipeList(boolean single) {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        Item item = stack.m_41720_();
        if (item instanceof IPackageRecipeListItem) {
            IPackageRecipeListItem recipeListItem = (IPackageRecipeListItem)item;
            IPackageRecipeList recipeListObj = recipeListItem.getRecipeList(stack);
            ArrayList<IPackageRecipeInfo> recipeList = new ArrayList<IPackageRecipeInfo>();
            if (!single) {
                for (EncoderPatternItemHandler inv : this.patternItemHandlers) {
                    if (inv.recipeInfo == null) continue;
                    recipeList.add(inv.recipeInfo);
                }
            } else {
                EncoderPatternItemHandler inv = this.patternItemHandlers[this.patternIndex];
                if (inv.recipeInfo != null) {
                    recipeList.add(inv.recipeInfo);
                }
            }
            recipeListObj.setRecipeList(recipeList);
            recipeListItem.setRecipeList(stack, recipeListObj);
        }
    }

    public void loadRecipeList(boolean single, boolean clear) {
        block8: {
            block5: {
                List<IPackageRecipeInfo> recipeList;
                block6: {
                    EncoderPatternItemHandler inv;
                    block7: {
                        ItemStack stack = this.itemHandler.getStackInSlot(0);
                        EncoderPatternItemHandler[] encoderPatternItemHandlerArray = stack.m_41720_();
                        if (!(encoderPatternItemHandlerArray instanceof IPackageRecipeListItem)) break block5;
                        IPackageRecipeListItem recipeListItem = (IPackageRecipeListItem)encoderPatternItemHandlerArray;
                        IPackageRecipeList recipeListObj = recipeListItem.getRecipeList(stack);
                        recipeList = recipeListObj.getRecipeList();
                        if (!single) break block6;
                        inv = this.patternItemHandlers[this.patternIndex];
                        if (clear || recipeList.isEmpty()) break block7;
                        IPackageRecipeInfo recipe = recipeList.get(0);
                        if (!recipe.isValid()) break block8;
                        inv.setRecipe(recipe.getEncoderStacks());
                        break block8;
                    }
                    inv.setRecipe(null);
                    break block8;
                }
                for (int i = 0; i < this.patternItemHandlers.length; ++i) {
                    EncoderPatternItemHandler inv = this.patternItemHandlers[i];
                    if (!clear && i < recipeList.size()) {
                        IPackageRecipeInfo recipe = recipeList.get(i);
                        inv.recipeType = recipe.getRecipeType();
                        if (!recipe.isValid()) continue;
                        inv.setRecipe(recipe.getEncoderStacks());
                        continue;
                    }
                    inv.setRecipe(null);
                }
                break block8;
            }
            if (single) {
                this.patternItemHandlers[this.patternIndex].setRecipe(null);
            } else {
                for (EncoderPatternItemHandler inv : this.patternItemHandlers) {
                    inv.setRecipe(null);
                }
            }
        }
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
        this.sync(false);
        return new EncoderMenu(windowId, inventory, this);
    }
}

