/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.block.entity;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.booleans.BooleanList;
import it.unimi.dsi.fastutil.booleans.BooleanListIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.IItemHandler;
import thelm.packagedauto.api.IPackageCraftingMachine;
import thelm.packagedauto.api.IPackageItem;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeList;
import thelm.packagedauto.api.ISettingsCloneable;
import thelm.packagedauto.api.IVolumePackageItem;
import thelm.packagedauto.block.UnpackagerBlock;
import thelm.packagedauto.block.entity.BaseBlockEntity;
import thelm.packagedauto.block.entity.PackagerBlockEntity;
import thelm.packagedauto.block.entity.PackagerExtensionBlockEntity;
import thelm.packagedauto.energy.EnergyStorage;
import thelm.packagedauto.integration.appeng.blockentity.AEUnpackagerBlockEntity;
import thelm.packagedauto.inventory.UnpackagerItemHandler;
import thelm.packagedauto.item.RecipeHolderItem;
import thelm.packagedauto.menu.UnpackagerMenu;
import thelm.packagedauto.util.MiscHelper;

public class UnpackagerBlockEntity
extends BaseBlockEntity
implements ISettingsCloneable {
    public static final BlockEntityType<UnpackagerBlockEntity> TYPE_INSTANCE = BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)((BlockEntityType.BlockEntitySupplier)MiscHelper.INSTANCE.conditionalSupplier(() -> ModList.get().isLoaded("ae2"), () -> () -> AEUnpackagerBlockEntity::new, () -> () -> UnpackagerBlockEntity::new).get()), (Block[])new Block[]{UnpackagerBlock.INSTANCE}).m_58966_(null);
    public static int energyCapacity = 5000;
    public static int energyUsage = 50;
    public static int refreshInterval = 4;
    public static boolean drawMEEnergy = true;
    public boolean firstTick = true;
    public final PackageTracker[] trackers = new PackageTracker[10];
    public List<IPackageRecipeInfo> recipeList = new ArrayList<IPackageRecipeInfo>();
    public boolean powered = false;
    public boolean blocking = false;
    public int trackerCount = 6;
    public int roundRobinIndex = 0;

    public UnpackagerBlockEntity(BlockPos pos, BlockState state) {
        super(TYPE_INSTANCE, pos, state);
        this.setItemHandler(new UnpackagerItemHandler(this));
        this.setEnergyStorage(new EnergyStorage(this, energyCapacity));
        for (int i = 0; i < this.trackers.length; ++i) {
            this.trackers[i] = new PackageTracker();
        }
    }

    @Override
    protected Component getDefaultName() {
        return Component.m_237115_((String)"block.packagedauto.unpackager");
    }

    @Override
    public String getConfigTypeName() {
        return "block.packagedauto.unpackager";
    }

    @Override
    public void tick() {
        if (this.firstTick) {
            this.firstTick = false;
            if (!this.f_58857_.f_46443_) {
                this.postPatternChange();
            }
            this.updatePowered();
        }
        if (!this.f_58857_.f_46443_) {
            this.chargeEnergy();
            if (this.f_58857_.m_46467_() % (long)refreshInterval == 0L) {
                this.fillTrackers();
                this.emptyTrackers();
            }
        }
    }

    protected void fillTrackers() {
        List<PackageTracker> emptyTrackers = Arrays.stream(this.trackers).limit(this.trackerCount).filter(t -> t.isEmpty()).toList();
        List<PackageTracker> nonEmptyTrackers = Arrays.stream(this.trackers).filter(t -> !t.isEmpty()).filter(t -> !t.isFilled()).toList();
        block0: for (int i = 0; i < 9; ++i) {
            Item item;
            ItemStack stack;
            if (this.energyStorage.getEnergyStored() < energyUsage || (stack = this.itemHandler.getStackInSlot(i)).m_41619_() || !((item = stack.m_41720_()) instanceof IPackageItem)) continue;
            IPackageItem packageItem = (IPackageItem)item;
            boolean flag = false;
            for (PackageTracker tracker : nonEmptyTrackers) {
                if (tracker.tryAcceptPackage(packageItem, stack, i)) {
                    flag = true;
                    stack.m_41774_(1);
                    if (stack.m_41619_()) {
                        this.itemHandler.setStackInSlot(i, ItemStack.f_41583_);
                    } else {
                        tracker.setRejectedIndex(i, true);
                    }
                    this.energyStorage.extractEnergy(energyUsage, false);
                    break;
                }
                tracker.setRejectedIndex(i, true);
            }
            if (flag) continue;
            for (PackageTracker tracker : emptyTrackers) {
                if (tracker.tryAcceptPackage(packageItem, stack, i)) {
                    stack.m_41774_(1);
                    if (stack.m_41619_()) {
                        this.itemHandler.setStackInSlot(i, ItemStack.f_41583_);
                    } else {
                        tracker.setRejectedIndex(i, true);
                    }
                    this.energyStorage.extractEnergy(energyUsage, false);
                    continue block0;
                }
                tracker.setRejectedIndex(i, true);
            }
        }
    }

    protected void emptyTrackers() {
        ArrayList directions = Lists.newArrayList((Object[])Direction.values());
        Collections.rotate(directions, this.roundRobinIndex);
        block0: for (Direction direction : directions) {
            PackageTracker[] packageTrackerArray = this.f_58857_.m_7702_(this.f_58858_.m_121945_(direction));
            if (!(packageTrackerArray instanceof IPackageCraftingMachine)) continue;
            IPackageCraftingMachine machine = (IPackageCraftingMachine)packageTrackerArray;
            for (PackageTracker tracker : this.trackers) {
                if (!tracker.isFilled() || tracker.recipe == null || !tracker.recipe.getRecipeType().hasMachine() || machine.isBusy() || !machine.acceptPackage(tracker.recipe, Lists.transform(tracker.recipe.getInputs(), ItemStack::m_41777_), direction.m_122424_(), this.blocking)) continue;
                tracker.clearRecipe();
                this.roundRobinIndex = (this.roundRobinIndex + 1) % 6;
                this.m_6596_();
                continue block0;
            }
        }
        if (!this.powered) {
            directions = Lists.newArrayList((Object[])Direction.values());
            Collections.rotate(directions, this.roundRobinIndex);
            block2: for (Direction direction : directions) {
                BlockEntity blockEntity;
                PackageTracker trackerToEmpty = Arrays.stream(this.trackers).filter(t -> t.isFilled() && t.direction == null && t.recipe != null && !t.recipe.getRecipeType().hasMachine()).findFirst().orElse(null);
                if (trackerToEmpty == null || !this.validSendTarget(blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_121945_(direction)), direction.m_122424_())) continue;
                if (trackerToEmpty.toSend.isEmpty()) {
                    trackerToEmpty.setupToSend();
                }
                IItemHandler itemHandler = (IItemHandler)blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, direction.m_122424_()).orElse(null);
                if (this.blocking) {
                    for (int i = 0; i < trackerToEmpty.toSend.size(); ++i) {
                        IVolumePackageItem vPackage;
                        ItemStack stack = trackerToEmpty.toSend.get(i);
                        Item item = stack.m_41720_();
                        if (item instanceof IVolumePackageItem && (vPackage = (IVolumePackageItem)item).getVolumeType(stack) != null && vPackage.getVolumeType(stack).hasBlockCapability((ICapabilityProvider)blockEntity, direction.m_122424_()) ? !vPackage.getVolumeType(stack).isEmpty((ICapabilityProvider)blockEntity, direction.m_122424_()) : itemHandler != null && !MiscHelper.INSTANCE.isEmpty(itemHandler)) continue block2;
                    }
                }
                boolean acceptsAll = true;
                for (int i = 0; i < trackerToEmpty.toSend.size(); ++i) {
                    IVolumePackageItem vPackage;
                    ItemStack stack;
                    ItemStack stackRem = stack = trackerToEmpty.toSend.get(i);
                    Item item = stack.m_41720_();
                    if (item instanceof IVolumePackageItem && (vPackage = (IVolumePackageItem)item).getVolumeType(stack) != null && vPackage.getVolumeType(stack).hasBlockCapability((ICapabilityProvider)blockEntity, direction.m_122424_())) {
                        stackRem = MiscHelper.INSTANCE.fillVolume(blockEntity, direction.m_122424_(), stack, true);
                    } else if (itemHandler != null) {
                        stackRem = MiscHelper.INSTANCE.insertItem(itemHandler, stack, false, true);
                    }
                    acceptsAll &= stackRem.m_41613_() < stack.m_41613_();
                }
                if (acceptsAll) {
                    trackerToEmpty.direction = direction;
                    this.roundRobinIndex = (this.roundRobinIndex + 1) % 6;
                }
                this.m_6596_();
            }
        }
        for (Direction direction : Direction.values()) {
            BlockEntity blockEntity;
            PackageTracker trackerToEmpty = Arrays.stream(this.trackers).filter(t -> t.direction == direction).findFirst().orElse(null);
            if (trackerToEmpty == null) continue;
            if (trackerToEmpty.toSend.isEmpty()) {
                trackerToEmpty.setupToSend();
            }
            boolean ordered = false;
            if (trackerToEmpty.recipe != null) {
                ordered = trackerToEmpty.recipe.getRecipeType().isOrdered();
            }
            if (!this.validSendTarget(blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_121945_(direction)), direction.m_122424_())) {
                trackerToEmpty.direction = null;
                continue;
            }
            IItemHandler itemHandler = (IItemHandler)blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, direction.m_122424_()).orElse(null);
            for (int i = 0; i < trackerToEmpty.toSend.size(); ++i) {
                IVolumePackageItem vPackage;
                ItemStack stack;
                ItemStack stackRem = stack = trackerToEmpty.toSend.get(i);
                Item item = stack.m_41720_();
                if (item instanceof IVolumePackageItem && (vPackage = (IVolumePackageItem)item).getVolumeType(stack) != null && vPackage.getVolumeType(stack).hasBlockCapability((ICapabilityProvider)blockEntity, direction.m_122424_())) {
                    stackRem = MiscHelper.INSTANCE.fillVolume(blockEntity, direction.m_122424_(), stack, false);
                } else if (itemHandler != null) {
                    stackRem = MiscHelper.INSTANCE.insertItem(itemHandler, stack, ordered, false);
                }
                trackerToEmpty.toSend.set(i, stackRem);
            }
            trackerToEmpty.toSend.removeIf(ItemStack::m_41619_);
            if (trackerToEmpty.toSend.isEmpty()) {
                trackerToEmpty.clearRecipe();
            }
            this.m_6596_();
        }
    }

    protected boolean validSendTarget(BlockEntity blockEntity, Direction direction) {
        return blockEntity != null && !(blockEntity instanceof IPackageCraftingMachine) && !(blockEntity instanceof PackagerBlockEntity) && !(blockEntity instanceof PackagerExtensionBlockEntity) && !(blockEntity instanceof UnpackagerBlockEntity);
    }

    protected void chargeEnergy() {
        ItemStack energyStack = this.itemHandler.getStackInSlot(10);
        if (energyStack.getCapability(ForgeCapabilities.ENERGY).isPresent()) {
            int energyRequest = Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored());
            this.energyStorage.receiveEnergy(((IEnergyStorage)energyStack.getCapability(ForgeCapabilities.ENERGY).resolve().get()).extractEnergy(energyRequest, false), false);
            if (energyStack.m_41613_() <= 0) {
                this.itemHandler.setStackInSlot(10, ItemStack.f_41583_);
            }
        }
    }

    public void updatePowered() {
        if (this.f_58857_.m_277086_(this.f_58858_) > 0 != this.powered) {
            this.powered = !this.powered;
            this.sync(false);
            this.m_6596_();
        }
    }

    @Override
    public int getComparatorSignal() {
        return Math.min((int)Arrays.stream(this.trackers).filter(t -> t.isFilled()).count(), 15);
    }

    public void postPatternChange() {
    }

    public int getScaledEnergy(int scale) {
        if (this.energyStorage.getMaxEnergyStored() <= 0) {
            return 0;
        }
        return Math.min(scale * this.energyStorage.getEnergyStored() / this.energyStorage.getMaxEnergyStored(), scale);
    }

    @Override
    public ISettingsCloneable.Result loadConfig(CompoundTag nbt, Player player) {
        MutableComponent message;
        block5: {
            this.blocking = nbt.m_128471_("Blocking");
            this.trackerCount = nbt.m_128445_("Trackers");
            message = null;
            if (nbt.m_128441_("Recipes")) {
                if (this.itemHandler.getStackInSlot(9).m_41619_()) {
                    Inventory playerInventory = player.m_150109_();
                    for (int i = 0; i < playerInventory.m_6643_(); ++i) {
                        ItemStack stack = playerInventory.m_8020_(i);
                        if (stack.m_41619_() || !stack.m_150930_((Item)RecipeHolderItem.INSTANCE) || stack.m_41782_()) continue;
                        ItemStack stackCopy = stack.m_41620_(1);
                        IPackageRecipeList recipeListObj = RecipeHolderItem.INSTANCE.getRecipeList(stackCopy);
                        List<IPackageRecipeInfo> recipeList = MiscHelper.INSTANCE.loadRecipeList(nbt.m_128437_("Recipes", 10));
                        recipeListObj.setRecipeList(recipeList);
                        RecipeHolderItem.INSTANCE.setRecipeList(stackCopy, recipeListObj);
                        this.itemHandler.setStackInSlot(9, stackCopy);
                        break block5;
                    }
                    message = Component.m_237115_((String)"block.packagedauto.unpackager.no_holders");
                } else {
                    message = Component.m_237115_((String)"block.packagedauto.unpackager.holder_present");
                }
            }
        }
        if (message != null) {
            return ISettingsCloneable.Result.partial(message);
        }
        return ISettingsCloneable.Result.success();
    }

    @Override
    public ISettingsCloneable.Result saveConfig(CompoundTag nbt, Player player) {
        nbt.m_128379_("Blocking", this.blocking);
        nbt.m_128344_("Trackers", (byte)this.trackerCount);
        if (!this.recipeList.isEmpty()) {
            nbt.m_128365_("Recipes", (Tag)MiscHelper.INSTANCE.saveRecipeList(new ListTag(), this.recipeList));
        }
        return ISettingsCloneable.Result.success();
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.blocking = nbt.m_128471_("Blocking");
        this.trackerCount = nbt.m_128441_("Trackers") ? (int)nbt.m_128445_("Trackers") : 6;
        this.powered = nbt.m_128471_("Powered");
        for (int i = 0; i < this.trackers.length; ++i) {
            this.trackers[i].load(nbt.m_128469_(String.format("Tracker%02d", i)));
        }
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128379_("Blocking", this.blocking);
        nbt.m_128344_("Trackers", (byte)this.trackerCount);
        nbt.m_128379_("Powered", this.powered);
        for (int i = 0; i < this.trackers.length; ++i) {
            CompoundTag subNBT = new CompoundTag();
            this.trackers[i].save(subNBT);
            nbt.m_128365_(String.format("Tracker%02d", i), (Tag)subNBT);
        }
    }

    public void changeBlockingMode() {
        this.blocking = !this.blocking;
        this.m_6596_();
    }

    public void changeTrackerCount(boolean decrease) {
        this.trackerCount = Mth.m_14045_((int)(this.trackerCount + (decrease ? -1 : 1)), (int)1, (int)10);
        this.m_6596_();
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
        this.sync(false);
        return new UnpackagerMenu(windowId, inventory, this);
    }

    public class PackageTracker {
        public boolean[] rejectedIndexes = new boolean[9];
        public IPackageRecipeInfo recipe;
        public int amount;
        public BooleanList received = new BooleanArrayList(9);
        public List<ItemStack> toSend = new ArrayList<ItemStack>();
        public Direction direction;

        public void clearRecipe() {
            this.clearRejectedIndexes();
            this.recipe = null;
            this.amount = 0;
            this.received.clear();
            this.direction = null;
            if (UnpackagerBlockEntity.this.f_58857_ != null && !((UnpackagerBlockEntity)UnpackagerBlockEntity.this).f_58857_.f_46443_) {
                UnpackagerBlockEntity.this.m_6596_();
            }
        }

        public void fillRecipe(IPackageRecipeInfo recipe) {
            this.recipe = recipe;
            this.amount = recipe.getPatterns().size();
            this.received.clear();
            this.received.size(this.amount);
            for (int i = 0; i < this.received.size(); ++i) {
                this.received.set(i, true);
            }
            if (UnpackagerBlockEntity.this.f_58857_ != null && !((UnpackagerBlockEntity)UnpackagerBlockEntity.this).f_58857_.f_46443_) {
                UnpackagerBlockEntity.this.m_6596_();
            }
        }

        public void ejectItems() {
            if (UnpackagerBlockEntity.this.f_58857_ != null && !this.isEmpty()) {
                if (!this.toSend.isEmpty()) {
                    for (ItemStack stack : this.toSend) {
                        if (stack.m_41619_()) continue;
                        double dx = (double)(((UnpackagerBlockEntity)UnpackagerBlockEntity.this).f_58857_.f_46441_.m_188501_() / 2.0f) + 0.25;
                        double dy = (double)(((UnpackagerBlockEntity)UnpackagerBlockEntity.this).f_58857_.f_46441_.m_188501_() / 2.0f) + 0.75;
                        double dz = (double)(((UnpackagerBlockEntity)UnpackagerBlockEntity.this).f_58857_.f_46441_.m_188501_() / 2.0f) + 0.25;
                        ItemEntity itemEntity = new ItemEntity(UnpackagerBlockEntity.this.f_58857_, (double)UnpackagerBlockEntity.this.f_58858_.m_123341_() + dx, (double)UnpackagerBlockEntity.this.f_58858_.m_123342_() + dy, (double)UnpackagerBlockEntity.this.f_58858_.m_123343_() + dz, stack);
                        itemEntity.m_32060_();
                        UnpackagerBlockEntity.this.f_58857_.m_7967_((Entity)itemEntity);
                    }
                } else {
                    List<IPackagePattern> patterns = this.recipe.getPatterns();
                    for (int i = 0; i < this.received.size() && i < patterns.size(); ++i) {
                        if (!this.received.getBoolean(i)) continue;
                        double dx = (double)(((UnpackagerBlockEntity)UnpackagerBlockEntity.this).f_58857_.f_46441_.m_188501_() / 2.0f) + 0.25;
                        double dy = (double)(((UnpackagerBlockEntity)UnpackagerBlockEntity.this).f_58857_.f_46441_.m_188501_() / 2.0f) + 0.75;
                        double dz = (double)(((UnpackagerBlockEntity)UnpackagerBlockEntity.this).f_58857_.f_46441_.m_188501_() / 2.0f) + 0.25;
                        ItemEntity itemEntity = new ItemEntity(UnpackagerBlockEntity.this.f_58857_, (double)UnpackagerBlockEntity.this.f_58858_.m_123341_() + dx, (double)UnpackagerBlockEntity.this.f_58858_.m_123342_() + dy, (double)UnpackagerBlockEntity.this.f_58858_.m_123343_() + dz, patterns.get(i).getOutput());
                        itemEntity.m_32060_();
                        UnpackagerBlockEntity.this.f_58857_.m_7967_((Entity)itemEntity);
                    }
                }
                this.clearRecipe();
            }
        }

        public boolean tryAcceptPackage(IPackageItem packageItem, ItemStack stack, int invIndex) {
            if (this.rejectedIndexes[invIndex]) {
                return false;
            }
            IPackageRecipeInfo recipe = packageItem.getRecipeInfo(stack);
            int index = packageItem.getIndex(stack);
            if (recipe != null && recipe.isValid() && recipe.validPatternIndex(index)) {
                if (this.recipe == null) {
                    this.recipe = recipe;
                    this.amount = recipe.getPatterns().size();
                    this.received.size(this.amount);
                    this.received.set(index, true);
                    UnpackagerBlockEntity.this.m_6596_();
                    return true;
                }
                if (this.recipe.equals(recipe) && !this.received.getBoolean(index)) {
                    this.received.set(index, true);
                    UnpackagerBlockEntity.this.m_6596_();
                    return true;
                }
            }
            return false;
        }

        public void setRejectedIndex(int index, boolean rejected) {
            this.rejectedIndexes[index] = rejected;
        }

        public void clearRejectedIndexes() {
            Arrays.fill(this.rejectedIndexes, false);
        }

        public boolean isFilled() {
            if (!this.toSend.isEmpty()) {
                return true;
            }
            if (this.received.isEmpty()) {
                return false;
            }
            BooleanListIterator booleanListIterator = this.received.iterator();
            while (booleanListIterator.hasNext()) {
                boolean b = (Boolean)booleanListIterator.next();
                if (b) continue;
                return false;
            }
            return true;
        }

        public boolean isEmpty() {
            return this.recipe == null || !this.recipe.isValid();
        }

        public void setupToSend() {
            if (this.isEmpty() || this.recipe.getRecipeType().hasMachine() || !this.toSend.isEmpty()) {
                return;
            }
            this.toSend.addAll(Lists.transform(this.recipe.getInputs(), ItemStack::m_41777_));
        }

        public void load(CompoundTag nbt) {
            this.clearRecipe();
            CompoundTag tag = nbt.m_128469_("Recipe");
            IPackageRecipeInfo recipe = MiscHelper.INSTANCE.loadRecipe(tag);
            if (recipe != null) {
                this.recipe = recipe;
                this.amount = nbt.m_128445_("Amount");
                this.received.size(this.amount);
                byte[] receivedArray = nbt.m_128463_("Received");
                for (int i = 0; i < this.received.size(); ++i) {
                    this.received.set(i, receivedArray[i] != 0);
                }
            }
            MiscHelper.INSTANCE.loadAllItems(nbt.m_128437_("ToSend", 10), this.toSend);
            if (nbt.m_128441_("Direction")) {
                this.direction = Direction.m_122376_((int)nbt.m_128445_("Direction"));
            }
        }

        public void save(CompoundTag nbt) {
            if (this.recipe != null) {
                CompoundTag tag = MiscHelper.INSTANCE.saveRecipe(new CompoundTag(), this.recipe);
                nbt.m_128365_("Recipe", (Tag)tag);
                nbt.m_128344_("Amount", (byte)this.amount);
                byte[] receivedArray = new byte[this.received.size()];
                for (int i = 0; i < this.received.size(); ++i) {
                    receivedArray[i] = (byte)(this.received.getBoolean(i) ? 1 : 0);
                }
                nbt.m_128382_("Received", receivedArray);
            }
            nbt.m_128365_("ToSend", (Tag)MiscHelper.INSTANCE.saveAllItems(new ListTag(), this.toSend));
            if (this.direction != null) {
                nbt.m_128344_("Direction", (byte)this.direction.m_122411_());
            }
        }

        public int getSyncValue() {
            int val = 0;
            for (int i = 0; i < this.received.size(); ++i) {
                if (!this.received.getBoolean(i)) continue;
                val |= 1 << i;
            }
            val <<= 4;
            return val |= this.amount;
        }

        public void setSyncValue(int val) {
            this.amount = val & 0xF;
            this.received.size(this.amount);
            val >>>= 4;
            for (int i = 0; i < this.received.size(); ++i) {
                this.received.set(i, (val >>> i & 1) != 0);
            }
        }
    }
}

