/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.appeng.blockentity;

import appeng.api.config.Actionable;
import appeng.api.features.IPlayerRegistry;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import thelm.packagedauto.block.DistributorBlock;
import thelm.packagedauto.block.entity.DistributorBlockEntity;

public class AEDistributorBlockEntity
extends DistributorBlockEntity
implements IInWorldGridNodeHost,
IGridNodeListener<AEDistributorBlockEntity>,
IActionHost {
    public boolean firstTick = true;
    public IActionSource source = IActionSource.ofMachine((IActionHost)this);
    public IManagedGridNode gridNode;

    public AEDistributorBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    @Override
    public void tick() {
        if (this.firstTick) {
            this.firstTick = false;
            this.getMainNode().create(this.f_58857_, this.f_58858_);
        }
        super.tick();
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.gridNode != null) {
            this.gridNode.destroy();
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (this.gridNode != null) {
            this.gridNode.destroy();
        }
    }

    public IGridNode getGridNode(Direction dir) {
        return this.getActionableNode();
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.SMART;
    }

    public void onSaveChanges(AEDistributorBlockEntity nodeOwner, IGridNode node) {
        this.m_6596_();
    }

    public IManagedGridNode getMainNode() {
        if (this.gridNode == null) {
            this.gridNode = GridHelper.createManagedNode((Object)this, (IGridNodeListener)this);
            this.gridNode.setTagName("Node");
            this.gridNode.setVisualRepresentation((ItemLike)DistributorBlock.INSTANCE);
            this.gridNode.setGridColor(AEColor.TRANSPARENT);
            this.gridNode.setIdlePowerUsage(1.0);
            this.gridNode.setInWorldNode(true);
            if (this.ownerUUID != null && this.f_58857_ instanceof ServerLevel) {
                this.gridNode.setOwningPlayerId(IPlayerRegistry.getMapping((Level)this.f_58857_).getPlayerId(this.ownerUUID));
            }
        }
        return this.gridNode;
    }

    public IGridNode getActionableNode() {
        return this.getMainNode().getNode();
    }

    @Override
    public void ejectItems() {
        if (this.getMainNode().isActive()) {
            IGrid grid = this.getMainNode().getGrid();
            IStorageService storageService = grid.getStorageService();
            IEnergyService energyService = grid.getEnergyService();
            MEStorage inventory = storageService.getInventory();
            for (int i = 0; i < 81; ++i) {
                int count;
                if (!this.pending.containsKey(i)) continue;
                ItemStack is = (ItemStack)this.pending.get(i);
                AEItemKey key = AEItemKey.of((ItemStack)is);
                int inserted = (int)StorageHelper.poweredInsert((IEnergySource)energyService, (MEStorage)inventory, (AEKey)key, (long)(count = is.m_41613_()), (IActionSource)this.source, (Actionable)Actionable.MODULATE);
                if (inserted == count) {
                    this.pending.remove(i);
                    continue;
                }
                this.pending.put(i, (Object)key.toStack(count - inserted));
            }
        }
        super.ejectItems();
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("Node")) {
            this.getMainNode().loadFromNBT(nbt);
        }
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        if (this.gridNode != null) {
            this.gridNode.saveToNBT(nbt);
        }
    }
}

