/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.appeng.recipe;

import appeng.api.crafting.IPatternDetails;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.GenericStack;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import thelm.packagedauto.api.IPackageItem;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.integration.appeng.AppEngUtil;

public class DirectCraftingPatternDetails
implements IPatternDetails {
    public final IPackageRecipeInfo recipe;
    public final AEItemKey definition;
    public final IPatternDetails.IInput[] inputs;
    public final GenericStack[] outputs;

    public DirectCraftingPatternDetails(IPackageRecipeInfo recipe) {
        this.recipe = recipe;
        ItemStack definitionStack = recipe.getPatterns().get(0).getOutput();
        definitionStack.m_41783_().m_128359_("PatternType", "direct");
        this.definition = AEItemKey.of((ItemStack)definitionStack);
        List<GenericStack> sparseInputs = recipe.getInputs().stream().flatMap(stack -> {
            IPackageItem packageItem;
            IPackageRecipeInfo subRecipe;
            Item patt1102$temp = stack.m_41720_();
            if (patt1102$temp instanceof IPackageItem && !(subRecipe = (packageItem = (IPackageItem)patt1102$temp).getRecipeInfo((ItemStack)stack)).getRecipeType().hasMachine() && subRecipe.getPatterns().size() == 1) {
                return subRecipe.getInputs().stream();
            }
            return Stream.of(stack);
        }).map(GenericStack::fromItemStack).toList();
        List<GenericStack> sparseOutputs = recipe.getOutputs().stream().map(AppEngUtil::getGenericOutput).toList();
        this.inputs = AppEngUtil.toInputs(recipe, AppEngUtil.condenseStacks(sparseInputs));
        this.outputs = AppEngUtil.condenseStacks(sparseOutputs);
    }

    public AEItemKey getDefinition() {
        return this.definition;
    }

    public IPatternDetails.IInput[] getInputs() {
        return this.inputs;
    }

    public GenericStack[] getOutputs() {
        return this.outputs;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DirectCraftingPatternDetails) {
            DirectCraftingPatternDetails other = (DirectCraftingPatternDetails)obj;
            return this.recipe.equals(other.recipe);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.recipe, 1);
    }
}

