/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.network.packet;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import thelm.packagedauto.menu.EncoderMenu;
import thelm.packagedauto.util.MiscHelper;

public record SetRecipePacket(Int2ObjectMap<ItemStack> map) {
    public SetRecipePacket addItem(int index, ItemStack stack) {
        this.map.put(index, (Object)stack);
        return this;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeByte(this.map.size());
        for (Int2ObjectMap.Entry entry : this.map.int2ObjectEntrySet()) {
            buf.writeByte(entry.getIntKey());
            MiscHelper.INSTANCE.writeItemWithLargeCount(buf, (ItemStack)entry.getValue());
        }
    }

    public static SetRecipePacket decode(FriendlyByteBuf buf) {
        int size = buf.readByte();
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap(size);
        for (int i = 0; i < size; ++i) {
            short index = buf.readUnsignedByte();
            ItemStack stack = MiscHelper.INSTANCE.readItemWithLargeCount(buf);
            map.put((int)index, (Object)stack);
        }
        return new SetRecipePacket((Int2ObjectMap<ItemStack>)map);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer player = ctx.get().getSender();
        ctx.get().enqueueWork(() -> {
            AbstractContainerMenu patt1464$temp = player.f_36096_;
            if (patt1464$temp instanceof EncoderMenu) {
                EncoderMenu menu = (EncoderMenu)patt1464$temp;
                menu.patternItemHandler.setRecipe(this.map);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

