/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedexcrafting.block.entity;

import com.blakebr0.extendedcrafting.tileentity.FluxAlternatorTileEntity;
import com.google.common.base.Predicates;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import thelm.packagedauto.api.IPackageCraftingMachine;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.block.entity.BaseBlockEntity;
import thelm.packagedauto.block.entity.UnpackagerBlockEntity;
import thelm.packagedauto.energy.EnergyStorage;
import thelm.packagedauto.util.MiscHelper;
import thelm.packagedexcrafting.block.FluxCrafterBlock;
import thelm.packagedexcrafting.integration.appeng.blockentity.AEFluxCrafterBlockEntity;
import thelm.packagedexcrafting.inventory.FluxCrafterItemHandler;
import thelm.packagedexcrafting.menu.FluxCrafterMenu;
import thelm.packagedexcrafting.recipe.IFluxPackageRecipeInfo;

public class FluxCrafterBlockEntity
extends BaseBlockEntity
implements IPackageCraftingMachine {
    public static final BlockEntityType<FluxCrafterBlockEntity> TYPE_INSTANCE = BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)((BlockEntityType.BlockEntitySupplier)MiscHelper.INSTANCE.conditionalSupplier(() -> ModList.get().isLoaded("ae2"), () -> () -> AEFluxCrafterBlockEntity::new, () -> () -> FluxCrafterBlockEntity::new).get()), (Block[])new Block[]{FluxCrafterBlock.INSTANCE}).m_58966_(null);
    public static int energyCapacity = 5000;
    public static int energyReq = 500;
    public static int energyUsage = 100;
    public static boolean drawMEEnergy = true;
    public boolean isWorking = false;
    public int progressReq = 0;
    public int progress = 0;
    public int alternatorUsage = 0;
    public int remainingProgress = 0;
    public IFluxPackageRecipeInfo currentRecipe;

    public FluxCrafterBlockEntity(BlockPos pos, BlockState state) {
        super(TYPE_INSTANCE, pos, state);
        this.setItemHandler(new FluxCrafterItemHandler(this));
        this.setEnergyStorage(new EnergyStorage((BaseBlockEntity)this, energyCapacity));
    }

    protected Component getDefaultName() {
        return Component.m_237115_((String)"block.packagedexcrafting.flux_crafter");
    }

    public void tick() {
        if (!this.f_58857_.f_46443_) {
            if (this.isWorking) {
                this.tickProcess();
                if (this.remainingProgress <= 0) {
                    this.finishProcess();
                    this.ejectItems();
                }
            }
            this.chargeEnergy();
            if (this.f_58857_.m_46467_() % 8L == 0L) {
                this.ejectItems();
            }
        }
    }

    public boolean acceptPackage(IPackageRecipeInfo recipeInfo, List<ItemStack> stacks, Direction direction) {
        if (!this.isBusy() && recipeInfo.isValid() && recipeInfo instanceof IFluxPackageRecipeInfo) {
            IFluxPackageRecipeInfo recipe = (IFluxPackageRecipeInfo)recipeInfo;
            ItemStack slotStack = this.itemHandler.getStackInSlot(9);
            ItemStack outputStack = recipe.getOutput();
            if (slotStack.m_41619_() || ItemStack.m_150942_((ItemStack)slotStack, (ItemStack)outputStack) && slotStack.m_41613_() + outputStack.m_41613_() <= outputStack.m_41741_()) {
                this.currentRecipe = recipe;
                this.isWorking = true;
                this.progressReq = recipe.getEnergyRequired();
                this.alternatorUsage = recipe.getEnergyUsage();
                this.remainingProgress = energyReq;
                for (int i = 0; i < 9; ++i) {
                    this.itemHandler.setStackInSlot(i, recipe.getMatrix().m_8020_(i).m_41777_());
                }
                this.m_6596_();
                return true;
            }
        }
        return false;
    }

    public boolean isBusy() {
        return this.isWorking || !this.itemHandler.getStacks().subList(0, 9).stream().allMatch(ItemStack::m_41619_);
    }

    protected void tickProcess() {
        if (this.progress < this.progressReq) {
            List<FluxAlternatorTileEntity> alternators = this.getAlternators();
            int alternatorCount = alternators.size();
            this.progress += alternatorCount * this.alternatorUsage;
            for (FluxAlternatorTileEntity alternator : alternators) {
                alternator.getEnergy().extractEnergy(this.alternatorUsage, false);
                BlockPos alternatorPos = alternator.m_58899_();
                if (!this.f_58857_.m_46859_(alternatorPos.m_7494_())) continue;
                this.spawnParticles(DustParticleOptions.f_123656_, alternatorPos, 1.0, 1);
            }
        }
        if (this.progress >= this.progressReq) {
            this.progress = this.progressReq;
            int energy = this.energyStorage.extractEnergy(Math.min(energyUsage, this.remainingProgress), false);
            this.remainingProgress -= energy;
        }
    }

    protected void finishProcess() {
        if (this.currentRecipe == null) {
            this.endProcess();
            return;
        }
        if (this.itemHandler.getStackInSlot(9).m_41619_()) {
            this.itemHandler.setStackInSlot(9, this.currentRecipe.getOutput());
        } else {
            this.itemHandler.getStackInSlot(9).m_41769_(this.currentRecipe.getOutput().m_41613_());
        }
        List<ItemStack> remainingItems = this.currentRecipe.getRemainingItems();
        for (int i = 0; i < 9; ++i) {
            this.itemHandler.setStackInSlot(i, remainingItems.get(i));
        }
        this.endProcess();
    }

    public void endProcess() {
        this.progressReq = 0;
        this.progress = 0;
        this.alternatorUsage = 0;
        this.remainingProgress = 0;
        this.isWorking = false;
        this.currentRecipe = null;
        this.m_6596_();
    }

    protected List<FluxAlternatorTileEntity> getAlternators() {
        return BlockPos.m_121990_((BlockPos)this.f_58858_.m_7918_(-3, -3, -3), (BlockPos)this.f_58858_.m_7918_(3, 3, 3)).map(pos -> {
            FluxAlternatorTileEntity alternator;
            BlockEntity patt5937$temp = this.f_58857_.m_7702_(pos);
            if (patt5937$temp instanceof FluxAlternatorTileEntity && (alternator = (FluxAlternatorTileEntity)patt5937$temp).getEnergy().getEnergyStored() >= this.alternatorUsage) {
                return alternator;
            }
            return null;
        }).filter((Predicate<FluxAlternatorTileEntity>)Predicates.notNull()).toList();
    }

    protected void ejectItems() {
        int endIndex = this.isWorking ? 9 : 0;
        for (Direction direction : Direction.values()) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_121945_(direction));
            if (blockEntity == null || blockEntity instanceof UnpackagerBlockEntity || !blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, direction.m_122424_()).isPresent()) continue;
            IItemHandler itemHandler = (IItemHandler)blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, direction.m_122424_()).resolve().get();
            for (int i = 9; i >= endIndex; --i) {
                ItemStack stack = this.itemHandler.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                ItemStack stackRem = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)false);
                this.itemHandler.setStackInSlot(i, stackRem);
            }
        }
    }

    protected void chargeEnergy() {
        ItemStack energyStack = this.itemHandler.getStackInSlot(10);
        if (energyStack.getCapability(ForgeCapabilities.ENERGY, null).isPresent()) {
            int energyRequest = Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored());
            this.energyStorage.receiveEnergy(((IEnergyStorage)energyStack.getCapability(ForgeCapabilities.ENERGY).resolve().get()).extractEnergy(energyRequest, false), false);
            if (energyStack.m_41613_() <= 0) {
                this.itemHandler.setStackInSlot(10, ItemStack.f_41583_);
            }
        }
    }

    protected <T extends ParticleOptions> void spawnParticles(T particle, BlockPos pos, double yOffset, int count) {
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        ServerLevel level = (ServerLevel)this.f_58857_;
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + yOffset;
        double z = (double)pos.m_123343_() + 0.5;
        level.m_8767_(particle, x, y, z, count, 0.0, 0.0, 0.0, 0.1);
    }

    public int getComparatorSignal() {
        if (this.isWorking) {
            return 1;
        }
        if (!this.itemHandler.getStacks().subList(0, 10).stream().allMatch(ItemStack::m_41619_)) {
            return 15;
        }
        return 0;
    }

    public void m_142466_(CompoundTag nbt) {
        CompoundTag tag;
        IPackageRecipeInfo recipe;
        super.m_142466_(nbt);
        this.isWorking = nbt.m_128471_("Working");
        this.progressReq = nbt.m_128451_("ProgressReq");
        this.progress = nbt.m_128451_("Progress");
        this.alternatorUsage = nbt.m_128451_("AlternatorUsage");
        this.remainingProgress = nbt.m_128451_("EnergyProgress");
        this.currentRecipe = null;
        if (nbt.m_128441_("Recipe") && (recipe = MiscHelper.INSTANCE.loadRecipe(tag = nbt.m_128469_("Recipe"))) instanceof IFluxPackageRecipeInfo) {
            IFluxPackageRecipeInfo fluxRecipe;
            this.currentRecipe = fluxRecipe = (IFluxPackageRecipeInfo)recipe;
        }
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128379_("Working", this.isWorking);
        nbt.m_128405_("ProgressReq", this.progressReq);
        nbt.m_128405_("Progress", this.progress);
        nbt.m_128405_("AlternatorUsage", this.alternatorUsage);
        nbt.m_128405_("EnergyProgress", this.remainingProgress);
        if (this.currentRecipe != null) {
            CompoundTag tag = MiscHelper.INSTANCE.saveRecipe(new CompoundTag(), (IPackageRecipeInfo)this.currentRecipe);
            nbt.m_128365_("Recipe", (Tag)tag);
        }
    }

    public int getScaledEnergy(int scale) {
        if (this.energyStorage.getMaxEnergyStored() <= 0) {
            return 0;
        }
        return Math.min(scale * this.energyStorage.getEnergyStored() / this.energyStorage.getMaxEnergyStored(), scale);
    }

    public int getScaledProgress(int scale) {
        if (this.progress <= 0 || this.progressReq <= 0) {
            return 0;
        }
        return scale * this.progress / this.progressReq;
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
        this.sync(false);
        return new FluxCrafterMenu(windowId, inventory, this);
    }
}

