/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedexcrafting.integration.appeng.blockentity;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.features.IPlayerRegistry;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import thelm.packagedexcrafting.block.UltimateCrafterBlock;
import thelm.packagedexcrafting.block.entity.UltimateCrafterBlockEntity;

public class AEUltimateCrafterBlockEntity
extends UltimateCrafterBlockEntity
implements IInWorldGridNodeHost,
IGridNodeListener<AEUltimateCrafterBlockEntity>,
IActionHost {
    public boolean firstTick = true;
    public IActionSource source = IActionSource.ofMachine((IActionHost)this);
    public IManagedGridNode gridNode;

    public AEUltimateCrafterBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    @Override
    public void tick() {
        if (this.firstTick) {
            this.firstTick = false;
            this.getMainNode().create(this.f_58857_, this.f_58858_);
        }
        super.tick();
        if (drawMEEnergy && !this.f_58857_.f_46443_ && this.f_58857_.m_46467_() % 8L == 0L) {
            this.chargeMEEnergy();
        }
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.gridNode != null) {
            this.gridNode.destroy();
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (this.gridNode != null) {
            this.gridNode.destroy();
        }
    }

    public IGridNode getGridNode(Direction dir) {
        return this.getActionableNode();
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.SMART;
    }

    public void onSaveChanges(AEUltimateCrafterBlockEntity nodeOwner, IGridNode node) {
        this.m_6596_();
    }

    public IManagedGridNode getMainNode() {
        if (this.gridNode == null) {
            this.gridNode = GridHelper.createManagedNode((Object)((Object)this), (IGridNodeListener)this);
            this.gridNode.setTagName("Node");
            this.gridNode.setVisualRepresentation((ItemLike)UltimateCrafterBlock.INSTANCE);
            this.gridNode.setGridColor(AEColor.TRANSPARENT);
            this.gridNode.setIdlePowerUsage(1.0);
            this.gridNode.setInWorldNode(true);
            if (this.ownerUUID != null && this.f_58857_ instanceof ServerLevel) {
                this.gridNode.setOwningPlayerId(IPlayerRegistry.getMapping((Level)this.f_58857_).getPlayerId(this.ownerUUID));
            }
        }
        return this.gridNode;
    }

    public IGridNode getActionableNode() {
        return this.getMainNode().getNode();
    }

    @Override
    protected void ejectItems() {
        if (this.getMainNode().isActive()) {
            IGrid grid = this.getMainNode().getGrid();
            IStorageService storageService = grid.getStorageService();
            IEnergyService energyService = grid.getEnergyService();
            MEStorage inventory = storageService.getInventory();
            int endIndex = this.isWorking ? 81 : 0;
            for (int i = 81; i >= endIndex; --i) {
                int count;
                ItemStack is = this.itemHandler.getStackInSlot(i);
                if (is.m_41619_()) continue;
                AEItemKey key = AEItemKey.of((ItemStack)is);
                int inserted = (int)StorageHelper.poweredInsert((IEnergySource)energyService, (MEStorage)inventory, (AEKey)key, (long)(count = is.m_41613_()), (IActionSource)this.source, (Actionable)Actionable.MODULATE);
                if (inserted == count) {
                    this.itemHandler.setStackInSlot(i, ItemStack.f_41583_);
                    continue;
                }
                this.itemHandler.setStackInSlot(i, key.toStack(count - inserted));
            }
        } else {
            super.ejectItems();
        }
    }

    protected void chargeMEEnergy() {
        if (this.getMainNode().isActive()) {
            IGrid grid = this.getMainNode().getGrid();
            IEnergyService energyService = grid.getEnergyService();
            double conversion = PowerUnits.FE.convertTo(PowerUnits.AE, 1.0);
            int request = Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored());
            double available = energyService.extractAEPower(((double)request + 0.5) * conversion, Actionable.SIMULATE, PowerMultiplier.CONFIG);
            int extract = (int)(available / conversion);
            energyService.extractAEPower((double)extract * conversion, Actionable.MODULATE, PowerMultiplier.CONFIG);
            this.energyStorage.receiveEnergy(extract, false);
        }
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("Node")) {
            this.getMainNode().loadFromNBT(nbt);
        }
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        if (this.gridNode != null) {
            this.gridNode.saveToNBT(nbt);
        }
    }
}

