/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedexexcrafting.recipe;

import com.blakebr0.extendedcrafting.api.crafting.ITableRecipe;
import com.blakebr0.extendedcrafting.init.ModRecipeTypes;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeType;
import thelm.packagedauto.recipe.ProcessingPackageRecipeType;
import thelm.packagedauto.util.MiscHelper;
import thelm.packagedauto.util.PackagePattern;
import thelm.packagedexcrafting.recipe.ITablePackageRecipeInfo;
import thelm.packagedexexcrafting.recipe.EpicPackageRecipeHelper;
import thelm.packagedexexcrafting.recipe.EpicPackageRecipeType;

public class EpicPackageRecipeInfo
implements ITablePackageRecipeInfo {
    ITableRecipe recipe;
    List<ItemStack> input = new ArrayList<ItemStack>();
    Container matrix = new SimpleContainer(121);
    ItemStack output;
    List<IPackagePattern> patterns = new ArrayList<IPackagePattern>();
    List<IPackagePattern> extraPatterns = new ArrayList<IPackagePattern>();

    public void load(CompoundTag nbt) {
        int i;
        List actualInput;
        this.input.clear();
        this.output = ItemStack.f_41583_;
        this.patterns.clear();
        this.extraPatterns.clear();
        Recipe recipe = MiscHelper.INSTANCE.getRecipeManager().m_44043_(new ResourceLocation(nbt.m_128461_("Recipe"))).orElse(null);
        ArrayList matrixList = new ArrayList();
        MiscHelper.INSTANCE.loadAllItems(nbt.m_128437_("Matrix", 10), matrixList);
        for (int i2 = 0; i2 < 121 && i2 < matrixList.size(); ++i2) {
            this.matrix.m_6836_(i2, (ItemStack)matrixList.get(i2));
        }
        if (recipe instanceof ITableRecipe) {
            ITableRecipe tableRecipe;
            this.recipe = tableRecipe = (ITableRecipe)recipe;
            this.output = this.recipe.m_5874_(this.matrix, MiscHelper.INSTANCE.getRegistryAccess()).m_41777_();
        }
        if ((actualInput = MiscHelper.INSTANCE.condenseStacks(this.matrix)).size() <= 81) {
            this.input.addAll(actualInput);
        } else {
            i = 0;
            while (i * 9 < actualInput.size()) {
                IPackageRecipeInfo subRecipe = ProcessingPackageRecipeType.INSTANCE.getNewRecipeInfo();
                subRecipe.generateFromStacks(actualInput.subList(i * 9, Math.min(9 + i * 9, actualInput.size())), List.of(), null);
                IPackagePattern subPattern = (IPackagePattern)subRecipe.getPatterns().get(0);
                this.extraPatterns.add(subPattern);
                this.input.add(subPattern.getOutput());
                ++i;
            }
        }
        i = 0;
        while (i * 9 < this.input.size()) {
            this.patterns.add((IPackagePattern)new PackagePattern((IPackageRecipeInfo)this, i));
            ++i;
        }
    }

    public void save(CompoundTag nbt) {
        if (this.recipe != null) {
            nbt.m_128359_("Recipe", this.recipe.m_6423_().toString());
        }
        ArrayList<ItemStack> matrixList = new ArrayList<ItemStack>();
        for (int i = 0; i < 121; ++i) {
            matrixList.add(this.matrix.m_8020_(i));
        }
        ListTag matrixTag = MiscHelper.INSTANCE.saveAllItems(new ListTag(), matrixList);
        nbt.m_128365_("Matrix", (Tag)matrixTag);
    }

    public IPackageRecipeType getRecipeType() {
        return EpicPackageRecipeType.INSTANCE;
    }

    public int getTier() {
        return 5;
    }

    public boolean isValid() {
        return this.recipe != null;
    }

    public List<IPackagePattern> getPatterns() {
        return Collections.unmodifiableList(this.patterns);
    }

    public List<IPackagePattern> getExtraPatterns() {
        return Collections.unmodifiableList(this.extraPatterns);
    }

    public List<ItemStack> getInputs() {
        return Collections.unmodifiableList(this.input);
    }

    public ItemStack getOutput() {
        return this.output.m_41777_();
    }

    public ITableRecipe getRecipe() {
        return this.recipe;
    }

    public Container getMatrix() {
        return this.matrix;
    }

    public List<ItemStack> getRemainingItems() {
        return this.recipe.m_7457_(this.matrix);
    }

    public void generateFromStacks(List<ItemStack> input, List<ItemStack> output, Level level) {
        this.recipe = null;
        this.input.clear();
        this.patterns.clear();
        this.extraPatterns.clear();
        Int2ObjectMap<ItemStack> matrixMap = EpicPackageRecipeHelper.INSTANCE.encoderToMatrix(input);
        matrixMap.forEach((arg_0, arg_1) -> ((Container)this.matrix).m_6836_(arg_0, arg_1));
        ITableRecipe recipe = MiscHelper.INSTANCE.getRecipeManager().m_44015_((RecipeType)ModRecipeTypes.TABLE.get(), this.matrix, level).orElse(null);
        if (recipe != null) {
            int i;
            this.recipe = recipe;
            List actualInput = MiscHelper.INSTANCE.condenseStacks(this.matrix);
            if (actualInput.size() <= 81) {
                this.input.addAll(actualInput);
            } else {
                i = 0;
                while (i * 9 < actualInput.size()) {
                    IPackageRecipeInfo subRecipe = ProcessingPackageRecipeType.INSTANCE.getNewRecipeInfo();
                    subRecipe.generateFromStacks(actualInput.subList(i * 9, Math.min(9 + i * 9, actualInput.size())), List.of(), null);
                    IPackagePattern subPattern = (IPackagePattern)subRecipe.getPatterns().get(0);
                    this.extraPatterns.add(subPattern);
                    this.input.add(subPattern.getOutput());
                    ++i;
                }
            }
            this.output = recipe.m_5874_(this.matrix, MiscHelper.INSTANCE.getRegistryAccess()).m_41777_();
            i = 0;
            while (i * 9 < this.input.size()) {
                this.patterns.add((IPackagePattern)new PackagePattern((IPackageRecipeInfo)this, i));
                ++i;
            }
            return;
        }
        this.matrix.m_6211_();
    }

    public Int2ObjectMap<ItemStack> getEncoderStacks() {
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        for (int i = 0; i < 121; ++i) {
            map.put(i, (Object)this.matrix.m_8020_(i));
        }
        return EpicPackageRecipeHelper.INSTANCE.matrixToEncoder((Int2ObjectMap<ItemStack>)map, false);
    }

    public boolean equals(Object obj) {
        if (obj instanceof EpicPackageRecipeInfo) {
            EpicPackageRecipeInfo other = (EpicPackageRecipeInfo)obj;
            return MiscHelper.INSTANCE.recipeEquals((IPackageRecipeInfo)this, (Object)this.recipe, (IPackageRecipeInfo)other, (Object)other.recipe);
        }
        return false;
    }

    public int hashCode() {
        return MiscHelper.INSTANCE.recipeHashCode((IPackageRecipeInfo)this, (Object)this.recipe);
    }
}

