/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedmekemicals.block.entity;

import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.infuse.IInfusionHandler;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.merged.BoxedChemicalStack;
import mekanism.api.chemical.pigment.IPigmentHandler;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.ISlurryHandler;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import thelm.packagedauto.api.IVolumePackageItem;
import thelm.packagedauto.block.entity.BaseBlockEntity;
import thelm.packagedauto.block.entity.UnpackagerBlockEntity;
import thelm.packagedauto.energy.EnergyStorage;
import thelm.packagedauto.item.VolumePackageItem;
import thelm.packagedauto.util.MiscHelper;
import thelm.packagedmekemicals.block.ChemicalPackageFillerBlock;
import thelm.packagedmekemicals.inventory.ChemicalPackageFillerItemHandler;
import thelm.packagedmekemicals.menu.ChemicalPackageFillerMenu;
import thelm.packagedmekemicals.util.ChemicalHelper;

public class ChemicalPackageFillerBlockEntity
extends BaseBlockEntity {
    public static final BlockEntityType<ChemicalPackageFillerBlockEntity> TYPE_INSTANCE = BlockEntityType.Builder.m_155273_(ChemicalPackageFillerBlockEntity::new, (Block[])new Block[]{ChemicalPackageFillerBlock.INSTANCE}).m_58966_(null);
    public static int energyCapacity = 5000;
    public static int energyReq = 500;
    public static int energyUsage = 100;
    public static int refreshInterval = 4;
    public boolean firstTick = true;
    public boolean isWorking = false;
    public ChemicalStack<?> currentChemical = GasStack.EMPTY;
    public int requiredAmount = 100;
    public int amount = 0;
    public int remainingProgress = 0;
    public boolean powered = false;
    public boolean activated = false;

    public ChemicalPackageFillerBlockEntity(BlockPos pos, BlockState state) {
        super(TYPE_INSTANCE, pos, state);
        this.setItemHandler(new ChemicalPackageFillerItemHandler(this));
        this.setEnergyStorage(new EnergyStorage((BaseBlockEntity)this, energyCapacity));
    }

    protected Component getDefaultName() {
        return Component.m_237115_((String)"block.packagedmekemicals.chemical_package_filler");
    }

    public void tick() {
        if (this.firstTick) {
            this.firstTick = false;
            this.updatePowered();
        }
        if (!this.f_58857_.f_46443_) {
            if (this.isWorking) {
                this.tickProcess();
                if (this.remainingProgress <= 0 && this.isTemplateValid()) {
                    this.finishProcess();
                    if (!this.itemHandler.getStackInSlot(1).m_41619_()) {
                        this.ejectItem();
                    }
                    if (!this.canStart()) {
                        this.endProcess();
                    } else {
                        this.startProcess();
                    }
                }
            } else if (this.activated && this.canStart()) {
                this.startProcess();
                this.tickProcess();
                this.activated = false;
                this.isWorking = true;
            }
            this.chargeEnergy();
            if (this.f_58857_.m_46467_() % (long)refreshInterval == 0L && !this.itemHandler.getStackInSlot(1).m_41619_()) {
                this.ejectItem();
            }
            this.energyStorage.updateIfChanged();
        }
    }

    public boolean isTemplateValid() {
        if (this.currentChemical.isEmpty()) {
            this.getChemical();
        }
        return !this.currentChemical.isEmpty();
    }

    public boolean canStart() {
        this.getChemical();
        if (this.currentChemical.isEmpty()) {
            return false;
        }
        if (!this.isTemplateValid()) {
            return false;
        }
        ItemStack slotStack = this.itemHandler.getStackInSlot(1);
        ItemStack outputStack = MiscHelper.INSTANCE.tryMakeVolumePackage(this.currentChemical);
        return !outputStack.m_41619_() && (slotStack.m_41619_() || ItemStack.m_150942_((ItemStack)slotStack, (ItemStack)outputStack) && slotStack.m_41613_() + 1 <= outputStack.m_41741_());
    }

    protected boolean canFinish() {
        return this.remainingProgress <= 0 && this.isTemplateValid();
    }

    protected void getChemical() {
        this.currentChemical = GasStack.EMPTY;
        ItemStack template = this.itemHandler.getStackInSlot(0);
        if (template.m_41619_()) {
            return;
        }
        ChemicalHelper.INSTANCE.getChemicalContained(template).filter(s -> !s.isEmpty()).ifPresent(s -> {
            this.currentChemical = s.copy();
            this.currentChemical.setAmount((long)this.requiredAmount);
        });
    }

    protected void tickProcess() {
        if (this.amount < this.requiredAmount) {
            block6: for (Direction direction : Direction.values()) {
                BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_121945_(direction));
                if (blockEntity == null) continue;
                switch (ChemicalType.getTypeFor(this.currentChemical)) {
                    case GAS: {
                        if (!blockEntity.getCapability(Capabilities.GAS_HANDLER, direction.m_122424_()).isPresent()) continue block6;
                        IGasHandler gasHandler = (IGasHandler)blockEntity.getCapability(Capabilities.GAS_HANDLER, direction.m_122424_()).resolve().get();
                        GasStack toDrain = (GasStack)this.currentChemical.copy();
                        toDrain.setAmount((long)(this.requiredAmount - this.amount));
                        this.amount = (int)((long)this.amount + ((GasStack)gasHandler.extractChemical((ChemicalStack)toDrain, Action.EXECUTE)).getAmount());
                        continue block6;
                    }
                    case INFUSION: {
                        if (!blockEntity.getCapability(Capabilities.INFUSION_HANDLER, direction.m_122424_()).isPresent()) continue block6;
                        IInfusionHandler infusionHandler = (IInfusionHandler)blockEntity.getCapability(Capabilities.INFUSION_HANDLER, direction.m_122424_()).resolve().get();
                        GasStack toDrain = (InfusionStack)this.currentChemical.copy();
                        toDrain.setAmount((long)(this.requiredAmount - this.amount));
                        this.amount = (int)((long)this.amount + ((InfusionStack)infusionHandler.extractChemical((ChemicalStack)toDrain, Action.EXECUTE)).getAmount());
                        continue block6;
                    }
                    case PIGMENT: {
                        if (!blockEntity.getCapability(Capabilities.PIGMENT_HANDLER, direction.m_122424_()).isPresent()) continue block6;
                        IPigmentHandler pigmentHandler = (IPigmentHandler)blockEntity.getCapability(Capabilities.PIGMENT_HANDLER, direction.m_122424_()).resolve().get();
                        GasStack toDrain = (PigmentStack)this.currentChemical.copy();
                        toDrain.setAmount((long)(this.requiredAmount - this.amount));
                        this.amount = (int)((long)this.amount + ((PigmentStack)pigmentHandler.extractChemical((ChemicalStack)toDrain, Action.EXECUTE)).getAmount());
                        continue block6;
                    }
                    case SLURRY: {
                        if (!blockEntity.getCapability(Capabilities.SLURRY_HANDLER, direction.m_122424_()).isPresent()) continue block6;
                        ISlurryHandler slurryHandler = (ISlurryHandler)blockEntity.getCapability(Capabilities.SLURRY_HANDLER, direction.m_122424_()).resolve().get();
                        GasStack toDrain = (SlurryStack)this.currentChemical.copy();
                        toDrain.setAmount((long)(this.requiredAmount - this.amount));
                        this.amount = (int)((long)this.amount + ((SlurryStack)slurryHandler.extractChemical((ChemicalStack)toDrain, Action.EXECUTE)).getAmount());
                    }
                }
            }
        }
        if (this.amount >= this.requiredAmount) {
            int energy = this.energyStorage.extractEnergy(Math.min(energyUsage, this.remainingProgress), false);
            this.remainingProgress -= energy;
        }
    }

    protected void finishProcess() {
        if (this.currentChemical.isEmpty()) {
            this.getChemical();
        }
        if (this.currentChemical.isEmpty()) {
            this.endProcess();
            return;
        }
        if (this.itemHandler.getStackInSlot(1).m_41619_()) {
            this.itemHandler.setStackInSlot(1, VolumePackageItem.tryMakeVolumePackage(this.currentChemical));
        } else if (this.itemHandler.getStackInSlot(1).m_41720_() instanceof IVolumePackageItem) {
            this.itemHandler.getStackInSlot(1).m_41769_(1);
        }
        this.endProcess();
    }

    public void startProcess() {
        this.remainingProgress = energyReq;
        this.amount = 0;
        this.m_6596_();
    }

    public void endProcess() {
        this.remainingProgress = 0;
        this.amount = 0;
        this.isWorking = false;
        this.m_6596_();
    }

    protected void ejectItem() {
        for (Direction direction : Direction.values()) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_121945_(direction));
            if (blockEntity == null || blockEntity instanceof UnpackagerBlockEntity || !blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, direction.m_122424_()).isPresent() || blockEntity.getCapability(Capabilities.GAS_HANDLER, direction.m_122424_()).isPresent() || blockEntity.getCapability(Capabilities.INFUSION_HANDLER, direction.m_122424_()).isPresent() || blockEntity.getCapability(Capabilities.PIGMENT_HANDLER, direction.m_122424_()).isPresent() || blockEntity.getCapability(Capabilities.SLURRY_HANDLER, direction.m_122424_()).isPresent()) continue;
            IItemHandler itemHandler = (IItemHandler)blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, direction.m_122424_()).resolve().get();
            ItemStack stack = this.itemHandler.getStackInSlot(1);
            if (stack.m_41619_()) continue;
            ItemStack stackRem = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)false);
            this.itemHandler.setStackInSlot(1, stackRem);
        }
    }

    protected void chargeEnergy() {
        ItemStack energyStack = this.itemHandler.getStackInSlot(2);
        if (energyStack.getCapability(ForgeCapabilities.ENERGY).isPresent()) {
            int energyRequest = Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored());
            this.energyStorage.receiveEnergy(((IEnergyStorage)energyStack.getCapability(ForgeCapabilities.ENERGY).resolve().get()).extractEnergy(energyRequest, false), false);
            if (energyStack.m_41613_() <= 0) {
                this.itemHandler.setStackInSlot(2, ItemStack.f_41583_);
            }
        }
    }

    public void updatePowered() {
        if (this.f_58857_.m_277086_(this.f_58858_) > 0 != this.powered) {
            boolean bl = this.powered = !this.powered;
            if (this.powered && !this.isWorking) {
                this.activated = true;
            }
            this.m_6596_();
        }
    }

    public int getComparatorSignal() {
        if (this.isWorking) {
            return 1;
        }
        if (!this.itemHandler.getStackInSlot(1).m_41619_()) {
            return 15;
        }
        return 0;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.isWorking = nbt.m_128471_("Working");
        this.amount = nbt.m_128451_("Amount");
        this.remainingProgress = nbt.m_128451_("Progress");
        this.powered = nbt.m_128471_("Powered");
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128379_("Working", this.isWorking);
        nbt.m_128405_("Amount", this.amount);
        nbt.m_128405_("Progress", this.remainingProgress);
        nbt.m_128379_("Powered", this.powered);
    }

    public void loadSync(CompoundTag nbt) {
        super.loadSync(nbt);
        this.currentChemical = BoxedChemicalStack.read((CompoundTag)nbt.m_128469_("Chemical")).getChemicalStack();
        this.requiredAmount = nbt.m_128451_("AmountReq");
    }

    public CompoundTag saveSync(CompoundTag nbt) {
        super.saveSync(nbt);
        nbt.m_128365_("Chemical", (Tag)BoxedChemicalStack.box(this.currentChemical).write(new CompoundTag()));
        nbt.m_128405_("AmountReq", this.requiredAmount);
        return nbt;
    }

    public void m_6596_() {
        if (this.isWorking && !this.isTemplateValid()) {
            this.endProcess();
        }
        super.m_6596_();
    }

    public int getScaledEnergy(int scale) {
        if (this.energyStorage.getMaxEnergyStored() <= 0) {
            return 0;
        }
        return Math.min(scale * this.energyStorage.getEnergyStored() / this.energyStorage.getMaxEnergyStored(), scale);
    }

    public int getScaledProgress(int scale) {
        if (this.remainingProgress <= 0 || energyReq <= 0) {
            return 0;
        }
        return scale * (energyReq - this.remainingProgress) / energyReq;
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
        this.sync(false);
        return new ChemicalPackageFillerMenu(windowId, inventory, this);
    }
}

