/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedmekemicals.capability;

import mekanism.api.Action;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class StackGasHandlerItem
implements IGasHandler {
    protected ItemStack container;

    public StackGasHandlerItem(ItemStack container) {
        this.container = container;
    }

    public GasStack getGas() {
        CompoundTag tagCompound = this.container.m_41783_();
        if (tagCompound == null || !tagCompound.m_128441_("Gas")) {
            return GasStack.EMPTY;
        }
        return GasStack.readFromNBT((CompoundTag)tagCompound.m_128469_("Gas"));
    }

    public void setGas(GasStack gas) {
        if (gas != null && !gas.isEmpty()) {
            if (!this.container.m_41782_()) {
                this.container.m_41751_(new CompoundTag());
            }
            CompoundTag gasTag = new CompoundTag();
            gas.write(gasTag);
            this.container.m_41783_().m_128365_("Gas", (Tag)gasTag);
        }
    }

    protected void setContainerToEmpty() {
        this.container.m_41774_(1);
    }

    public int getTanks() {
        return 1;
    }

    public GasStack getChemicalInTank(int tank) {
        return this.getGas();
    }

    public void setChemicalInTank(int tank, GasStack stack) {
        this.setGas(stack);
    }

    public long getTankCapacity(int tank) {
        return this.getGas().getAmount();
    }

    public boolean isValid(int tank, GasStack stack) {
        return true;
    }

    public GasStack insertChemical(int tank, GasStack resource, Action action) {
        return resource;
    }

    public GasStack extractChemical(int tank, long maxDrain, Action action) {
        GasStack gasStack = this.getGas();
        if (tank != 0 || maxDrain < gasStack.getAmount()) {
            return GasStack.EMPTY;
        }
        if (!gasStack.isEmpty()) {
            if (action.execute()) {
                this.setContainerToEmpty();
            }
            return gasStack;
        }
        return GasStack.EMPTY;
    }

    public GasStack getEmptyStack() {
        return GasStack.EMPTY;
    }
}

