/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedmekemicals.capability;

import mekanism.api.Action;
import mekanism.api.chemical.infuse.IInfusionHandler;
import mekanism.api.chemical.infuse.InfusionStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class StackInfusionHandlerItem
implements IInfusionHandler {
    protected ItemStack container;

    public StackInfusionHandlerItem(ItemStack container) {
        this.container = container;
    }

    public InfusionStack getInfusion() {
        CompoundTag tagCompound = this.container.m_41783_();
        if (tagCompound == null || !tagCompound.m_128441_("Infusion")) {
            return InfusionStack.EMPTY;
        }
        return InfusionStack.readFromNBT((CompoundTag)tagCompound.m_128469_("Infusion"));
    }

    public void setInfusion(InfusionStack infusion) {
        if (infusion != null && !infusion.isEmpty()) {
            if (!this.container.m_41782_()) {
                this.container.m_41751_(new CompoundTag());
            }
            CompoundTag infusionTag = new CompoundTag();
            infusion.write(infusionTag);
            this.container.m_41783_().m_128365_("Infusion", (Tag)infusionTag);
        }
    }

    protected void setContainerToEmpty() {
        this.container.m_41774_(1);
    }

    public int getTanks() {
        return 1;
    }

    public InfusionStack getChemicalInTank(int tank) {
        return this.getInfusion();
    }

    public void setChemicalInTank(int tank, InfusionStack stack) {
        this.setInfusion(stack);
    }

    public long getTankCapacity(int tank) {
        return this.getInfusion().getAmount();
    }

    public boolean isValid(int tank, InfusionStack stack) {
        return true;
    }

    public InfusionStack insertChemical(int tank, InfusionStack resource, Action action) {
        return resource;
    }

    public InfusionStack extractChemical(int tank, long maxDrain, Action action) {
        InfusionStack infusionStack = this.getInfusion();
        if (tank != 0 || maxDrain < infusionStack.getAmount()) {
            return InfusionStack.EMPTY;
        }
        if (!infusionStack.isEmpty()) {
            if (action.execute()) {
                this.setContainerToEmpty();
            }
            return infusionStack;
        }
        return InfusionStack.EMPTY;
    }

    public InfusionStack getEmptyStack() {
        return InfusionStack.EMPTY;
    }
}

