/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedmekemicals.capability;

import mekanism.api.Action;
import mekanism.api.chemical.pigment.IPigmentHandler;
import mekanism.api.chemical.pigment.PigmentStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class StackPigmentHandlerItem
implements IPigmentHandler {
    protected ItemStack container;

    public StackPigmentHandlerItem(ItemStack container) {
        this.container = container;
    }

    public PigmentStack getPigment() {
        CompoundTag tagCompound = this.container.m_41783_();
        if (tagCompound == null || !tagCompound.m_128441_("Pigment")) {
            return PigmentStack.EMPTY;
        }
        return PigmentStack.readFromNBT((CompoundTag)tagCompound.m_128469_("Pigment"));
    }

    public void setPigment(PigmentStack pigment) {
        if (pigment != null && !pigment.isEmpty()) {
            if (!this.container.m_41782_()) {
                this.container.m_41751_(new CompoundTag());
            }
            CompoundTag pigmentTag = new CompoundTag();
            pigment.write(pigmentTag);
            this.container.m_41783_().m_128365_("Pigment", (Tag)pigmentTag);
        }
    }

    protected void setContainerToEmpty() {
        this.container.m_41774_(1);
    }

    public int getTanks() {
        return 1;
    }

    public PigmentStack getChemicalInTank(int tank) {
        return this.getPigment();
    }

    public void setChemicalInTank(int tank, PigmentStack stack) {
        this.setPigment(stack);
    }

    public long getTankCapacity(int tank) {
        return this.getPigment().getAmount();
    }

    public boolean isValid(int tank, PigmentStack stack) {
        return true;
    }

    public PigmentStack insertChemical(int tank, PigmentStack resource, Action action) {
        return resource;
    }

    public PigmentStack extractChemical(int tank, long maxDrain, Action action) {
        PigmentStack pigmentStack = this.getPigment();
        if (tank != 0 || maxDrain < pigmentStack.getAmount()) {
            return PigmentStack.EMPTY;
        }
        if (!pigmentStack.isEmpty()) {
            if (action.execute()) {
                this.setContainerToEmpty();
            }
            return pigmentStack;
        }
        return PigmentStack.EMPTY;
    }

    public PigmentStack getEmptyStack() {
        return PigmentStack.EMPTY;
    }
}

