/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedmekemicals.capability;

import mekanism.api.Action;
import mekanism.api.chemical.slurry.ISlurryHandler;
import mekanism.api.chemical.slurry.SlurryStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class StackSlurryHandlerItem
implements ISlurryHandler {
    protected ItemStack container;

    public StackSlurryHandlerItem(ItemStack container) {
        this.container = container;
    }

    public SlurryStack getSlurry() {
        CompoundTag tagCompound = this.container.m_41783_();
        if (tagCompound == null || !tagCompound.m_128441_("Slurry")) {
            return SlurryStack.EMPTY;
        }
        return SlurryStack.readFromNBT((CompoundTag)tagCompound.m_128469_("Slurry"));
    }

    public void setSlurry(SlurryStack slurry) {
        if (slurry != null && !slurry.isEmpty()) {
            if (!this.container.m_41782_()) {
                this.container.m_41751_(new CompoundTag());
            }
            CompoundTag slurryTag = new CompoundTag();
            slurry.write(slurryTag);
            this.container.m_41783_().m_128365_("Slurry", (Tag)slurryTag);
        }
    }

    protected void setContainerToEmpty() {
        this.container.m_41774_(1);
    }

    public int getTanks() {
        return 1;
    }

    public SlurryStack getChemicalInTank(int tank) {
        return this.getSlurry();
    }

    public void setChemicalInTank(int tank, SlurryStack stack) {
        this.setSlurry(stack);
    }

    public long getTankCapacity(int tank) {
        return this.getSlurry().getAmount();
    }

    public boolean isValid(int tank, SlurryStack stack) {
        return true;
    }

    public SlurryStack insertChemical(int tank, SlurryStack resource, Action action) {
        return resource;
    }

    public SlurryStack extractChemical(int tank, long maxDrain, Action action) {
        SlurryStack slurryStack = this.getSlurry();
        if (tank != 0 || maxDrain < slurryStack.getAmount()) {
            return SlurryStack.EMPTY;
        }
        if (!slurryStack.isEmpty()) {
            if (action.execute()) {
                this.setContainerToEmpty();
            }
            return slurryStack;
        }
        return SlurryStack.EMPTY;
    }

    public SlurryStack getEmptyStack() {
        return SlurryStack.EMPTY;
    }
}

