/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedmekemicals.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import thelm.packagedmekemicals.block.entity.ChemicalPackageFillerBlockEntity;

public class PackagedMekemicalsConfig {
    private static ForgeConfigSpec serverSpec;
    public static ForgeConfigSpec.IntValue chemicalPackageFillerEnergyCapacity;
    public static ForgeConfigSpec.IntValue chemicalPackageFillerEnergyReq;
    public static ForgeConfigSpec.IntValue chemicalPackageFillerEnergyUsage;
    public static ForgeConfigSpec.IntValue chemicalPackageFillerRefreshInterval;

    private PackagedMekemicalsConfig() {
    }

    public static void registerConfig() {
        PackagedMekemicalsConfig.buildConfig();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)serverSpec);
    }

    private static void buildConfig() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.push("chemical_package_filler");
        builder.comment("How much FE the Chemical Package Filler should hold.");
        chemicalPackageFillerEnergyCapacity = builder.defineInRange("energy_capacity", 5000, 0, Integer.MAX_VALUE);
        builder.comment("How much total FE the Chemical Package Filler should use per operation.");
        chemicalPackageFillerEnergyReq = builder.defineInRange("energy_req", 500, 0, Integer.MAX_VALUE);
        builder.comment("How much FE/t maximum the Chemical Package Filler can use.");
        chemicalPackageFillerEnergyUsage = builder.defineInRange("energy_usage", 100, 0, Integer.MAX_VALUE);
        builder.comment("How many ticks should the Chemical Package Filler wait between each refresh.");
        chemicalPackageFillerRefreshInterval = builder.defineInRange("refresh_interval", 4, 1, 40);
        builder.pop();
        serverSpec = builder.build();
    }

    public static void reloadServerConfig() {
        ChemicalPackageFillerBlockEntity.energyCapacity = (Integer)chemicalPackageFillerEnergyCapacity.get();
        ChemicalPackageFillerBlockEntity.energyReq = (Integer)chemicalPackageFillerEnergyReq.get();
        ChemicalPackageFillerBlockEntity.energyUsage = (Integer)chemicalPackageFillerEnergyUsage.get();
        ChemicalPackageFillerBlockEntity.refreshInterval = (Integer)chemicalPackageFillerRefreshInterval.get();
    }
}

