/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedmekemicals.integration.jei;

import java.util.Optional;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IClickableIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.inventory.Slot;
import thelm.packagedauto.api.IVolumeStackWrapper;
import thelm.packagedauto.slot.FalseCopyVolumeSlot;
import thelm.packagedmekemicals.api.IChemicalStackWrapper;

public class ChemicalVolumeGuiHandler
implements IGuiContainerHandler<AbstractContainerScreen<?>> {
    private final IIngredientManager ingredientManager;

    public ChemicalVolumeGuiHandler(IIngredientManager ingredientManager) {
        this.ingredientManager = ingredientManager;
    }

    public Optional<IClickableIngredient<?>> getClickableIngredientUnderMouse(AbstractContainerScreen<?> containerScreen, double mouseX, double mouseY) {
        Slot slot = containerScreen.getSlotUnderMouse();
        if (slot instanceof FalseCopyVolumeSlot) {
            FalseCopyVolumeSlot volumeSlot = (FalseCopyVolumeSlot)slot;
            IVolumeStackWrapper volumeStack = volumeSlot.volumeInventory.getStackInSlot(volumeSlot.slotIndex);
            if (volumeStack instanceof IChemicalStackWrapper) {
                IChemicalStackWrapper chemicalVolumeStack = (IChemicalStackWrapper)volumeStack;
                return this.ingredientManager.createTypedIngredient(chemicalVolumeStack.getChemical()).map(ing -> new ClickableIngredient(ing, ChemicalVolumeGuiHandler.getSlotArea(containerScreen, (Slot)volumeSlot)));
            }
        }
        return Optional.empty();
    }

    private static Rect2i getSlotArea(AbstractContainerScreen<?> gui, Slot slot) {
        return new Rect2i(gui.getGuiLeft() + slot.f_40220_, gui.getGuiTop() + slot.f_40221_, 16, 16);
    }

    private record ClickableIngredient<T>(ITypedIngredient<T> ingredient, Rect2i area) implements IClickableIngredient<T>
    {
        public ITypedIngredient<T> getTypedIngredient() {
            return this.ingredient;
        }

        public Rect2i getArea() {
            return this.area;
        }
    }
}

