/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedmekemicals.util;

import java.util.Optional;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.infuse.IInfusionHandler;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.IPigmentHandler;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.ISlurryHandler;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemHandlerHelper;

public class ChemicalHelper {
    public static final ChemicalHelper INSTANCE = new ChemicalHelper();

    private ChemicalHelper() {
    }

    public LazyOptional<IGasHandler> getGasHandler(ItemStack itemStack) {
        return itemStack.getCapability(Capabilities.GAS_HANDLER);
    }

    public Optional<GasStack> getGasContained(ItemStack container) {
        if (!container.m_41619_()) {
            container = ItemHandlerHelper.copyStackWithSize((ItemStack)container, (int)1);
            return this.getGasHandler(container).map(handler -> (GasStack)handler.extractChemical(Long.MAX_VALUE, Action.SIMULATE)).filter(stack -> !stack.isEmpty());
        }
        return Optional.empty();
    }

    public LazyOptional<IInfusionHandler> getInfusionHandler(ItemStack itemStack) {
        return itemStack.getCapability(Capabilities.INFUSION_HANDLER);
    }

    public Optional<InfusionStack> getInfusionContained(ItemStack container) {
        if (!container.m_41619_()) {
            container = ItemHandlerHelper.copyStackWithSize((ItemStack)container, (int)1);
            return this.getInfusionHandler(container).map(handler -> (InfusionStack)handler.extractChemical(Long.MAX_VALUE, Action.SIMULATE)).filter(stack -> !stack.isEmpty());
        }
        return Optional.empty();
    }

    public LazyOptional<IPigmentHandler> getPigmentHandler(ItemStack itemStack) {
        return itemStack.getCapability(Capabilities.PIGMENT_HANDLER);
    }

    public Optional<PigmentStack> getPigmentContained(ItemStack container) {
        if (!container.m_41619_()) {
            container = ItemHandlerHelper.copyStackWithSize((ItemStack)container, (int)1);
            return this.getPigmentHandler(container).map(handler -> (PigmentStack)handler.extractChemical(Long.MAX_VALUE, Action.SIMULATE)).filter(stack -> !stack.isEmpty());
        }
        return Optional.empty();
    }

    public LazyOptional<ISlurryHandler> getSlurryHandler(ItemStack itemStack) {
        return itemStack.getCapability(Capabilities.SLURRY_HANDLER);
    }

    public Optional<SlurryStack> getSlurryContained(ItemStack container) {
        if (!container.m_41619_()) {
            container = ItemHandlerHelper.copyStackWithSize((ItemStack)container, (int)1);
            return this.getSlurryHandler(container).map(handler -> (SlurryStack)handler.extractChemical(Long.MAX_VALUE, Action.SIMULATE)).filter(stack -> !stack.isEmpty());
        }
        return Optional.empty();
    }

    public boolean hasChemicalHandler(ItemStack itemStack) {
        return this.getGasHandler(itemStack).isPresent() || this.getInfusionHandler(itemStack).isPresent() || this.getPigmentHandler(itemStack).isPresent() || this.getSlurryHandler(itemStack).isPresent();
    }

    public Optional<? extends ChemicalStack<?>> getChemicalContained(ItemStack container) {
        Optional<GasStack> optional = this.getGasContained(container);
        if (optional.isPresent()) {
            return optional;
        }
        optional = this.getInfusionContained(container);
        if (optional.isPresent()) {
            return optional;
        }
        optional = this.getPigmentContained(container);
        if (optional.isPresent()) {
            return optional;
        }
        optional = this.getSlurryContained(container);
        if (optional.isPresent()) {
            return optional;
        }
        return Optional.empty();
    }
}

