/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedmekemicals.volume;

import java.util.Optional;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.providers.IGasProvider;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.ModList;
import thelm.packagedauto.api.IVolumeStackWrapper;
import thelm.packagedauto.api.IVolumeType;
import thelm.packagedmekemicals.capability.StackGasHandlerItem;
import thelm.packagedmekemicals.client.ChemicalRenderer;
import thelm.packagedmekemicals.util.ChemicalHelper;
import thelm.packagedmekemicals.volume.GasStackWrapper;

public class GasVolumeType
implements IVolumeType {
    public static final GasVolumeType INSTANCE = new GasVolumeType();
    public static final ResourceLocation NAME = new ResourceLocation("mekanism:gas");

    public ResourceLocation getName() {
        return NAME;
    }

    public Class<?> getTypeClass() {
        return GasStack.class;
    }

    public Class<?> getTypeBaseClass() {
        return Gas.class;
    }

    public MutableComponent getDisplayName() {
        return Component.m_237115_((String)"volume.packagedmekemicals.mekanism.gas");
    }

    public boolean supportsAE() {
        return ModList.get().isLoaded("appmek");
    }

    public Optional<?> makeStackFromBase(Object volumeBase, int amount, CompoundTag nbt) {
        if (volumeBase instanceof Gas) {
            Gas gas = (Gas)volumeBase;
            return Optional.of(new GasStack((IGasProvider)gas, (long)amount));
        }
        if (volumeBase instanceof GasStack) {
            GasStack gasStack = (GasStack)volumeBase;
            gasStack = gasStack.copy();
            gasStack.setAmount((long)amount);
            return Optional.of(gasStack);
        }
        return Optional.empty();
    }

    public IVolumeStackWrapper getEmptyStackInstance() {
        return GasStackWrapper.EMPTY;
    }

    public Optional<IVolumeStackWrapper> wrapStack(Object volumeStack) {
        GasStack gasStack;
        if (volumeStack instanceof GasStack && ChemicalAttributeValidator.DEFAULT.process((ChemicalStack)(gasStack = (GasStack)volumeStack))) {
            return Optional.of(new GasStackWrapper(gasStack));
        }
        return Optional.empty();
    }

    public Optional<IVolumeStackWrapper> getStackContained(ItemStack container) {
        return ChemicalHelper.INSTANCE.getGasContained(container).map(GasStackWrapper::new);
    }

    public void setStack(ItemStack stack, IVolumeStackWrapper volumeStack) {
        if (volumeStack instanceof GasStackWrapper) {
            GasStackWrapper gasStack = (GasStackWrapper)volumeStack;
            ChemicalHelper.INSTANCE.getGasHandler(stack).ifPresent(handler -> {
                if (handler instanceof StackGasHandlerItem) {
                    StackGasHandlerItem vHandler = (StackGasHandlerItem)handler;
                    vHandler.setGas(gasStack.stack());
                }
            });
        }
    }

    public IVolumeStackWrapper loadStack(CompoundTag tag) {
        return new GasStackWrapper(GasStack.readFromNBT((CompoundTag)tag));
    }

    public IGasHandler makeItemCapability(ItemStack volumePackage) {
        return new StackGasHandlerItem(volumePackage);
    }

    public Capability<IGasHandler> getItemCapability() {
        return Capabilities.GAS_HANDLER;
    }

    public boolean hasBlockCapability(ICapabilityProvider capProvider, Direction direction) {
        return capProvider.getCapability(Capabilities.GAS_HANDLER, direction).isPresent();
    }

    public boolean isEmpty(ICapabilityProvider capProvider, Direction direction) {
        return capProvider.getCapability(Capabilities.GAS_HANDLER, direction).map(handler -> {
            if (handler.getTanks() == 0) {
                return false;
            }
            for (int i = 0; i < handler.getTanks(); ++i) {
                if (((GasStack)handler.getChemicalInTank(i)).isEmpty()) continue;
                return false;
            }
            return true;
        }).orElse(false);
    }

    public int fill(ICapabilityProvider capProvider, Direction direction, IVolumeStackWrapper resource, boolean simulate) {
        if (resource instanceof GasStackWrapper) {
            GasStackWrapper gasStack = (GasStackWrapper)resource;
            Action action = simulate ? Action.SIMULATE : Action.EXECUTE;
            return capProvider.getCapability(Capabilities.GAS_HANDLER, direction).map(handler -> (GasStack)handler.insertChemical((ChemicalStack)gasStack.stack(), action)).map(stack -> (long)gasStack.getAmount() - stack.getAmount()).orElse(0L).intValue();
        }
        return 0;
    }

    public IVolumeStackWrapper drain(ICapabilityProvider capProvider, Direction direction, IVolumeStackWrapper resource, boolean simulate) {
        if (resource instanceof GasStackWrapper) {
            GasStackWrapper gasStack = (GasStackWrapper)resource;
            Action action = simulate ? Action.SIMULATE : Action.EXECUTE;
            return capProvider.getCapability(Capabilities.GAS_HANDLER, direction).map(handler -> (GasStack)handler.extractChemical((ChemicalStack)gasStack.stack(), action)).map(GasStackWrapper::new).orElse(GasStackWrapper.EMPTY);
        }
        return GasStackWrapper.EMPTY;
    }

    public void render(GuiGraphics graphics, int i, int j, IVolumeStackWrapper stack) {
        if (stack instanceof GasStackWrapper) {
            GasStackWrapper gasStack = (GasStackWrapper)stack;
            ChemicalRenderer.INSTANCE.render(graphics, i, j, (ChemicalStack<?>)gasStack.stack());
        }
    }
}

