/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedmekemicals.volume;

import java.util.Optional;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.chemical.infuse.IInfusionHandler;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.providers.IInfuseTypeProvider;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.ModList;
import thelm.packagedauto.api.IVolumeStackWrapper;
import thelm.packagedauto.api.IVolumeType;
import thelm.packagedmekemicals.capability.StackInfusionHandlerItem;
import thelm.packagedmekemicals.client.ChemicalRenderer;
import thelm.packagedmekemicals.util.ChemicalHelper;
import thelm.packagedmekemicals.volume.InfusionStackWrapper;

public class InfusionVolumeType
implements IVolumeType {
    public static final InfusionVolumeType INSTANCE = new InfusionVolumeType();
    public static final ResourceLocation NAME = new ResourceLocation("mekanism:infuse_type");

    public ResourceLocation getName() {
        return NAME;
    }

    public Class<?> getTypeClass() {
        return InfusionStack.class;
    }

    public Class<?> getTypeBaseClass() {
        return InfuseType.class;
    }

    public MutableComponent getDisplayName() {
        return Component.m_237115_((String)"volume.packagedmekemicals.mekanism.infuse_type");
    }

    public boolean supportsAE() {
        return ModList.get().isLoaded("appmek");
    }

    public Optional<?> makeStackFromBase(Object volumeBase, int amount, CompoundTag nbt) {
        if (volumeBase instanceof InfuseType) {
            InfuseType infusion = (InfuseType)volumeBase;
            return Optional.of(new InfusionStack((IInfuseTypeProvider)infusion, (long)amount));
        }
        if (volumeBase instanceof InfusionStack) {
            InfusionStack infusionStack = (InfusionStack)volumeBase;
            infusionStack = infusionStack.copy();
            infusionStack.setAmount((long)amount);
            return Optional.of(infusionStack);
        }
        return Optional.empty();
    }

    public IVolumeStackWrapper getEmptyStackInstance() {
        return InfusionStackWrapper.EMPTY;
    }

    public Optional<IVolumeStackWrapper> wrapStack(Object volumeStack) {
        InfusionStack infusionStack;
        if (volumeStack instanceof InfusionStack && ChemicalAttributeValidator.DEFAULT.process((ChemicalStack)(infusionStack = (InfusionStack)volumeStack))) {
            return Optional.of(new InfusionStackWrapper(infusionStack));
        }
        return Optional.empty();
    }

    public Optional<IVolumeStackWrapper> getStackContained(ItemStack container) {
        return ChemicalHelper.INSTANCE.getInfusionContained(container).map(InfusionStackWrapper::new);
    }

    public void setStack(ItemStack stack, IVolumeStackWrapper volumeStack) {
        if (volumeStack instanceof InfusionStackWrapper) {
            InfusionStackWrapper infusionStack = (InfusionStackWrapper)volumeStack;
            ChemicalHelper.INSTANCE.getInfusionHandler(stack).ifPresent(handler -> {
                if (handler instanceof StackInfusionHandlerItem) {
                    StackInfusionHandlerItem vHandler = (StackInfusionHandlerItem)handler;
                    vHandler.setInfusion(infusionStack.stack());
                }
            });
        }
    }

    public IVolumeStackWrapper loadStack(CompoundTag tag) {
        return new InfusionStackWrapper(InfusionStack.readFromNBT((CompoundTag)tag));
    }

    public IInfusionHandler makeItemCapability(ItemStack volumePackage) {
        return new StackInfusionHandlerItem(volumePackage);
    }

    public Capability<IInfusionHandler> getItemCapability() {
        return Capabilities.INFUSION_HANDLER;
    }

    public boolean hasBlockCapability(ICapabilityProvider capProvider, Direction direction) {
        return capProvider.getCapability(Capabilities.INFUSION_HANDLER, direction).isPresent();
    }

    public boolean isEmpty(ICapabilityProvider capProvider, Direction direction) {
        return capProvider.getCapability(Capabilities.INFUSION_HANDLER, direction).map(handler -> {
            if (handler.getTanks() == 0) {
                return false;
            }
            for (int i = 0; i < handler.getTanks(); ++i) {
                if (((InfusionStack)handler.getChemicalInTank(i)).isEmpty()) continue;
                return false;
            }
            return true;
        }).orElse(false);
    }

    public int fill(ICapabilityProvider capProvider, Direction direction, IVolumeStackWrapper resource, boolean simulate) {
        if (resource instanceof InfusionStackWrapper) {
            InfusionStackWrapper infusionStack = (InfusionStackWrapper)resource;
            Action action = simulate ? Action.SIMULATE : Action.EXECUTE;
            return capProvider.getCapability(Capabilities.INFUSION_HANDLER, direction).map(handler -> (InfusionStack)handler.insertChemical((ChemicalStack)infusionStack.stack(), action)).map(stack -> (long)infusionStack.getAmount() - stack.getAmount()).orElse(0L).intValue();
        }
        return 0;
    }

    public IVolumeStackWrapper drain(ICapabilityProvider capProvider, Direction direction, IVolumeStackWrapper resource, boolean simulate) {
        if (resource instanceof InfusionStackWrapper) {
            InfusionStackWrapper infusionStack = (InfusionStackWrapper)resource;
            Action action = simulate ? Action.SIMULATE : Action.EXECUTE;
            return capProvider.getCapability(Capabilities.INFUSION_HANDLER, direction).map(handler -> (InfusionStack)handler.extractChemical((ChemicalStack)infusionStack.stack(), action)).map(InfusionStackWrapper::new).orElse(InfusionStackWrapper.EMPTY);
        }
        return InfusionStackWrapper.EMPTY;
    }

    public void render(GuiGraphics graphics, int i, int j, IVolumeStackWrapper stack) {
        if (stack instanceof InfusionStackWrapper) {
            InfusionStackWrapper infusionStack = (InfusionStackWrapper)stack;
            ChemicalRenderer.INSTANCE.render(graphics, i, j, (ChemicalStack<?>)infusionStack.stack());
        }
    }
}

