/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedmekemicals.volume;

import java.util.Optional;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.chemical.pigment.IPigmentHandler;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.providers.IPigmentProvider;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.ModList;
import thelm.packagedauto.api.IVolumeStackWrapper;
import thelm.packagedauto.api.IVolumeType;
import thelm.packagedmekemicals.capability.StackPigmentHandlerItem;
import thelm.packagedmekemicals.client.ChemicalRenderer;
import thelm.packagedmekemicals.util.ChemicalHelper;
import thelm.packagedmekemicals.volume.PigmentStackWrapper;

public class PigmentVolumeType
implements IVolumeType {
    public static final PigmentVolumeType INSTANCE = new PigmentVolumeType();
    public static final ResourceLocation NAME = new ResourceLocation("mekanism:pigment");

    public ResourceLocation getName() {
        return NAME;
    }

    public Class<?> getTypeClass() {
        return PigmentStack.class;
    }

    public Class<?> getTypeBaseClass() {
        return Pigment.class;
    }

    public MutableComponent getDisplayName() {
        return Component.m_237115_((String)"volume.packagedmekemicals.mekanism.pigment");
    }

    public boolean supportsAE() {
        return ModList.get().isLoaded("appmek");
    }

    public Optional<?> makeStackFromBase(Object volumeBase, int amount, CompoundTag nbt) {
        if (volumeBase instanceof Pigment) {
            Pigment pigment = (Pigment)volumeBase;
            return Optional.of(new PigmentStack((IPigmentProvider)pigment, (long)amount));
        }
        if (volumeBase instanceof PigmentStack) {
            PigmentStack pigmentStack = (PigmentStack)volumeBase;
            pigmentStack = pigmentStack.copy();
            pigmentStack.setAmount((long)amount);
            return Optional.of(pigmentStack);
        }
        return Optional.empty();
    }

    public IVolumeStackWrapper getEmptyStackInstance() {
        return PigmentStackWrapper.EMPTY;
    }

    public Optional<IVolumeStackWrapper> wrapStack(Object volumeStack) {
        PigmentStack pigmentStack;
        if (volumeStack instanceof PigmentStack && ChemicalAttributeValidator.DEFAULT.process((ChemicalStack)(pigmentStack = (PigmentStack)volumeStack))) {
            return Optional.of(new PigmentStackWrapper(pigmentStack));
        }
        return Optional.empty();
    }

    public Optional<IVolumeStackWrapper> getStackContained(ItemStack container) {
        return ChemicalHelper.INSTANCE.getPigmentContained(container).map(PigmentStackWrapper::new);
    }

    public void setStack(ItemStack stack, IVolumeStackWrapper volumeStack) {
        if (volumeStack instanceof PigmentStackWrapper) {
            PigmentStackWrapper pigmentStack = (PigmentStackWrapper)volumeStack;
            ChemicalHelper.INSTANCE.getPigmentHandler(stack).ifPresent(handler -> {
                if (handler instanceof StackPigmentHandlerItem) {
                    StackPigmentHandlerItem vHandler = (StackPigmentHandlerItem)handler;
                    vHandler.setPigment(pigmentStack.stack());
                }
            });
        }
    }

    public IVolumeStackWrapper loadStack(CompoundTag tag) {
        return new PigmentStackWrapper(PigmentStack.readFromNBT((CompoundTag)tag));
    }

    public IPigmentHandler makeItemCapability(ItemStack volumePackage) {
        return new StackPigmentHandlerItem(volumePackage);
    }

    public Capability<IPigmentHandler> getItemCapability() {
        return Capabilities.PIGMENT_HANDLER;
    }

    public boolean hasBlockCapability(ICapabilityProvider capProvider, Direction direction) {
        return capProvider.getCapability(Capabilities.PIGMENT_HANDLER, direction).isPresent();
    }

    public boolean isEmpty(ICapabilityProvider capProvider, Direction direction) {
        return capProvider.getCapability(Capabilities.PIGMENT_HANDLER, direction).map(handler -> {
            if (handler.getTanks() == 0) {
                return false;
            }
            for (int i = 0; i < handler.getTanks(); ++i) {
                if (((PigmentStack)handler.getChemicalInTank(i)).isEmpty()) continue;
                return false;
            }
            return true;
        }).orElse(false);
    }

    public int fill(ICapabilityProvider capProvider, Direction direction, IVolumeStackWrapper resource, boolean simulate) {
        if (resource instanceof PigmentStackWrapper) {
            PigmentStackWrapper pigmentStack = (PigmentStackWrapper)resource;
            Action action = simulate ? Action.SIMULATE : Action.EXECUTE;
            return capProvider.getCapability(Capabilities.PIGMENT_HANDLER, direction).map(handler -> (PigmentStack)handler.insertChemical((ChemicalStack)pigmentStack.stack(), action)).map(stack -> (long)pigmentStack.getAmount() - stack.getAmount()).orElse(0L).intValue();
        }
        return 0;
    }

    public IVolumeStackWrapper drain(ICapabilityProvider capProvider, Direction direction, IVolumeStackWrapper resource, boolean simulate) {
        if (resource instanceof PigmentStackWrapper) {
            PigmentStackWrapper pigmentStack = (PigmentStackWrapper)resource;
            Action action = simulate ? Action.SIMULATE : Action.EXECUTE;
            return capProvider.getCapability(Capabilities.PIGMENT_HANDLER, direction).map(handler -> (PigmentStack)handler.extractChemical((ChemicalStack)pigmentStack.stack(), action)).map(PigmentStackWrapper::new).orElse(PigmentStackWrapper.EMPTY);
        }
        return PigmentStackWrapper.EMPTY;
    }

    public void render(GuiGraphics graphics, int i, int j, IVolumeStackWrapper stack) {
        if (stack instanceof PigmentStackWrapper) {
            PigmentStackWrapper pigmentStack = (PigmentStackWrapper)stack;
            ChemicalRenderer.INSTANCE.render(graphics, i, j, (ChemicalStack<?>)pigmentStack.stack());
        }
    }
}

