/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedmekemicals.volume;

import java.util.Optional;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.chemical.slurry.ISlurryHandler;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.providers.ISlurryProvider;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.ModList;
import thelm.packagedauto.api.IVolumeStackWrapper;
import thelm.packagedauto.api.IVolumeType;
import thelm.packagedmekemicals.capability.StackSlurryHandlerItem;
import thelm.packagedmekemicals.client.ChemicalRenderer;
import thelm.packagedmekemicals.util.ChemicalHelper;
import thelm.packagedmekemicals.volume.SlurryStackWrapper;

public class SlurryVolumeType
implements IVolumeType {
    public static final SlurryVolumeType INSTANCE = new SlurryVolumeType();
    public static final ResourceLocation NAME = new ResourceLocation("mekanism:slurry");

    public ResourceLocation getName() {
        return NAME;
    }

    public Class<?> getTypeClass() {
        return SlurryStack.class;
    }

    public Class<?> getTypeBaseClass() {
        return Slurry.class;
    }

    public MutableComponent getDisplayName() {
        return Component.m_237115_((String)"volume.packagedmekemicals.mekanism.slurry");
    }

    public boolean supportsAE() {
        return ModList.get().isLoaded("appmek");
    }

    public Optional<?> makeStackFromBase(Object volumeBase, int amount, CompoundTag nbt) {
        if (volumeBase instanceof Slurry) {
            Slurry slurry = (Slurry)volumeBase;
            return Optional.of(new SlurryStack((ISlurryProvider)slurry, (long)amount));
        }
        if (volumeBase instanceof SlurryStack) {
            SlurryStack slurryStack = (SlurryStack)volumeBase;
            slurryStack = slurryStack.copy();
            slurryStack.setAmount((long)amount);
            return Optional.of(slurryStack);
        }
        return Optional.empty();
    }

    public IVolumeStackWrapper getEmptyStackInstance() {
        return SlurryStackWrapper.EMPTY;
    }

    public Optional<IVolumeStackWrapper> wrapStack(Object volumeStack) {
        SlurryStack slurryStack;
        if (volumeStack instanceof SlurryStack && ChemicalAttributeValidator.DEFAULT.process((ChemicalStack)(slurryStack = (SlurryStack)volumeStack))) {
            return Optional.of(new SlurryStackWrapper(slurryStack));
        }
        return Optional.empty();
    }

    public Optional<IVolumeStackWrapper> getStackContained(ItemStack container) {
        return ChemicalHelper.INSTANCE.getSlurryContained(container).map(SlurryStackWrapper::new);
    }

    public void setStack(ItemStack stack, IVolumeStackWrapper volumeStack) {
        if (volumeStack instanceof SlurryStackWrapper) {
            SlurryStackWrapper slurryStack = (SlurryStackWrapper)volumeStack;
            ChemicalHelper.INSTANCE.getSlurryHandler(stack).ifPresent(handler -> {
                if (handler instanceof StackSlurryHandlerItem) {
                    StackSlurryHandlerItem vHandler = (StackSlurryHandlerItem)handler;
                    vHandler.setSlurry(slurryStack.stack());
                }
            });
        }
    }

    public IVolumeStackWrapper loadStack(CompoundTag tag) {
        return new SlurryStackWrapper(SlurryStack.readFromNBT((CompoundTag)tag));
    }

    public ISlurryHandler makeItemCapability(ItemStack volumePackage) {
        return new StackSlurryHandlerItem(volumePackage);
    }

    public Capability<ISlurryHandler> getItemCapability() {
        return Capabilities.SLURRY_HANDLER;
    }

    public boolean hasBlockCapability(ICapabilityProvider capProvider, Direction direction) {
        return capProvider.getCapability(Capabilities.SLURRY_HANDLER, direction).isPresent();
    }

    public boolean isEmpty(ICapabilityProvider capProvider, Direction direction) {
        return capProvider.getCapability(Capabilities.SLURRY_HANDLER, direction).map(handler -> {
            if (handler.getTanks() == 0) {
                return false;
            }
            for (int i = 0; i < handler.getTanks(); ++i) {
                if (((SlurryStack)handler.getChemicalInTank(i)).isEmpty()) continue;
                return false;
            }
            return true;
        }).orElse(false);
    }

    public int fill(ICapabilityProvider capProvider, Direction direction, IVolumeStackWrapper resource, boolean simulate) {
        if (resource instanceof SlurryStackWrapper) {
            SlurryStackWrapper slurryStack = (SlurryStackWrapper)resource;
            Action action = simulate ? Action.SIMULATE : Action.EXECUTE;
            return capProvider.getCapability(Capabilities.SLURRY_HANDLER, direction).map(handler -> (SlurryStack)handler.insertChemical((ChemicalStack)slurryStack.stack(), action)).map(stack -> (long)slurryStack.getAmount() - stack.getAmount()).orElse(0L).intValue();
        }
        return 0;
    }

    public IVolumeStackWrapper drain(ICapabilityProvider capProvider, Direction direction, IVolumeStackWrapper resource, boolean simulate) {
        if (resource instanceof SlurryStackWrapper) {
            SlurryStackWrapper slurryStack = (SlurryStackWrapper)resource;
            Action action = simulate ? Action.SIMULATE : Action.EXECUTE;
            return capProvider.getCapability(Capabilities.SLURRY_HANDLER, direction).map(handler -> (SlurryStack)handler.extractChemical((ChemicalStack)slurryStack.stack(), action)).map(SlurryStackWrapper::new).orElse(SlurryStackWrapper.EMPTY);
        }
        return SlurryStackWrapper.EMPTY;
    }

    public void render(GuiGraphics graphics, int i, int j, IVolumeStackWrapper stack) {
        if (stack instanceof SlurryStackWrapper) {
            SlurryStackWrapper slurryStack = (SlurryStackWrapper)stack;
            ChemicalRenderer.INSTANCE.render(graphics, i, j, (ChemicalStack<?>)slurryStack.stack());
        }
    }
}

