/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.registry;

import com.github.alexthe666.rats.registry.RatlantisItemRegistry;
import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.server.items.upgrades.BaseRatUpgradeItem;
import com.github.alexthe666.rats.server.items.upgrades.interfaces.CombinedUpgrade;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

@Deprecated
public class RatsUpgradeConflictRegistry {
    private static final Map<Item, Item[]> REGISTERED_CONFLICTS = Maps.newHashMap();
    public static final Item[] HARVEST_CONFLICTS = new Item[]{(Item)RatsItemRegistry.RAT_UPGRADE_PICKPOCKET.get(), (Item)RatsItemRegistry.RAT_UPGRADE_GARDENER.get(), (Item)RatsItemRegistry.RAT_UPGRADE_LUMBERJACK.get(), (Item)RatsItemRegistry.RAT_UPGRADE_QUARRY.get(), (Item)RatsItemRegistry.RAT_UPGRADE_FARMER.get(), (Item)RatsItemRegistry.RAT_UPGRADE_FISHERMAN.get(), (Item)RatsItemRegistry.RAT_UPGRADE_MILKER.get(), (Item)RatsItemRegistry.RAT_UPGRADE_SHEARS.get(), (Item)RatsItemRegistry.RAT_UPGRADE_PLACER.get(), (Item)RatsItemRegistry.RAT_UPGRADE_BREEDER.get()};
    public static final Item[] TRANSPORT_CONFLICTS = new Item[]{(Item)RatsItemRegistry.RAT_UPGRADE_BASIC_ENERGY.get(), (Item)RatsItemRegistry.RAT_UPGRADE_ADVANCED_ENERGY.get(), (Item)RatsItemRegistry.RAT_UPGRADE_ELITE_ENERGY.get(), (Item)RatsItemRegistry.RAT_UPGRADE_EXTREME_ENERGY.get(), (Item)RatsItemRegistry.RAT_UPGRADE_BUCKET.get(), (Item)RatsItemRegistry.RAT_UPGRADE_BIG_BUCKET.get()};
    public static final Item[] EXPLOSION_CONFLICTS = new Item[]{(Item)RatsItemRegistry.RAT_UPGRADE_TNT.get(), (Item)RatsItemRegistry.RAT_UPGRADE_TNT_SURVIVOR.get(), (Item)RatlantisItemRegistry.RAT_UPGRADE_BUCCANEER.get()};
    public static final Item[] PROCESSING_CONFLICTS = new Item[]{(Item)RatsItemRegistry.RAT_UPGRADE_CRAFTING.get(), (Item)RatsItemRegistry.RAT_UPGRADE_CHEF.get(), (Item)RatlantisItemRegistry.RAT_UPGRADE_ARCHEOLOGIST.get(), (Item)RatsItemRegistry.RAT_UPGRADE_CHRISTMAS.get(), (Item)RatsItemRegistry.RAT_UPGRADE_ENCHANTER.get(), (Item)RatsItemRegistry.RAT_UPGRADE_DISENCHANTER.get()};
    public static final Item[] MOUNT_CONFLICTS = new Item[]{(Item)RatsItemRegistry.RAT_UPGRADE_CHICKEN_MOUNT.get(), (Item)RatsItemRegistry.RAT_UPGRADE_GOLEM_MOUNT.get(), (Item)RatsItemRegistry.RAT_UPGRADE_STRIDER_MOUNT.get(), (Item)RatlantisItemRegistry.RAT_UPGRADE_AUTOMATON_MOUNT.get(), (Item)RatsItemRegistry.RAT_UPGRADE_BEAST_MOUNT.get(), (Item)RatlantisItemRegistry.RAT_UPGRADE_BIPLANE_MOUNT.get()};

    public static void init() {
        REGISTERED_CONFLICTS.put((Item)RatsItemRegistry.RAT_UPGRADE_BLACKLIST.get(), new Item[]{(Item)RatsItemRegistry.RAT_UPGRADE_WHITELIST.get()});
        REGISTERED_CONFLICTS.put((Item)RatsItemRegistry.RAT_UPGRADE_WHITELIST.get(), new Item[]{(Item)RatsItemRegistry.RAT_UPGRADE_BLACKLIST.get()});
        REGISTERED_CONFLICTS.put((Item)RatsItemRegistry.RAT_UPGRADE_FLIGHT.get(), new Item[]{(Item)RatsItemRegistry.RAT_UPGRADE_BEE.get(), (Item)RatsItemRegistry.RAT_UPGRADE_DRAGON.get()});
        REGISTERED_CONFLICTS.put((Item)RatsItemRegistry.RAT_UPGRADE_BEE.get(), new Item[]{(Item)RatsItemRegistry.RAT_UPGRADE_FLIGHT.get(), (Item)RatsItemRegistry.RAT_UPGRADE_DRAGON.get()});
        REGISTERED_CONFLICTS.put((Item)RatsItemRegistry.RAT_UPGRADE_DRAGON.get(), new Item[]{(Item)RatsItemRegistry.RAT_UPGRADE_FLIGHT.get(), (Item)RatsItemRegistry.RAT_UPGRADE_BEE.get(), (Item)RatsItemRegistry.RAT_UPGRADE_ASBESTOS.get()});
        REGISTERED_CONFLICTS.put((Item)RatsItemRegistry.RAT_UPGRADE_ASBESTOS.get(), new Item[]{(Item)RatsItemRegistry.RAT_UPGRADE_DAMAGE_PROTECTION.get()});
        REGISTERED_CONFLICTS.put((Item)RatsItemRegistry.RAT_UPGRADE_POISON.get(), new Item[]{(Item)RatsItemRegistry.RAT_UPGRADE_DAMAGE_PROTECTION.get()});
        REGISTERED_CONFLICTS.put((Item)RatsItemRegistry.RAT_UPGRADE_UNDERWATER.get(), new Item[]{(Item)RatsItemRegistry.RAT_UPGRADE_DAMAGE_PROTECTION.get()});
        REGISTERED_CONFLICTS.put((Item)RatsItemRegistry.RAT_UPGRADE_DAMAGE_PROTECTION.get(), new Item[]{(Item)RatsItemRegistry.RAT_UPGRADE_ASBESTOS.get(), (Item)RatsItemRegistry.RAT_UPGRADE_POISON.get(), (Item)RatsItemRegistry.RAT_UPGRADE_UNDERWATER.get()});
        Arrays.stream(HARVEST_CONFLICTS).toList().forEach(item -> REGISTERED_CONFLICTS.put((Item)item, HARVEST_CONFLICTS));
        Arrays.stream(TRANSPORT_CONFLICTS).toList().forEach(item -> REGISTERED_CONFLICTS.put((Item)item, TRANSPORT_CONFLICTS));
        Arrays.stream(EXPLOSION_CONFLICTS).toList().forEach(item -> REGISTERED_CONFLICTS.put((Item)item, EXPLOSION_CONFLICTS));
        Arrays.stream(PROCESSING_CONFLICTS).toList().forEach(item -> REGISTERED_CONFLICTS.put((Item)item, PROCESSING_CONFLICTS));
        Arrays.stream(MOUNT_CONFLICTS).toList().forEach(item -> REGISTERED_CONFLICTS.put((Item)item, MOUNT_CONFLICTS));
    }

    public static boolean doesConflict(ItemStack newItem, ItemStack existingItem) {
        block7: {
            Item[] arr;
            block8: {
                Item tag;
                block6: {
                    if (!(existingItem.m_41720_() instanceof BaseRatUpgradeItem)) {
                        return false;
                    }
                    if (newItem.m_150930_(existingItem.m_41720_()) && !newItem.m_150930_((Item)RatsItemRegistry.RAT_UPGRADE_JURY_RIGGED.get())) {
                        return true;
                    }
                    arr = REGISTERED_CONFLICTS.get(newItem.m_41720_());
                    Item[] itemArray = newItem.m_41720_();
                    if (!(itemArray instanceof CombinedUpgrade)) break block6;
                    CombinedUpgrade combined = (CombinedUpgrade)itemArray;
                    tag = newItem.m_41783_();
                    if (tag == null || !tag.m_128425_("Items", 9)) break block7;
                    NonNullList upgradeList = NonNullList.m_122780_((int)combined.getUpgradeSlots(), (Object)ItemStack.f_41583_);
                    ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)upgradeList);
                    for (ItemStack selectedUpgrade : upgradeList) {
                        if (!RatsUpgradeConflictRegistry.doesConflict(selectedUpgrade, existingItem)) continue;
                        return true;
                    }
                    break block7;
                }
                tag = existingItem.m_41720_();
                if (!(tag instanceof CombinedUpgrade)) break block8;
                CombinedUpgrade combined = (CombinedUpgrade)tag;
                tag = existingItem.m_41783_();
                if (tag == null || !tag.m_128425_("Items", 9)) break block7;
                NonNullList upgradeList = NonNullList.m_122780_((int)combined.getUpgradeSlots(), (Object)ItemStack.f_41583_);
                ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)upgradeList);
                for (ItemStack selectedUpgrade : upgradeList) {
                    if (!RatsUpgradeConflictRegistry.doesConflict(selectedUpgrade, newItem)) continue;
                    return true;
                }
                break block7;
            }
            if (arr != null) {
                for (Item item : arr) {
                    if (!existingItem.m_150930_(item)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void registerConflict(BaseRatUpgradeItem yourUpgrade, BaseRatUpgradeItem ... conflictingUpgrades) {
        REGISTERED_CONFLICTS.put(yourUpgrade, conflictingUpgrades);
    }
}

