/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.block.entity;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.registry.RatlantisBlockEntityRegistry;
import com.github.alexthe666.rats.registry.RatlantisEntityRegistry;
import com.github.alexthe666.rats.registry.RatsParticleRegistry;
import com.github.alexthe666.rats.registry.RatsSoundRegistry;
import com.github.alexthe666.rats.registry.worldgen.RatlantisDimensionRegistry;
import com.github.alexthe666.rats.server.entity.monster.boss.Dutchrat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.ForgeEventFactory;

public class DutchratBellBlockEntity
extends BlockEntity {
    public int ticks;
    public boolean shaking;
    public Direction clickDirection;
    private int ticksToExplode = -1;

    public DutchratBellBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RatlantisBlockEntityRegistry.DUTCHRAT_BELL.get(), pos, state);
    }

    public boolean m_7531_(int id, int type) {
        if (id == 1) {
            this.clickDirection = Direction.m_122407_((int)type);
            this.ticks = 0;
            this.shaking = true;
            return true;
        }
        if (id == 2) {
            this.ticksToExplode = 0;
            return true;
        }
        return super.m_7531_(id, type);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, DutchratBellBlockEntity te) {
        double extraZ;
        double extraX;
        if (level.m_6436_(pos).m_19048_() == Difficulty.PEACEFUL) {
            te.ticksToExplode = -1;
        }
        if (te.shaking) {
            ++te.ticks;
        }
        if (te.ticks >= 120) {
            te.shaking = false;
            te.ticks = 0;
        }
        if (te.ticks >= 5 && te.ticksToExplode == -1 && !level.m_5776_()) {
            if (RatConfig.summonDutchratOnlyInRatlantis && !level.m_46472_().equals(RatlantisDimensionRegistry.DIMENSION_KEY)) {
                for (Player player : level.m_45976_(Player.class, new AABB(pos).m_82400_(16.0))) {
                    player.m_5661_((Component)Component.m_237115_((String)"entity.rats.dutchrat.ratlantis"), true);
                }
            } else if (level.m_46461_()) {
                for (Player players : level.m_45976_(Player.class, new AABB(pos).m_82400_(16.0))) {
                    players.m_5661_((Component)Component.m_237115_((String)"entity.rats.dutchrat.daytime"), true);
                }
            } else if (level.m_6436_(pos).m_19048_() != Difficulty.PEACEFUL) {
                te.ticksToExplode = 0;
                Dutchrat dutchrat = new Dutchrat((EntityType<? extends Monster>)((EntityType)RatlantisEntityRegistry.DUTCHRAT.get()), level);
                dutchrat.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 10.0, (double)pos.m_123343_() + 0.5);
                dutchrat.setBellSummoned();
                ForgeEventFactory.onFinalizeSpawn((Mob)dutchrat, (ServerLevelAccessor)((ServerLevelAccessor)level), (DifficultyInstance)level.m_6436_(pos), (MobSpawnType)MobSpawnType.MOB_SUMMONED, null, null);
                dutchrat.m_21446_(pos, RatConfig.dutchratRestrictionRadius);
                level.m_7967_((Entity)dutchrat);
                level.m_7696_(pos, state.m_60734_(), 2, Direction.NORTH.m_122416_());
            }
        }
        if (te.ticksToExplode > -1) {
            ++te.ticksToExplode;
        }
        if (te.ticksToExplode > 0 && te.ticksToExplode <= 50) {
            for (int i = 0; i < 10; ++i) {
                float angle = (float)Math.PI / 180 * ((float)te.ticksToExplode * ((float)te.ticksToExplode * 0.1f) + (float)(i * 36));
                extraX = (double)Mth.m_14040_((int)(te.ticksToExplode - 50)) * 0.25 * (double)Mth.m_14031_((float)((float)Math.PI + angle)) + (double)pos.m_123341_() + 0.5;
                extraZ = (double)Mth.m_14040_((int)(te.ticksToExplode - 50)) * 0.25 * (double)Mth.m_14089_((float)angle) + (double)pos.m_123343_() + 0.5;
                level.m_7106_((ParticleOptions)RatsParticleRegistry.DUTCHRAT_SMOKE.get(), extraX, (double)pos.m_123342_() + 0.75, extraZ, 24.0, 0.0, 0.0);
            }
        } else if (te.ticksToExplode > 60 && te.ticksToExplode < 168) {
            level.m_7106_((ParticleOptions)RatsParticleRegistry.DUTCHRAT_SMOKE.get(), (double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1 + te.ticksToExplode % 12), (double)pos.m_123343_() + 0.5, 12.0, 0.0, 0.0);
        }
        if (te.ticksToExplode > 80 && te.ticksToExplode < 170) {
            for (int i = 0; i < Math.min((te.ticksToExplode - 75) / 10, 5); ++i) {
                float angle = (float)Math.PI / 180 * ((float)(te.ticksToExplode * 20) + (float)i * (360.0f / (float)(i + 1)));
                extraX = 2.0 * (double)Mth.m_14031_((float)((float)Math.PI + angle)) + (double)pos.m_123341_() + 0.5;
                extraZ = 2.0 * (double)Mth.m_14089_((float)angle) + (double)pos.m_123343_() + 0.5;
                level.m_7106_((ParticleOptions)RatsParticleRegistry.DUTCHRAT_SMOKE.get(), extraX, (double)(pos.m_123342_() + 10 + i), extraZ, 12.0, 0.0, 0.0);
            }
        }
        if (te.ticksToExplode == 160) {
            level.m_5594_(null, pos, (SoundEvent)RatsSoundRegistry.DUTCHRAT_LAUGH.get(), SoundSource.BLOCKS, 10.0f, 1.0f);
        }
        if (te.ticksToExplode == 180) {
            level.m_46961_(pos, false);
        }
    }

    public void onHit(Level level, Direction direction) {
        BlockPos blockpos = this.m_58899_();
        this.clickDirection = direction;
        if (this.shaking) {
            this.ticks = 0;
        } else {
            this.shaking = true;
        }
        level.m_7696_(blockpos, this.m_58900_().m_60734_(), 1, direction.m_122416_());
    }

    public boolean canDestroyBell() {
        return this.ticksToExplode < 0;
    }
}

