/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.block.entity;

import com.github.alexthe666.rats.registry.RatsBlockEntityRegistry;
import com.github.alexthe666.rats.registry.RatsSoundRegistry;
import com.github.alexthe666.rats.server.block.RatTrapBlock;
import com.github.alexthe666.rats.server.entity.rat.Rat;
import com.github.alexthe666.rats.server.misc.RatUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class RatTrapBlockEntity
extends BlockEntity {
    public float shutProgress;
    private NonNullList<ItemStack> baitStack = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);

    public RatTrapBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RatsBlockEntityRegistry.RAT_TRAP.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, RatTrapBlockEntity te) {
        if (level.m_5776_()) {
            if (((Boolean)state.m_61143_((Property)RatTrapBlock.SHUT)).booleanValue() && te.shutProgress < 6.0f) {
                te.shutProgress += 1.5f;
            } else if (!((Boolean)state.m_61143_((Property)RatTrapBlock.SHUT)).booleanValue() && te.shutProgress > 0.0f) {
                te.shutProgress -= 1.5f;
            }
        } else if (RatUtils.isRatFood((ItemStack)te.baitStack.get(0))) {
            te.killRats(level, pos, state);
        }
    }

    private void killRats(Level level, BlockPos pos, BlockState state) {
        if (!((Boolean)state.m_61143_((Property)RatTrapBlock.SHUT)).booleanValue()) {
            for (Rat rat : level.m_45976_(Rat.class, new AABB(pos).m_82400_(0.25))) {
                if (rat.isDead() || rat.isDeadInTrap()) continue;
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)RatTrapBlock.SHUT, (Comparable)Boolean.valueOf(true)));
                rat.setKilledInTrap();
                level.m_5594_(null, this.m_58899_(), (SoundEvent)RatsSoundRegistry.RAT_TRAP_CLOSE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                this.decreaseBait();
                level.m_7260_(pos, state, state, 3);
                level.m_45976_(Rat.class, new AABB(pos).m_82400_(8.0)).forEach(rat1 -> rat1.setFleePos(pos));
                break;
            }
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, BlockEntity::m_5995_);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        this.handleUpdateTag(packet.m_131708_());
    }

    public CompoundTag m_5995_() {
        return this.m_187481_();
    }

    public void m_183515_(CompoundTag compound) {
        ContainerHelper.m_18973_((CompoundTag)compound, this.baitStack);
        compound.m_128350_("ShutProgress", this.shutProgress);
        super.m_183515_(compound);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.baitStack = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)compound, this.baitStack);
        this.shutProgress = compound.m_128457_("ShutProgress");
    }

    public ItemStack getBait() {
        return (ItemStack)this.baitStack.get(0);
    }

    private void decreaseBait() {
        ((ItemStack)this.baitStack.get(0)).m_41774_(1);
    }

    public void setBaitStack(ItemStack stack) {
        this.baitStack.set(0, (Object)stack);
    }
}

