/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai.goal.harvest;

import com.github.alexthe666.rats.data.tags.RatsBlockTags;
import com.github.alexthe666.rats.registry.RatsBlockRegistry;
import com.github.alexthe666.rats.server.block.entity.RatQuarryBlockEntity;
import com.github.alexthe666.rats.server.entity.ai.goal.harvest.BaseRatHarvestGoal;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.misc.RatUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class RatQuarryGoal
extends BaseRatHarvestGoal {
    private final TamedRat rat;
    private int breakingTime;
    private int previousBreakProgress;
    private BlockState prevMiningState = null;

    public RatQuarryGoal(TamedRat rat) {
        super(rat);
        this.rat = rat;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    @Override
    public boolean m_8036_() {
        if (!(super.m_8036_() && !this.rat.getDepositPos().isEmpty() && this.rat.getDepositPos().get().m_122640_().equals(this.rat.m_9236_().m_46472_()) && this.rat.m_9236_().m_8055_(this.rat.getDepositPos().get().m_122646_()).m_60713_((Block)RatsBlockRegistry.RAT_QUARRY.get()) && this.checkTheBasics(false, false))) {
            return false;
        }
        this.resetTarget();
        return this.getTargetBlock() != null && this.canRatHoldTargetedBlock(this.rat.m_9236_(), this.getTargetBlock());
    }

    @Override
    public boolean isReadyToFire() {
        if (this.nextStartTick > 0) {
            --this.nextStartTick;
            return false;
        }
        this.nextStartTick = this.m_183277_(10);
        return true;
    }

    private void resetTarget() {
        BlockEntity blockEntity;
        ArrayList<BlockPos> allBlocks = new ArrayList<BlockPos>();
        GlobalPos quarryPos = this.rat.getDepositPos().orElse(null);
        if (quarryPos != null && (blockEntity = this.rat.m_9236_().m_7702_(quarryPos.m_122646_())) instanceof RatQuarryBlockEntity) {
            RatQuarryBlockEntity quarry = (RatQuarryBlockEntity)blockEntity;
            int RADIUS = quarry.getRadius();
            for (BlockPos pos : BlockPos.m_121990_((BlockPos)quarryPos.m_122646_().m_7918_(-RADIUS, -1, -RADIUS), (BlockPos)new BlockPos(quarryPos.m_122646_().m_123341_() + RADIUS, this.rat.m_9236_().m_141937_(), quarryPos.m_122646_().m_123343_() + RADIUS)).map(BlockPos::m_7949_).toList()) {
                if (this.rat.m_9236_().m_46859_(pos) || !this.doesListContainBlock(this.rat.m_9236_(), pos) || !this.canMineBlock(pos)) continue;
                allBlocks.add(pos);
            }
            if (!allBlocks.isEmpty()) {
                allBlocks.sort(new QuarryBlockSorter(this.rat));
                this.setTargetBlock((BlockPos)allBlocks.get(allBlocks.size() - 1));
            }
        }
    }

    private boolean doesListContainBlock(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        ItemStack getStack = state.m_60734_().m_7397_((BlockGetter)level, pos, state);
        return this.rat.canRatPickupItem(getStack);
    }

    private boolean canRatHoldTargetedBlock(Level level, BlockPos pos) {
        if (this.rat.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
            return true;
        }
        BlockState state = level.m_8055_(pos);
        LootParams.Builder loot = new LootParams.Builder((ServerLevel)level).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_287286_(LootContextParams.f_81460_, (Object)this.rat.m_20182_()).m_287239_(1.0f);
        List drops = state.m_287290_(loot);
        return drops.stream().map(ItemStack::m_41720_).toList().contains(this.rat.m_21120_(InteractionHand.MAIN_HAND).m_41720_());
    }

    public boolean m_8045_() {
        return this.checkTheBasics(false, true) && this.getTargetBlock() != null && !this.rat.m_9236_().m_8055_(this.getTargetBlock()).m_60795_();
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        this.rat.crafting = false;
    }

    public void m_8037_() {
        if (this.getTargetBlock() != null) {
            BlockPos rayPos = this.getOffsetFromTarget(this.rat.m_9236_(), this.getTargetBlock());
            if (this.rat.m_20077_() && this.rat.m_9236_().m_8055_(this.rat.m_20183_().m_7494_()).m_60795_()) {
                this.rat.m_9236_().m_46597_(this.rat.m_20183_().m_7494_(), Blocks.f_49990_.m_49966_());
                this.rat.m_5634_(15.0f);
                this.rat.m_21569_().m_24901_();
            }
            if (this.rat.m_20069_() && this.rat.m_9236_().m_8055_(this.rat.m_20183_().m_7494_()).m_60795_()) {
                this.setTargetBlock(this.rat.m_20183_());
                this.rat.m_9236_().m_46597_(this.rat.m_20183_().m_7494_(), Blocks.f_50056_.m_49966_());
                this.rat.m_21569_().m_24901_();
            }
            this.rat.m_21573_().m_26519_((double)rayPos.m_123341_(), (double)rayPos.m_123342_(), (double)rayPos.m_123343_(), 1.0);
            double distance = this.rat.getRatDistanceCenterSq((double)this.getTargetBlock().m_123341_() + 0.5, (double)this.getTargetBlock().m_123342_() + 0.5, (double)this.getTargetBlock().m_123343_() + 0.5);
            if (!this.rat.m_21566_().m_24995_() && (this.rat.m_20096_() || this.rat.m_20069_() || this.rat.m_20077_() || this.rat.isRidingSpecialMount())) {
                BlockState block = this.rat.m_9236_().m_8055_(this.getTargetBlock());
                SoundType soundType = block.m_60734_().getSoundType(block, (LevelReader)this.rat.m_9236_(), this.getTargetBlock(), null);
                if (!block.m_60795_() && distance < this.rat.getRatHarvestDistance(5.0)) {
                    this.rat.m_21573_().m_26573_();
                    this.rat.m_9236_().m_7605_((Entity)this.rat, (byte)85);
                    this.rat.crafting = true;
                    if (block == this.prevMiningState) {
                        this.rat.m_9236_().m_7605_((Entity)this.rat, (byte)85);
                        this.rat.crafting = true;
                    } else {
                        this.rat.m_9236_().m_7605_((Entity)this.rat, (byte)86);
                        this.rat.crafting = false;
                    }
                    if (distance < this.rat.getRatHarvestDistance(-2.0)) {
                        this.rat.m_20256_(Vec3.f_82478_);
                    }
                    ++this.breakingTime;
                    int hardness = (int)(block.m_60800_((BlockGetter)this.rat.m_9236_(), this.getTargetBlock()) * 10.0f);
                    int i = (int)((float)this.breakingTime / (float)hardness * 10.0f);
                    if (this.breakingTime % 5 == 0) {
                        this.rat.m_5496_(soundType.m_56778_(), soundType.m_56773_() + 1.0f, soundType.m_56774_());
                    }
                    if (i != this.previousBreakProgress) {
                        this.rat.m_9236_().m_6801_(this.rat.m_19879_(), this.getTargetBlock(), i);
                        this.previousBreakProgress = i;
                    }
                    if (this.breakingTime >= hardness) {
                        this.rat.m_9236_().m_7605_((Entity)this.rat, (byte)86);
                        this.rat.m_5496_(soundType.m_56775_(), soundType.m_56773_(), soundType.m_56774_());
                        this.rat.m_5496_(SoundEvents.f_12019_, 1.0f, 1.0f);
                        this.breakingTime = 0;
                        this.previousBreakProgress = -1;
                        BlockState state = this.rat.m_9236_().m_8055_(this.getTargetBlock());
                        if (!state.m_60713_(Blocks.f_50056_) && !state.m_60713_(Blocks.f_50057_)) {
                            this.holdItemHarvestedIfPossible(this.rat, Block.m_49874_((BlockState)state, (ServerLevel)((ServerLevel)this.rat.m_9236_()), (BlockPos)this.getTargetBlock(), null, (Entity)this.rat, (ItemStack)this.rat.m_21205_()));
                        }
                        this.rat.m_9236_().m_46961_(this.getTargetBlock(), false);
                        this.m_8041_();
                    }
                    this.prevMiningState = block;
                }
            }
        }
    }

    private BlockPos getOffsetFromTarget(Level level, BlockPos initialPos) {
        for (Direction direction : Direction.values()) {
            if (!level.m_8055_(initialPos.m_121945_(direction)).m_60795_()) continue;
            return initialPos.m_121945_(direction);
        }
        return initialPos;
    }

    private boolean canMineBlock(BlockPos rayPos) {
        BlockState state = this.rat.m_9236_().m_8055_(rayPos);
        return !state.m_204336_(RatsBlockTags.QUARRY_IGNORABLES) && this.doesListContainBlock(this.rat.m_9236_(), rayPos) && RatUtils.canRatBreakBlock(this.rat.m_9236_(), rayPos, this.rat);
    }

    public record QuarryBlockSorter(TamedRat rat) implements Comparator<BlockPos>
    {
        @Override
        public int compare(BlockPos pos1, BlockPos pos2) {
            FluidState state1 = this.rat().m_9236_().m_6425_(pos2);
            FluidState state2 = this.rat().m_9236_().m_6425_(pos1);
            double distance1 = pos2.m_123342_();
            double distance2 = pos1.m_123342_();
            if (state1.m_76170_() && !state2.m_76170_()) {
                return 1;
            }
            if (state2.m_76170_() && !state1.m_76170_()) {
                return -1;
            }
            return Double.compare(distance2, distance1);
        }
    }
}

