/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.items.upgrades;

import com.github.alexthe666.rats.client.model.entity.RatModel;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.items.upgrades.BaseRatUpgradeItem;
import com.github.alexthe666.rats.server.items.upgrades.interfaces.DamageImmunityUpgrade;
import com.github.alexthe666.rats.server.items.upgrades.interfaces.HoldsItemUpgrade;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public abstract class BaseFlightRatUpgradeItem
extends BaseRatUpgradeItem
implements HoldsItemUpgrade,
DamageImmunityUpgrade {
    public BaseFlightRatUpgradeItem(Item.Properties properties, int rarity, int textLines) {
        super(properties, rarity, textLines);
    }

    @Override
    public boolean canFly(TamedRat rat) {
        return true;
    }

    public abstract ItemStack getWing();

    @Override
    public boolean playIdleAnimation(TamedRat rat) {
        return false;
    }

    @Override
    public void renderHeldItem(EntityRendererProvider.Context context, TamedRat rat, RatModel<?> model, PoseStack stack, MultiBufferSource buffer, int light, float ageInTicks) {
        float wingAngle = !rat.isFlying() ? 0.0f : Mth.m_14031_((float)ageInTicks) * 30.0f;
        float wingFold = !rat.isFlying() ? -45.0f : 0.0f;
        model.body1.translateRotate(stack);
        model.body2.translateRotate(stack);
        stack.m_85836_();
        stack.m_252880_(0.0f, -0.1f, 0.0f);
        stack.m_252781_(Axis.f_252393_.m_252977_(wingAngle));
        stack.m_252781_(Axis.f_252436_.m_252977_(wingFold));
        stack.m_252880_(0.55f, 0.0f, 0.2f);
        stack.m_252781_(Axis.f_252495_.m_252977_(90.0f));
        stack.m_85841_(2.0f, 2.0f, 1.0f);
        context.m_174025_().m_269128_(this.getWing(), ItemDisplayContext.GROUND, light, OverlayTexture.f_118083_, stack, buffer, null, rat.m_19879_());
        stack.m_85849_();
        stack.m_85836_();
        stack.m_252880_(0.0f, -0.1f, 0.0f);
        stack.m_252781_(Axis.f_252403_.m_252977_(wingAngle));
        stack.m_252781_(Axis.f_252392_.m_252977_(wingFold));
        stack.m_252880_(-0.55f, 0.01f, 0.2f);
        stack.m_252781_(Axis.f_252495_.m_252977_(90.0f));
        stack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        stack.m_85841_(2.0f, 2.0f, 1.0f);
        context.m_174025_().m_269128_(this.getWing(), ItemDisplayContext.GROUND, light, OverlayTexture.f_118083_, stack, buffer, null, rat.m_19879_());
        stack.m_85849_();
    }

    @Override
    public boolean isFakeHandRender() {
        return true;
    }

    @Override
    public boolean isImmuneToDamageSource(TamedRat rat, DamageSource source) {
        return source.m_269533_(DamageTypeTags.f_268549_);
    }
}

