/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.world;

import com.github.alexthe666.rats.registry.worldgen.RatlantisFeatureRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class ThickBranchingTrunkPlacer
extends TrunkPlacer {
    public static final Codec<ThickBranchingTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> ThickBranchingTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)instance).and(instance.group((App)Codec.INT.fieldOf("trunk_width").forGetter(o -> o.trunkWidth), (App)Codec.INT.fieldOf("base_radius").forGetter(o -> o.baseRadius), (App)Codec.INT.fieldOf("branch_depth").forGetter(o -> o.branchDepth))).apply((Applicative)instance, ThickBranchingTrunkPlacer::new));
    private final int trunkWidth;
    private final int baseRadius;
    private final int branchDepth;

    public ThickBranchingTrunkPlacer(int baseHeight, int heightRandA, int heightRandB, int trunkWidth, int baseRadius, int branchDepth) {
        super(baseHeight, heightRandA, heightRandB);
        this.trunkWidth = trunkWidth;
        this.baseRadius = baseRadius;
        this.branchDepth = branchDepth;
    }

    protected TrunkPlacerType<?> m_7362_() {
        return (TrunkPlacerType)RatlantisFeatureRegistry.THICK_BASE_BRANCHING_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader reader, BiConsumer<BlockPos, BlockState> consumer, RandomSource random, int treeHeight, BlockPos pos, TreeConfiguration config) {
        ArrayList<FoliagePlacer.FoliageAttachment> attachments = new ArrayList<FoliagePlacer.FoliageAttachment>();
        for (int baseX = -this.baseRadius; baseX <= this.baseRadius; ++baseX) {
            for (int baseZ = -this.baseRadius; baseZ <= this.baseRadius; ++baseZ) {
                if (baseX * baseX + baseZ * baseZ > this.baseRadius * this.baseRadius) continue;
                BlockPos basePos = pos.m_7918_(baseX, 0, baseZ);
                consumer.accept(basePos, config.f_68185_.m_213972_(random, basePos));
                for (int baseHeight = 0; baseHeight <= random.m_188503_(this.baseRadius + 1); ++baseHeight) {
                    consumer.accept(basePos.m_6630_(baseHeight), config.f_68185_.m_213972_(random, basePos.m_6630_(baseHeight)));
                }
                this.setDirtIfNeeded(reader, consumer, random, basePos.m_7495_(), config);
            }
        }
        for (int currentHeight = 0; currentHeight < treeHeight; ++currentHeight) {
            for (int xWidth = 0; xWidth < this.trunkWidth; ++xWidth) {
                for (int zWidth = 0; zWidth < this.trunkWidth; ++zWidth) {
                    this.m_226187_(reader, consumer, random, pos.m_7918_(xWidth, currentHeight, zWidth), config);
                }
            }
        }
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            int branchIterations = random.m_188503_(this.branchDepth);
            int branchHeight = treeHeight - 1 + random.m_188503_(3);
            attachments.addAll(this.generateRecursiveBranch(reader, consumer, random, pos, config, dir, branchHeight, new BlockPos.MutableBlockPos(), branchIterations, new ArrayList<FoliagePlacer.FoliageAttachment>()));
        }
        return attachments;
    }

    private List<FoliagePlacer.FoliageAttachment> generateRecursiveBranch(LevelSimulatedReader reader, BiConsumer<BlockPos, BlockState> consumer, RandomSource random, BlockPos pos, TreeConfiguration config, Direction genDir, int initialBranchHeight, BlockPos.MutableBlockPos mutablePos, int branchDepth, List<FoliagePlacer.FoliageAttachment> attachments) {
        Function<BlockState, BlockState> function = state -> (BlockState)state.m_263224_((Property)RotatedPillarBlock.f_55923_, (Comparable)genDir.m_122434_());
        mutablePos.m_122190_((Vec3i)pos).m_122175_(Direction.UP, initialBranchHeight);
        int branchLength = random.m_188503_(2) + 3;
        BlockPos blockpos = pos.m_5484_(genDir, branchLength).m_6630_(initialBranchHeight + random.m_188503_(2) + 1);
        int k = random.m_188499_() ? 2 : 1;
        for (int l = 0; l < k; ++l) {
            this.m_226175_(reader, consumer, random, (BlockPos)mutablePos.m_122173_(genDir), config, function);
        }
        Direction direction = Direction.UP;
        while (true) {
            int i1;
            if ((i1 = mutablePos.m_123333_((Vec3i)blockpos)) <= 0) {
                attachments.add(new FoliagePlacer.FoliageAttachment(blockpos, 0, this.trunkWidth > 1));
                if (branchDepth <= 0) {
                    return attachments;
                }
                return this.generateRecursiveBranch(reader, consumer, random, mutablePos.m_7949_(), config, random.m_188499_() ? genDir.m_122427_() : genDir.m_122428_(), 0, new BlockPos.MutableBlockPos(), branchDepth - 1, attachments);
            }
            float f = (float)Math.abs(blockpos.m_123342_() - mutablePos.m_123342_()) / (float)i1;
            boolean flag1 = random.m_188501_() < f;
            mutablePos.m_122173_(flag1 ? direction : genDir);
            this.m_226175_(reader, consumer, random, (BlockPos)mutablePos, config, flag1 ? Function.identity() : function);
        }
    }

    private void setDirtIfNeeded(LevelSimulatedReader reader, BiConsumer<BlockPos, BlockState> consumer, RandomSource random, BlockPos pos, TreeConfiguration config) {
        if (!((LevelReader)reader).m_8055_(pos).onTreeGrow((LevelReader)reader, consumer, random, pos, config) && Feature.m_159759_((BlockState)((LevelReader)reader).m_8055_(pos))) {
            consumer.accept(pos, config.f_161212_.m_213972_(random, pos));
        }
    }
}

