/*
 * Decompiled with CFR 0.152.
 */
package com.leo.sanguine_networks.block.entity;

import com.leo.sanguine_networks.Config;
import com.leo.sanguine_networks.block.menu.VSacrificerMenu;
import com.leo.sanguine_networks.init.ModBlockEntities;
import com.leo.sanguine_networks.recipe.CatalystRecipe;
import com.leo.sanguine_networks.recipe.ModelRecipe;
import com.leo.sanguine_networks.util.Pair;
import dev.shadowsoffire.hostilenetworks.Hostile;
import dev.shadowsoffire.hostilenetworks.data.DataModel;
import dev.shadowsoffire.hostilenetworks.data.DataModelRegistry;
import dev.shadowsoffire.hostilenetworks.data.ModelTier;
import dev.shadowsoffire.hostilenetworks.item.DataModelItem;
import dev.shadowsoffire.placebo.cap.ModifiableEnergyStorage;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wayoftime.bloodmagic.common.tile.TileAltar;

public class VSBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            VSBlockEntity.this.sync();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0 -> stack.m_41720_() instanceof DataModelItem;
                default -> true;
            };
        }
    };
    private ModifiableEnergyStorage energyStorage;
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> lazyEnergyStorage = LazyOptional.empty();
    private int catalystUses = 0;
    private int maxCatalystUses = 0;
    private int progress = 0;
    private int maxProgress = 0;
    private int toProduce = 0;
    private float catalystMult = 0.0f;
    private float altarMultiplier;
    private boolean missingModel = false;
    private BlockPos altarPos;
    TileAltar bloodAltar;
    private final ContainerData containerData = new ContainerData(){

        public int m_6413_(int pIndex) {
            return switch (pIndex) {
                case 0 -> VSBlockEntity.this.energyStorage.getEnergyStored();
                case 1 -> VSBlockEntity.this.energyStorage.getMaxEnergyStored();
                case 2 -> VSBlockEntity.this.catalystUses;
                case 3 -> VSBlockEntity.this.maxCatalystUses;
                case 4 -> VSBlockEntity.this.progress;
                case 5 -> VSBlockEntity.this.maxProgress;
                case 6 -> VSBlockEntity.this.toProduce;
                case 7 -> (int)(VSBlockEntity.this.catalystMult * 1000.0f);
                case 8 -> {
                    if (VSBlockEntity.this.bloodAltar != null) {
                        yield 1;
                    }
                    yield 0;
                }
                case 9 -> {
                    if (VSBlockEntity.this.missingModel) {
                        yield 1;
                    }
                    yield 0;
                }
                case 10 -> (int)(VSBlockEntity.this.altarMultiplier * 1000.0f);
                default -> -1;
            };
        }

        public void m_8050_(int pIndex, int pValue) {
        }

        public int m_6499_() {
            return 11;
        }
    };

    public VSBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.V_SACRIFICER_BE.get(), pPos, pBlockState);
        this.energyStorage = new ModifiableEnergyStorage(Config.sacrificerEnergy, Config.sacrificerEnergy, 0, 0);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"sanguine_networks.container.vsacrificer");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new VSacrificerMenu(i, inventory, this, this.containerData);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        return super.getCapability(cap);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyStorage.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
        this.lazyEnergyStorage = LazyOptional.of(() -> this.energyStorage);
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        pTag.m_128405_("energy", this.energyStorage.getEnergyStored());
        pTag.m_128405_("catalystUses", this.catalystUses);
        pTag.m_128405_("maxCatalystUses", this.maxCatalystUses);
        pTag.m_128350_("catalystMult", this.catalystMult);
        pTag.m_128405_("toProduce", this.toProduce);
        pTag.m_128405_("progress", this.progress);
        pTag.m_128405_("maxProgress", this.maxProgress);
        if (this.altarPos != null) {
            pTag.m_128365_("altarPos", (Tag)NbtUtils.m_129224_((BlockPos)this.altarPos));
        }
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        CompoundTag inv = pTag.m_128469_("inventory");
        this.itemHandler.deserializeNBT(inv);
        this.energyStorage.setEnergy(pTag.m_128451_("energy"));
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
        this.lazyEnergyStorage = LazyOptional.of(() -> this.energyStorage);
        this.catalystUses = pTag.m_128451_("catalystUses");
        this.maxCatalystUses = pTag.m_128451_("maxCatalystUses");
        this.catalystMult = pTag.m_128457_("catalystMult");
        this.toProduce = pTag.m_128451_("toProduce");
        this.progress = pTag.m_128451_("progress");
        this.maxProgress = pTag.m_128451_("maxProgress");
        if (pTag.m_128441_("altarPos")) {
            this.altarPos = NbtUtils.m_129239_((CompoundTag)pTag.m_128469_("altarPos"));
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
        this.lazyEnergyStorage.invalidate();
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void drops() {
        SimpleContainer container = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            container.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.m_58904_(), (BlockPos)this.m_58899_(), (Container)container);
    }

    public void tick() {
        boolean hasCatalyst;
        TileAltar altar;
        BlockEntity blockEntity;
        this.bloodAltar = this.altarPos != null && (blockEntity = this.f_58857_.m_7702_(this.altarPos)) instanceof TileAltar ? (altar = (TileAltar)blockEntity) : null;
        if (this.maxProgress != Config.sacrificerSpeed) {
            this.maxProgress = Config.sacrificerSpeed;
        }
        boolean bl = hasCatalyst = this.catalystUses > 0 || this.catalystUses == -1;
        if (!this.getCatalystStack().m_41619_() && !hasCatalyst) {
            this.maxCatalystUses = (Integer)this.getCatalystFromStack((ItemStack)this.getCatalystStack()).second;
            this.catalystMult = ((Float)this.getCatalystFromStack((ItemStack)this.getCatalystStack()).first).floatValue();
            this.catalystUses = this.maxCatalystUses;
            this.getCatalystStack().m_41774_(1);
            this.sync();
        }
        boolean bl2 = this.missingModel = this.getModelStack().m_41619_() || (Integer)this.getModelFromStack((ItemStack)this.getModelStack()).first == 0 && (Integer)this.getModelFromStack((ItemStack)this.getModelStack()).second == 0;
        if (this.missingModel) {
            this.progress = 0;
            this.toProduce = 0;
            this.sync();
            return;
        }
        if (!hasCatalyst && this.catalystUses <= 0 && this.catalystUses != -1) {
            this.catalystMult = 1.0f;
        }
        this.toProduce = (int)((float)((Integer)this.getModelFromStack((ItemStack)this.getModelStack()).first).intValue() * this.catalystMult);
        if (this.energyStorage.getEnergyStored() < this.getRFTick()) {
            this.sync();
            return;
        }
        if (this.bloodAltar == null) {
            this.sync();
            return;
        }
        this.altarMultiplier = 1.0f + this.bloodAltar.getSacrificeMultiplier();
        this.toProduce = (int)((float)this.toProduce * this.altarMultiplier);
        if (this.bloodAltar.getCurrentBlood() + this.toProduce >= this.bloodAltar.getCapacity()) {
            this.sync();
            return;
        }
        ++this.progress;
        this.energyStorage.setEnergy(this.energyStorage.getEnergyStored() - this.getRFTick());
        if (this.progress < this.maxProgress) {
            this.sync();
            return;
        }
        if (hasCatalyst && this.maxCatalystUses > 1) {
            --this.catalystUses;
        }
        this.progress = 0;
        this.bloodAltar.fillMainTank(this.toProduce);
        int data = DataModelItem.getData((ItemStack)this.getModelStack());
        DataModel model = (DataModel)DataModelItem.getStoredModel((ItemStack)this.getModelStack()).get();
        ModelTier tier = ModelTier.getByData((DataModel)model, (int)data);
        if (tier != ModelTier.FAULTY || Config.faultyData) {
            data += Config.sacrificerData;
        }
        DataModelItem.setData((ItemStack)this.getModelStack(), (int)data);
        this.sync();
    }

    public void sync() {
        this.m_6596_();
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public Pair<Float, Integer> getCatalystFromStack(ItemStack stack) {
        if (this.f_58857_.f_46443_) {
            return Pair.of(Float.valueOf(0.0f), 0);
        }
        if (this.getModelStack().m_41619_()) {
            return Pair.of(Float.valueOf(0.0f), 0);
        }
        List catalystRecipes = this.f_58857_.m_7465_().m_44013_((RecipeType)CatalystRecipe.Type.INSTANCE);
        for (CatalystRecipe recipe : catalystRecipes) {
            if (!recipe.getInput().test(stack)) continue;
            return Pair.of(Float.valueOf(recipe.getMultiplier()), recipe.getUses());
        }
        return Pair.of(Float.valueOf(0.0f), 0);
    }

    public ItemStack getModelStack() {
        return this.itemHandler.getStackInSlot(0);
    }

    public Pair<Integer, Integer> getModelFromStack(ItemStack stack) {
        String mobId = stack.m_41698_("data_model").m_128461_("id");
        List recipes = this.f_58857_.m_7465_().m_44013_((RecipeType)ModelRecipe.Type.INSTANCE);
        DynamicHolder model = DataModelItem.getStoredModel((ItemStack)stack);
        ModelTier tier = ModelTier.getByData((DynamicHolder)model, (int)DataModelItem.getData((ItemStack)stack));
        for (ModelRecipe recipe : recipes) {
            ItemStack modelStack = new ItemStack((ItemLike)Hostile.Items.DATA_MODEL.get());
            EntityType entityCheck = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(recipe.getEntity());
            DataModel modelCheck = DataModelRegistry.INSTANCE.getForEntity(entityCheck);
            if (modelCheck == null) continue;
            DataModelItem.setStoredModel((ItemStack)modelStack, (DataModel)modelCheck);
            String idCheck = modelStack.m_41698_("data_model").m_128461_("id");
            if (!idCheck.equalsIgnoreCase(mobId)) continue;
            return Pair.of(recipe.getBlood()[tier.ordinal()], recipe.getEnergy());
        }
        return Pair.of(0, 0);
    }

    public ItemStack getCatalystStack() {
        return this.itemHandler.getStackInSlot(1);
    }

    public ItemStackHandler getInventory() {
        return this.itemHandler;
    }

    public int getRFTick() {
        return (Integer)this.getModelFromStack((ItemStack)this.getModelStack()).second;
    }

    public void setBloodAltar(BlockPos pos) {
        TileAltar altar = (TileAltar)this.f_58857_.m_7702_(pos);
        this.altarPos = pos;
        this.bloodAltar = altar;
    }
}

