/*
 * Decompiled with CFR 0.152.
 */
package com.leo.sanguine_networks.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.leo.sanguine_networks.init.ModRecipes;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class CatalystRecipe
implements Recipe<Container> {
    private final Ingredient input;
    private final int uses;
    private final float multiplier;
    private final ResourceLocation id;

    public CatalystRecipe(Ingredient input, int uses, float multiplier, ResourceLocation id) {
        this.input = input;
        this.uses = uses;
        this.multiplier = multiplier;
        this.id = id;
    }

    public static Builder create(Ingredient input, int uses, float multiplier) {
        Item item = input.m_43908_()[0].m_41720_();
        ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)item);
        ResourceLocation recipeId = new ResourceLocation("sanguine_networks", "catalyst/" + key.m_135815_());
        return new Builder(input, uses, multiplier, recipeId);
    }

    public Ingredient getInput() {
        return this.input;
    }

    public int getUses() {
        return this.uses;
    }

    public float getMultiplier() {
        return this.multiplier;
    }

    public boolean m_5818_(Container pContainer, Level pLevel) {
        return !pLevel.m_5776_();
    }

    public ItemStack m_5874_(Container pContainer, RegistryAccess pRegistryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.CATALYST_RECIPE_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Builder
    implements RecipeBuilder,
    FinishedRecipe {
        private final Ingredient input;
        private final int uses;
        private final float multiplier;
        private final ResourceLocation id;

        public Builder(Ingredient input, int uses, float multiplier, ResourceLocation id) {
            this.input = input;
            this.uses = uses;
            this.multiplier = multiplier;
            this.id = id;
        }

        public RecipeBuilder m_126132_(String pCriterionName, CriterionTriggerInstance pCriterionTrigger) {
            return this;
        }

        public RecipeBuilder m_126145_(@Nullable String pGroupName) {
            return this;
        }

        @NotNull
        public Item m_142372_() {
            return this.input.m_43908_()[0].m_41720_();
        }

        public void m_126140_(Consumer<FinishedRecipe> finishedRecipeConsumer, ResourceLocation recipeId) {
            finishedRecipeConsumer.accept(this);
        }

        public void m_7917_(JsonObject json) {
            json.add("catalyst", this.input.m_43942_());
            json.addProperty("uses", (Number)this.uses);
            json.addProperty("multiplier", (Number)Float.valueOf(this.multiplier));
        }

        @NotNull
        public ResourceLocation m_6445_() {
            return this.id;
        }

        @NotNull
        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ModRecipes.CATALYST_RECIPE_SERIALIZER.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }

    public static class Type
    implements RecipeType<CatalystRecipe> {
        public static final Type INSTANCE = new Type();
    }

    public static class Serializer
    implements RecipeSerializer<CatalystRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public CatalystRecipe fromJson(ResourceLocation id, JsonObject recipe) {
            Ingredient input = Ingredient.m_43917_((JsonElement)recipe.get("catalyst"));
            int uses = recipe.get("uses").getAsInt();
            float multiplier = recipe.get("multiplier").getAsFloat();
            return new CatalystRecipe(input, uses, multiplier, id);
        }

        @Nullable
        public CatalystRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int uses = buffer.readInt();
            float multiplier = buffer.readFloat();
            return new CatalystRecipe(input, uses, multiplier, id);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, CatalystRecipe pRecipe) {
            pRecipe.input.m_43923_(pBuffer);
            pBuffer.writeInt(pRecipe.uses);
            pBuffer.writeFloat(pRecipe.multiplier);
        }
    }
}

