/*
 * Decompiled with CFR 0.152.
 */
package com.leo.sanguine_networks.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.leo.sanguine_networks.init.ModRecipes;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ModelRecipe
implements Recipe<Container> {
    private final ResourceLocation entity;
    private final int[] blood;
    private final int energy;
    private final ResourceLocation id;

    public ModelRecipe(ResourceLocation entity, int[] blood, int energy, ResourceLocation id) {
        this.entity = entity;
        this.blood = blood;
        this.energy = energy;
        this.id = id;
    }

    public static Builder create(ResourceLocation entity, int[] blood, int energy) {
        ResourceLocation recipeId = new ResourceLocation("sanguine_networks", "blood/" + entity.m_135815_());
        return new Builder(entity, blood, energy, recipeId);
    }

    public ResourceLocation getEntity() {
        return this.entity;
    }

    public int[] getBlood() {
        return this.blood;
    }

    public int getEnergy() {
        return this.energy;
    }

    public boolean m_5818_(Container pContainer, Level pLevel) {
        return !pLevel.m_5776_();
    }

    public ItemStack m_5874_(Container pContainer, RegistryAccess pRegistryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.BLOOD_RECIPE_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Builder
    implements RecipeBuilder,
    FinishedRecipe {
        private final ResourceLocation entity;
        private final int[] blood;
        private final int energy;
        private final ResourceLocation id;

        public Builder(ResourceLocation entity, int[] blood, int energy, ResourceLocation id) {
            this.entity = entity;
            this.blood = blood;
            this.energy = energy;
            this.id = id;
        }

        public RecipeBuilder m_126132_(String pCriterionName, CriterionTriggerInstance pCriterionTrigger) {
            return this;
        }

        public RecipeBuilder m_126145_(@Nullable String pGroupName) {
            return this;
        }

        @NotNull
        public Item m_142372_() {
            return Items.f_41852_;
        }

        public void m_126140_(Consumer<FinishedRecipe> finishedRecipeConsumer, ResourceLocation recipeId) {
            finishedRecipeConsumer.accept(this);
        }

        public void m_7917_(JsonObject json) {
            json.addProperty("entity", this.entity.toString());
            JsonArray array = new JsonArray();
            for (int i : this.blood) {
                array.add((Number)i);
            }
            json.add("blood", (JsonElement)array);
            json.addProperty("energy", (Number)this.energy);
        }

        @NotNull
        public ResourceLocation m_6445_() {
            return this.id;
        }

        @NotNull
        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ModRecipes.BLOOD_RECIPE_SERIALIZER.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }

    public static class Type
    implements RecipeType<ModelRecipe> {
        public static final Type INSTANCE = new Type();
    }

    public static class Serializer
    implements RecipeSerializer<ModelRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public ModelRecipe fromJson(ResourceLocation id, JsonObject recipe) {
            ResourceLocation entity = new ResourceLocation(recipe.get("entity").getAsString());
            int energy = recipe.get("energy").getAsInt();
            List bloodList = recipe.getAsJsonArray("blood").asList();
            int[] blood = new int[bloodList.size()];
            for (int i = 0; i < bloodList.size(); ++i) {
                blood[i] = ((JsonElement)bloodList.get(i)).getAsInt();
            }
            return new ModelRecipe(entity, blood, energy, id);
        }

        @Nullable
        public ModelRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            ResourceLocation entity = buffer.m_130281_();
            int[] blood = buffer.m_130100_();
            int energy = buffer.readInt();
            return new ModelRecipe(entity, blood, energy, id);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, ModelRecipe pRecipe) {
            pBuffer.m_130085_(pRecipe.entity);
            pBuffer.m_130089_(pRecipe.blood);
            pBuffer.writeInt(pRecipe.energy);
        }
    }
}

