/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.data.listener.ResourceValidator;
import slimeknights.tconstruct.common.config.Config;

public class DynamicTextureLoader
extends ResourceValidator {
    private static final Logger log = LogManager.getLogger(DynamicTextureLoader.class);
    private static final DynamicTextureLoader INSTANCE = new DynamicTextureLoader();

    private DynamicTextureLoader() {
        super("textures/item", "textures", ".png");
    }

    public void onReloadSafe(ResourceManager manager) {
        if (!((Boolean)Config.CLIENT.logMissingModifierTextures.get()).booleanValue()) {
            super.onReloadSafe(manager);
        }
    }

    public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        return super.m_5540_(stage, resourceManager, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor).thenRunAsync(() -> ((DynamicTextureLoader)this).clear());
    }

    public static void init(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)INSTANCE);
    }

    public static Predicate<Material> getTextureValidator(Function<Material, TextureAtlasSprite> spriteGetter, boolean logMissingTextures) {
        if (logMissingTextures || DynamicTextureLoader.INSTANCE.resources.isEmpty()) {
            return mat -> !MissingTextureAtlasSprite.m_118071_().equals((Object)((TextureAtlasSprite)spriteGetter.apply((Material)mat)).m_245424_().m_246162_());
        }
        return mat -> {
            ResourceLocation texture;
            if (InventoryMenu.f_39692_.equals((Object)mat.m_119193_()) && (texture = mat.m_119203_()).m_135815_().startsWith("item/")) {
                return INSTANCE.test(mat.m_119203_());
            }
            return !MissingTextureAtlasSprite.m_118071_().equals((Object)((TextureAtlasSprite)spriteGetter.apply((Material)mat)).m_245424_().m_246162_());
        };
    }
}

