/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.json.variable.mining;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.json.math.ModifierFormula;
import slimeknights.tconstruct.library.json.variable.VariableFormula;
import slimeknights.tconstruct.library.json.variable.VariableFormulaLoadable;
import slimeknights.tconstruct.library.json.variable.mining.MiningSpeedVariable;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public record MiningSpeedFormula(ModifierFormula formula, List<MiningSpeedVariable> variables, String[] variableNames, boolean percent) implements VariableFormula<MiningSpeedVariable>
{
    public static final String[] VARIABLES = new String[]{"level", "speed", "multiplier", "original_speed"};
    public static final RecordLoadable<MiningSpeedFormula> LOADER = new VariableFormulaLoadable<MiningSpeedVariable, MiningSpeedFormula>(MiningSpeedVariable.LOADER, VARIABLES, (formula, variables, percent) -> new MiningSpeedFormula((ModifierFormula)formula, (List<MiningSpeedVariable>)variables, EMPTY_STRINGS, (boolean)percent));

    public MiningSpeedFormula(ModifierFormula formula, Map<String, MiningSpeedVariable> variables, boolean percent) {
        this(formula, List.copyOf(variables.values()), VariableFormula.getNames(variables), percent);
    }

    private float[] getArguments(IToolStackView tool, ModifierEntry modifier, @Nullable PlayerEvent.BreakSpeed event, @Nullable Player player, @Nullable Direction sideHit, float baseSpeed, float newSpeed, float multiplier) {
        int size = this.variables.size();
        float[] arguments = VariableFormula.statModuleArguments(size, this.formula.processLevel(modifier), baseSpeed, newSpeed, multiplier * tool.getMultiplier(ToolStats.MINING_SPEED));
        for (int i = 0; i < size; ++i) {
            arguments[4 + i] = this.variables.get(i).getValue(tool, event, player, sideHit);
        }
        return arguments;
    }

    public float apply(IToolStackView tool, ModifierEntry modifier, @Nullable PlayerEvent.BreakSpeed event, @Nullable Player player, @Nullable Direction sideHit, float baseSpeed, float newSpeed, float multiplier) {
        return this.formula.apply(this.getArguments(tool, modifier, event, player, sideHit, baseSpeed, newSpeed, multiplier));
    }
}

