/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.packs.PackType;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import slimeknights.mantle.client.ResourceColorManager;
import slimeknights.mantle.registration.object.IdAwareObject;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.ModifierManager;
import slimeknights.tconstruct.library.modifiers.util.ModifierLevelDisplay;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.utils.Util;

public class Modifier
implements IdAwareObject {
    public static Random RANDOM = new Random();
    public static final int DEFAULT_PRIORITY = 100;
    private ModifierId id;
    @Nullable
    private String translationKey;
    @Nullable
    private Component displayName;
    @Nullable
    protected List<Component> descriptionList;
    @Nullable
    private Component description;
    private final ModuleHookMap hooks;

    protected Modifier(ModuleHookMap hooks) {
        this.hooks = hooks;
    }

    public Modifier() {
        ModuleHookMap.Builder hookBuilder = ModuleHookMap.builder();
        this.registerHooks(hookBuilder);
        this.hooks = hookBuilder.build();
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
    }

    public int getPriority() {
        return 100;
    }

    final void setId(ModifierId name) {
        if (this.id != null) {
            throw new IllegalStateException("Attempted to set registry name with existing registry name! New: " + name + " Old: " + this.id);
        }
        this.id = name;
    }

    public ModifierId getId() {
        return Objects.requireNonNull(this.id, "Modifier has null registry name");
    }

    public final boolean is(TagKey<Modifier> tag) {
        return ModifierManager.isInTag(this.getId(), tag);
    }

    public void clearCache(PackType packType) {
        if (packType == PackType.CLIENT_RESOURCES) {
            this.displayName = null;
        }
    }

    public final TextColor getTextColor() {
        return ResourceColorManager.getTextColor((String)this.getTranslationKey());
    }

    public final int getColor() {
        return this.getTextColor().m_131265_();
    }

    protected String makeTranslationKey() {
        return Util.makeTranslationKey("modifier", Objects.requireNonNull(this.id));
    }

    public final String getTranslationKey() {
        if (this.translationKey == null) {
            this.translationKey = this.makeTranslationKey();
        }
        return this.translationKey;
    }

    protected Component makeDisplayName() {
        return Component.m_237115_((String)this.getTranslationKey());
    }

    public MutableComponent applyStyle(MutableComponent component) {
        return component.m_130938_(style -> style.m_131148_(this.getTextColor()));
    }

    public Component getDisplayName() {
        if (this.displayName == null) {
            this.displayName = Component.m_237115_((String)this.getTranslationKey()).m_130938_(style -> style.m_131148_(this.getTextColor()));
        }
        return this.displayName;
    }

    public Component getDisplayName(int level) {
        return ModifierLevelDisplay.DEFAULT.nameForLevel(this, level);
    }

    public Component getDisplayName(IToolStackView tool, ModifierEntry entry, @Nullable RegistryAccess access) {
        return entry.getDisplayName();
    }

    public List<Component> getDescriptionList() {
        if (this.descriptionList == null) {
            this.descriptionList = Arrays.asList(Component.m_237115_((String)(this.getTranslationKey() + ".flavor")).m_130940_(ChatFormatting.ITALIC), Component.m_237115_((String)(this.getTranslationKey() + ".description")).m_130940_(ChatFormatting.GRAY));
        }
        return this.descriptionList;
    }

    public List<Component> getDescriptionList(int level) {
        return this.getDescriptionList();
    }

    public List<Component> getDescriptionList(IToolStackView tool, ModifierEntry entry) {
        return this.getDescriptionList(entry.getLevel());
    }

    private static Component listToComponent(List<Component> list) {
        if (list.isEmpty()) {
            return Component.m_237119_();
        }
        MutableComponent textComponent = Component.m_237113_((String)"");
        Iterator<Component> iterator = list.iterator();
        textComponent.m_7220_(iterator.next());
        while (iterator.hasNext()) {
            textComponent.m_130946_("\n");
            textComponent.m_7220_(iterator.next());
        }
        return textComponent;
    }

    public final Component getDescription() {
        if (this.description == null) {
            this.description = Modifier.listToComponent(this.getDescriptionList());
        }
        return this.description;
    }

    public final Component getDescription(int level) {
        List<Component> extendedDescription = this.getDescriptionList(level);
        if (extendedDescription == this.getDescriptionList()) {
            return this.getDescription();
        }
        return Modifier.listToComponent(extendedDescription);
    }

    public final Component getDescription(IToolStackView tool, ModifierEntry entry) {
        List<Component> extendedDescription = this.getDescriptionList(tool, entry);
        if (extendedDescription == this.getDescriptionList()) {
            return this.getDescription();
        }
        return Modifier.listToComponent(extendedDescription);
    }

    public boolean shouldDisplay(boolean advanced) {
        return true;
    }

    public final <T> T getHook(ModuleHook<T> hook) {
        return this.hooks.getOrDefault(hook);
    }

    public String toString() {
        return "Modifier{" + this.id + "}";
    }

    @Nullable
    public static ToolStack getHeldTool(@Nullable LivingEntity living, InteractionHand hand) {
        return Modifier.getHeldTool(living, Util.getSlotType(hand));
    }

    @Nullable
    public static ToolStack getHeldTool(@Nullable LivingEntity living, EquipmentSlot slot) {
        if (living == null) {
            return null;
        }
        ItemStack stack = living.m_6844_(slot);
        if (stack.m_41619_() || !stack.m_204117_(TinkerTags.Items.MODIFIABLE)) {
            return null;
        }
        ToolStack tool = ToolStack.from(stack);
        return tool.isBroken() ? null : tool;
    }

    public static float getMiningModifier(LivingEntity entity) {
        MobEffectInstance miningFatigue;
        float modifier = 1.0f;
        if (MobEffectUtil.m_19584_((LivingEntity)entity)) {
            modifier *= 1.0f + (float)(MobEffectUtil.m_19586_((LivingEntity)entity) + 1) * 0.2f;
        }
        if ((miningFatigue = entity.m_21124_(MobEffects.f_19599_)) != null) {
            switch (miningFatigue.m_19564_()) {
                case 0: {
                    modifier *= 0.3f;
                    break;
                }
                case 1: {
                    modifier *= 0.09f;
                    break;
                }
                case 2: {
                    modifier *= 0.0027f;
                    break;
                }
                default: {
                    modifier *= 8.1E-4f;
                }
            }
        }
        if (entity.m_204029_(FluidTags.f_13131_) && !EnchantmentHelper.m_44934_((LivingEntity)entity)) {
            modifier /= 5.0f;
        }
        if (!entity.m_20096_()) {
            modifier /= 5.0f;
        }
        return modifier;
    }

    public ModuleHookMap getHooks() {
        return this.hooks;
    }
}

