/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.entitymelting;

import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.mantle.recipe.helper.FluidOutput;
import slimeknights.mantle.recipe.ingredient.EntityIngredient;
import slimeknights.tconstruct.library.recipe.entitymelting.EntityMeltingRecipe;

public class EntityMeltingRecipeBuilder
extends AbstractRecipeBuilder<EntityMeltingRecipeBuilder> {
    private final EntityIngredient ingredient;
    private final FluidOutput output;
    private final int damage;

    public static EntityMeltingRecipeBuilder melting(EntityIngredient ingredient, FluidStack output, int damage) {
        return EntityMeltingRecipeBuilder.melting(ingredient, FluidOutput.fromStack((FluidStack)output), damage);
    }

    public static EntityMeltingRecipeBuilder melting(EntityIngredient ingredient, FluidOutput output) {
        return EntityMeltingRecipeBuilder.melting(ingredient, output, 2);
    }

    public static EntityMeltingRecipeBuilder melting(EntityIngredient ingredient, FluidStack output) {
        return EntityMeltingRecipeBuilder.melting(ingredient, output, 2);
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        this.save(consumer, BuiltInRegistries.f_257020_.m_7981_((Object)this.output.get().getFluid()));
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        ResourceLocation advancementId = this.buildOptionalAdvancement(id, "entity_melting");
        consumer.accept((FinishedRecipe)new AbstractRecipeBuilder.LoadableFinishedRecipe((AbstractRecipeBuilder)this, (Recipe)new EntityMeltingRecipe(id, this.ingredient, this.output, this.damage), EntityMeltingRecipe.LOADER, advancementId));
    }

    private EntityMeltingRecipeBuilder(EntityIngredient ingredient, FluidOutput output, int damage) {
        this.ingredient = ingredient;
        this.output = output;
        this.damage = damage;
    }

    public static EntityMeltingRecipeBuilder melting(EntityIngredient ingredient, FluidOutput output, int damage) {
        return new EntityMeltingRecipeBuilder(ingredient, output, damage);
    }
}

