/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.capability.fluid;

import java.util.Iterator;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.capability.CompoundIndexHookIterator;
import slimeknights.tconstruct.library.tools.capability.fluid.ToolFluidCapability;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

abstract class FluidModifierHookIterator<I>
extends CompoundIndexHookIterator<ToolFluidCapability.FluidModifierHook, I> {
    protected ModifierEntry indexEntry = null;

    FluidModifierHookIterator() {
    }

    @Override
    protected int getSize(IToolStackView tool, ToolFluidCapability.FluidModifierHook hook) {
        return hook.getTanks(tool.getVolatileData(), this.indexEntry);
    }

    protected int fill(IToolStackView tool, FluidStack resource, IFluidHandler.FluidAction action) {
        int totalFilled = 0;
        Iterator iterator = this.getIterator(tool);
        while (iterator.hasNext()) {
            int filled = ((ToolFluidCapability.FluidModifierHook)this.getHook(iterator.next())).fill(tool, this.indexEntry, resource, action);
            if (filled <= 0) continue;
            if (filled >= resource.getAmount()) {
                return totalFilled + filled;
            }
            if (totalFilled == 0) {
                resource = resource.copy();
            }
            totalFilled += filled;
            resource.shrink(filled);
            if (!resource.isEmpty()) continue;
            break;
        }
        return totalFilled;
    }

    public FluidStack drain(IToolStackView tool, FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack drainedSoFar = FluidStack.EMPTY;
        Iterator iterator = this.getIterator(tool);
        while (iterator.hasNext()) {
            FluidStack drained = ((ToolFluidCapability.FluidModifierHook)this.getHook(iterator.next())).drain(tool, this.indexEntry, resource, action);
            if (drained.isEmpty()) continue;
            if (drainedSoFar.isEmpty()) {
                drainedSoFar = drained;
                if (drained.getAmount() >= resource.getAmount()) break;
                resource = new FluidStack(resource, resource.getAmount() - drained.getAmount());
                continue;
            }
            drainedSoFar.grow(drained.getAmount());
            resource.shrink(drained.getAmount());
            if (!resource.isEmpty()) continue;
            break;
        }
        return drainedSoFar;
    }

    public FluidStack drain(IToolStackView tool, int maxDrain, IFluidHandler.FluidAction action) {
        FluidStack drainedSoFar = FluidStack.EMPTY;
        FluidStack toDrain = FluidStack.EMPTY;
        Iterator iterator = this.getIterator(tool);
        while (iterator.hasNext()) {
            FluidStack drained;
            ToolFluidCapability.FluidModifierHook hook = (ToolFluidCapability.FluidModifierHook)this.getHook(iterator.next());
            if (toDrain.isEmpty()) {
                drained = hook.drain(tool, this.indexEntry, maxDrain, action);
                if (drained.isEmpty()) continue;
                drainedSoFar = drained;
                if (drained.getAmount() >= maxDrain) break;
                toDrain = new FluidStack(drained, maxDrain - drained.getAmount());
                continue;
            }
            drained = hook.drain(tool, this.indexEntry, toDrain, action);
            if (drained.isEmpty()) continue;
            drainedSoFar.grow(drained.getAmount());
            toDrain.shrink(drained.getAmount());
            if (!toDrain.isEmpty()) continue;
            break;
        }
        return drainedSoFar;
    }
}

