/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.thermal_extra.block.entity;

import cofh.core.util.helpers.FluidHelper;
import cofh.lib.api.StorageGroup;
import cofh.lib.common.fluid.FluidStorageCoFH;
import cofh.thermal.core.common.config.ThermalCoreConfig;
import cofh.thermal.lib.common.block.entity.MachineBlockEntity;
import cofh.thermal.lib.util.recipes.IMachineInventory;
import cofh.thermal.lib.util.recipes.IThermalInventory;
import javax.annotation.Nullable;
import mrthomas20121.thermal_extra.init.ThermalExtraBlockEntities;
import mrthomas20121.thermal_extra.inventory.machine.MachineFluidMixerMenu;
import mrthomas20121.thermal_extra.recipe.FluidMixerRecipeManager;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;

public class MachineFluidMixerBlockEntity
extends MachineBlockEntity {
    protected FluidStorageCoFH inputTank1 = new FluidStorageCoFH(8000, fluid -> this.filter.valid(fluid) && FluidMixerRecipeManager.instance().validFluid((FluidStack)fluid));
    protected FluidStorageCoFH inputTank2 = new FluidStorageCoFH(8000, fluid -> this.filter.valid(fluid) && FluidMixerRecipeManager.instance().validRightFluid((FluidStack)fluid));
    protected FluidStorageCoFH outputTankA = new FluidStorageCoFH(8000);
    protected FluidStorageCoFH outputTankB = new FluidStorageCoFH(8000);

    public MachineFluidMixerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ThermalExtraBlockEntities.FLUID_MIXER.get(), pos, state);
        this.inventory.addSlot(this.chargeSlot, StorageGroup.INTERNAL);
        this.tankInv.addTank(this.inputTank1, StorageGroup.INPUT);
        this.tankInv.addTank(this.inputTank2, StorageGroup.INPUT);
        this.tankInv.addTank(this.outputTankA, StorageGroup.OUTPUT);
        this.tankInv.addTank(this.outputTankB, StorageGroup.OUTPUT);
        this.renderFluid = new FluidStack((Fluid)Fluids.f_76193_, 1000);
        this.addAugmentSlots(ThermalCoreConfig.machineAugments);
        this.initHandlers();
    }

    protected int getBaseProcessTick() {
        return FluidMixerRecipeManager.instance().getBasePower();
    }

    protected boolean cacheRecipe() {
        this.curRecipe = FluidMixerRecipeManager.instance().getRecipe((IThermalInventory)this);
        if (this.curRecipe != null) {
            this.fluidInputCounts = this.curRecipe.getInputFluidCounts((IMachineInventory)this);
        }
        return this.curRecipe != null;
    }

    protected boolean cacheRenderFluid() {
        if (this.curRecipe == null) {
            return false;
        }
        if (this.inputTank1.isEmpty()) {
            return false;
        }
        FluidStack prevFluid = this.renderFluid;
        this.renderFluid = new FluidStack(this.inputTank1.getFluidStack(), 1000);
        return !FluidHelper.fluidsEqual((FluidStack)this.renderFluid, (FluidStack)prevFluid);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new MachineFluidMixerMenu(i, this.f_58857_, this.f_58858_, inventory, player);
    }

    protected boolean validateInputs() {
        if (!this.cacheRecipe()) {
            return false;
        }
        return this.inputTank1.getAmount() >= (Integer)this.fluidInputCounts.get(0) && this.inputTank2.getAmount() >= (Integer)this.fluidInputCounts.get(1);
    }
}

