/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.alltheleaks.leaks.common.mods.forge;

import com.mojang.datafixers.util.Pair;
import cpw.mods.cl.JarModuleFinder;
import cpw.mods.cl.ModuleClassLoader;
import cpw.mods.jarhandling.SecureJar;
import cpw.mods.jarhandling.impl.Jar;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.ModuleLayerHandler;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import cpw.mods.niofs.union.UnionFileSystem;
import cpw.mods.niofs.union.UnionFileSystemProvider;
import dev.uncandango.alltheleaks.AllTheLeaks;
import dev.uncandango.alltheleaks.annotation.Issue;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.nio.file.ClosedFileSystemException;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.system.MemoryUtil;
import sun.misc.Unsafe;

@Issue(modId="forge", versionRange="*", description="Memory leak on FML")
public class UntrackedIssue004 {
    public UntrackedIssue004() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::closeDanglingJars);
    }

    private void closeDanglingJars(FMLLoadCompleteEvent event) {
        event.enqueueWork(() -> {
            HashMap copyFileSystems = new HashMap();
            HashSet validFS = new HashSet();
            try {
                Unsafe UNSAFE = FMLEnvironment.dist.isClient() ? (Unsafe)ObfuscationReflectionHelper.getPrivateValue(MemoryUtil.class, null, (String)"UNSAFE") : (Unsafe)ObfuscationReflectionHelper.getPrivateValue(Unsafe.class, null, (String)"theUnsafe");
                if (UNSAFE == null) {
                    throw new IllegalAccessException("Not possible to grab UNSAFE");
                }
                Field fieldImplLookup = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
                MethodHandles.Lookup LOOKUP = (MethodHandles.Lookup)UNSAFE.getObject(UNSAFE.staticFieldBase(fieldImplLookup), UNSAFE.staticFieldOffset(fieldImplLookup));
                VarHandle fsVH = LOOKUP.findVarHandle(Jar.class, "filesystem", UnionFileSystem.class);
                VarHandle layersVH = LOOKUP.findVarHandle(ModuleLayerHandler.class, "completedLayers", EnumMap.class);
                Class layerInfo = Arrays.stream(ModuleLayerHandler.class.getNestMembers()).filter(clazz -> clazz.getName().contains("LayerInfo")).findFirst().orElseThrow();
                VarHandle clVH = LOOKUP.findVarHandle(layerInfo, "cl", ModuleClassLoader.class);
                VarHandle rootsVH = LOOKUP.findVarHandle(ModuleClassLoader.class, "resolvedRoots", Map.class);
                Class jmr = Arrays.stream(JarModuleFinder.class.getNestMembers()).filter(clazz -> clazz.getName().contains("JarModuleReference")).findFirst().orElseThrow();
                VarHandle jarVH = LOOKUP.findVarHandle(jmr, "jar", SecureJar.ModuleDataProvider.class);
                Class jmdp = Arrays.stream(Jar.class.getNestMembers()).filter(clazz -> clazz.getName().contains("JarModuleDataProvider")).findFirst().orElseThrow();
                VarHandle jar2VH = LOOKUP.findVarHandle(jmdp, "jar", Jar.class);
                VarHandle ufspVH = LOOKUP.findStaticVarHandle(Jar.class, "UFSP", UnionFileSystemProvider.class);
                UnionFileSystemProvider UFSP = ufspVH.get();
                Map fileSystems = LOOKUP.findVarHandle(UnionFileSystemProvider.class, "fileSystems", Map.class).get(UFSP);
                copyFileSystems.putAll(fileSystems);
                ModList.get().getModFiles().stream().map(modFile -> fsVH.get(modFile.getFile().getSecureJar())).forEach(validFS::add);
                IModuleLayerManager layerManager = (IModuleLayerManager)Launcher.INSTANCE.environment().findModuleLayerManager().orElseThrow();
                EnumMap map = layersVH.get(layerManager);
                for (IModuleLayerManager.Layer layer : IModuleLayerManager.Layer.values()) {
                    Optional.ofNullable(map.get(layer)).ifPresent(info -> {
                        ModuleClassLoader cl = clVH.get(info);
                        Map roots = rootsVH.get(cl);
                        roots.values().forEach(reference -> {
                            SecureJar.ModuleDataProvider provider = jarVH.get(reference);
                            if (jmdp.isAssignableFrom(provider.getClass())) {
                                Jar jar = jar2VH.get(provider);
                                validFS.add(fsVH.get(jar));
                            } else {
                                try {
                                    Field field = provider.getClass().getDeclaredField("provider");
                                    field.setAccessible(true);
                                    Object jmdpValue = field.get(provider);
                                    Jar jar = jar2VH.get(jmdpValue);
                                    validFS.add(fsVH.get(jar));
                                }
                                catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                                    // empty catch block
                                }
                            }
                        });
                    });
                }
            }
            catch (Throwable e) {
                AllTheLeaks.LOGGER.error("Failed to clear dangling mod jars", e);
                return;
            }
            Pattern MATCH_PATTERN = Pattern.compile("(.*)#(\\d+)");
            HashMap<String, Pair> tempMap = new HashMap<String, Pair>();
            for (Map.Entry entry : copyFileSystems.entrySet()) {
                Integer newIndex;
                String newkey;
                Pair oldVal;
                String key = (String)entry.getKey();
                if (StringUtils.countMatches((CharSequence)key, (char)'#') > 1) continue;
                UnionFileSystem value = (UnionFileSystem)entry.getValue();
                Matcher match = MATCH_PATTERN.matcher(key);
                if (!match.find() || (oldVal = tempMap.put(newkey = match.group(1), Pair.of((Object)(newIndex = Integer.valueOf(match.group(2))), (Object)value))) == null) continue;
                if ((Integer)oldVal.getFirst() < newIndex) {
                    try {
                        if (validFS.contains(oldVal.getSecond())) {
                            AllTheLeaks.LOGGER.debug("Tried to release a valid jar {}#{}, skipping...", (Object)newkey, oldVal.getFirst());
                            AllTheLeaks.LOGGER.debug("Will try {}", (Object)newIndex);
                            if (validFS.contains(value)) continue;
                            AllTheLeaks.LOGGER.debug("Releasing leaked jar: {}#{}", (Object)newkey, (Object)newIndex);
                            value.close();
                            continue;
                        }
                        AllTheLeaks.LOGGER.debug("Releasing leaked jar: {}#{}", (Object)newkey, oldVal.getFirst());
                        ((UnionFileSystem)oldVal.getSecond()).close();
                    }
                    catch (ClosedFileSystemException e) {
                        AllTheLeaks.LOGGER.error("Failed to close leaked jar.", (Throwable)e);
                    }
                    continue;
                }
                try {
                    if (validFS.contains(value)) {
                        AllTheLeaks.LOGGER.debug("Tried to release a valid jar {}#{}, skipping...", (Object)newkey, (Object)newIndex);
                        AllTheLeaks.LOGGER.debug("Will try {}", oldVal.getFirst());
                        if (validFS.contains(oldVal.getSecond())) continue;
                        AllTheLeaks.LOGGER.debug("Releasing leaked jar: {}#{}", (Object)newkey, oldVal.getFirst());
                        ((UnionFileSystem)oldVal.getSecond()).close();
                        continue;
                    }
                    AllTheLeaks.LOGGER.debug("Releasing leaked jar: {}#{}", (Object)newkey, (Object)newIndex);
                    value.close();
                }
                catch (ClosedFileSystemException e) {
                    AllTheLeaks.LOGGER.error("Failed to close leaked jar.", (Throwable)e);
                }
            }
        });
    }
}

