/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.impl;

import com.apple.library.coregraphics.CGGraphicsState;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIFont;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import moe.plushie.armourers_workshop.compatibility.extensions.com.mojang.blaze3d.systems.RenderSystem.Fix18;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.client.gui.Font.MatrixSupport;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import moe.plushie.armourers_workshop.utils.RectangleTesselator;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public interface GraphicsContextImpl {
    public CGGraphicsState state();

    default public void drawText(NSString text, float x, float y, int textColor) {
        this.drawText(Collections.singleton(text), x, y, textColor, false, null, 0.0f);
    }

    default public void drawText(NSString text, float x, float y, int textColor, @Nullable UIFont font) {
        this.drawText(Collections.singleton(text), x, y, textColor, false, font, 0.0f);
    }

    default public void drawText(NSString text, float x, float y, int textColor, boolean shadow, @Nullable UIFont font, float zLevel) {
        this.drawText(Collections.singleton(text), x, y, textColor, shadow, font, 0.0f);
    }

    default public void drawText(Collection<NSString> lines, float x, float y, int textColor, boolean shadow, @Nullable UIFont font, float zLevel) {
        PoseStack poseStack = this.state().ctm();
        if (font == null) {
            font = this.state().font();
        }
        float scale = font.fontSize() / 9.0f;
        poseStack.m_85836_();
        poseStack.m_252880_(x, y, zLevel);
        poseStack.m_85841_(scale, scale, scale);
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        MultiBufferSource.BufferSource buffers = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        Font renderer = font.impl();
        int dx = 0;
        int dy = 0;
        for (NSString line : lines) {
            int qx = MatrixSupport.drawInBatch(renderer, line.chars(), dx, dy, textColor, shadow, pose, (MultiBufferSource)buffers, false, 0, 0xF000F0);
            if (qx == dx) {
                dy += 7;
                continue;
            }
            dy += 10;
        }
        buffers.m_109911_();
        poseStack.m_85849_();
        RenderSystem.disableBlend();
        Fix18.enableAlphaTest(RenderSystem.class);
        RenderSystem.defaultBlendFunc();
    }

    default public void drawMultilineText(NSString text, float x, float y, float maxWidth, int textColor, @Nullable UIFont font) {
        this.drawMultilineText(Collections.singleton(text), x, y, maxWidth, textColor, false, font, 0.0f);
    }

    default public void drawMultilineText(NSString text, float x, float y, float maxWidth, int textColor, boolean shadow, @Nullable UIFont font, float zLevel) {
        this.drawMultilineText(Collections.singleton(text), x, y, maxWidth, textColor, shadow, font, zLevel);
    }

    default public void drawMultilineText(Collection<NSString> lines, float x, float y, float maxWidth, int textColor, boolean shadow, @Nullable UIFont font, float zLevel) {
        if (font == null) {
            font = this.state().font();
        }
        float scale = font.fontSize() / 9.0f;
        ArrayList<NSString> wrappedTextLines = new ArrayList<NSString>();
        for (NSString line : lines) {
            wrappedTextLines.addAll(line.split(maxWidth / scale, font));
        }
        this.drawText(wrappedTextLines, x, y, textColor, shadow, font, zLevel);
    }

    default public void drawImage(ResourceLocation texture, float x, float y, float width, float height, float u, float v, float texWidth, float texHeight) {
        this.drawResizableImage(texture, x, y, width, height, u, v, width, height, texWidth, texHeight, 0.0f);
    }

    default public void drawImage(ResourceLocation texture, float x, float y, float width, float height, float u, float v, float texWidth, float texHeight, float zLevel) {
        this.drawResizableImage(texture, x, y, width, height, u, v, width, height, texWidth, texHeight, zLevel);
    }

    default public void drawResizableImage(ResourceLocation rl, float x, float y, float width, float height, float u, float v, float sourceWidth, float sourceHeight, float texWidth, float texHeight) {
        this.drawResizableImage(rl, x, y, width, height, u, v, sourceWidth, sourceHeight, texWidth, texHeight, 0.0f);
    }

    default public void drawResizableImage(ResourceLocation rl, float x, float y, float width, float height, float u, float v, float sourceWidth, float sourceHeight, float texWidth, float texHeight, float zLevel) {
        RectangleTesselator tesselator = new RectangleTesselator(this.state());
        tesselator.begin(SkinRenderType.GUI_IMAGE, rl, texWidth, texHeight);
        tesselator.blit(x, y, width, height, u, v, sourceWidth, sourceHeight, zLevel);
        tesselator.end();
    }

    default public void drawTilableImage(ResourceLocation rl, float x, float y, float width, float height, float u, float v, float sourceWidth, float sourceHeight, float topBorder, float bottomBorder, float leftBorder, float rightBorder) {
        this.drawTilableImage(rl, x, y, width, height, u, v, sourceWidth, sourceHeight, 256.0f, 256.0f, topBorder, bottomBorder, leftBorder, rightBorder, 0.0f);
    }

    default public void drawTilableImage(ResourceLocation rl, float x, float y, float width, float height, float u, float v, float sourceWidth, float sourceHeight, float topBorder, float bottomBorder, float leftBorder, float rightBorder, float zLevel) {
        this.drawTilableImage(rl, x, y, width, height, u, v, sourceWidth, sourceHeight, 256.0f, 256.0f, topBorder, bottomBorder, leftBorder, rightBorder, zLevel);
    }

    default public void drawTilableImage(ResourceLocation rl, float x, float y, float width, float height, float u, float v, float sourceWidth, float sourceHeight, float texWidth, float texHeight, float topBorder, float bottomBorder, float leftBorder, float rightBorder, float zLevel) {
        RectangleTesselator tesselator = new RectangleTesselator(this.state());
        tesselator.begin(SkinRenderType.GUI_IMAGE, rl, texWidth, texHeight);
        float x0 = x + 0.0f;
        float y0 = y + 0.0f;
        float x3 = x0 + width;
        float y3 = y0 + height;
        float x1 = x0 + leftBorder;
        float y1 = y0 + topBorder;
        float x2 = x3 - rightBorder;
        float y2 = y3 - bottomBorder;
        float u0 = u + 0.0f;
        float v0 = v + 0.0f;
        float u3 = u0 + sourceWidth;
        float v3 = v0 + sourceHeight;
        float u1 = u0 + leftBorder;
        float v1 = v0 + topBorder;
        float u2 = u3 - rightBorder;
        float v2 = v3 - bottomBorder;
        tesselator.blit(x0, y0, x1 - x0, y1 - y0, u0, v0, zLevel);
        tesselator.blit(x2, y0, x3 - x2, y1 - y0, u2, v0, zLevel);
        tesselator.blit(x0, y2, x1 - x0, y3 - y2, u0, v2, zLevel);
        tesselator.blit(x2, y2, x3 - x2, y3 - y2, u2, v2, zLevel);
        tesselator.tile(x1, y0, x2 - x1, y1 - y0, u1, v0, u2 - u1, v1 - v0, zLevel);
        tesselator.tile(x1, y2, x2 - x1, y3 - y2, u1, v2, u2 - u1, v3 - v2, zLevel);
        tesselator.tile(x0, y1, x1 - x0, y2 - y1, u0, v1, u1 - u0, v2 - v1, zLevel);
        tesselator.tile(x2, y1, x3 - x2, y2 - y1, u2, v1, u3 - u2, v2 - v1, zLevel);
        tesselator.tile(x1, y1, x2 - x1, y2 - y1, u1, v1, u2 - u1, v2 - v1, zLevel);
        tesselator.end();
    }

    default public void drawColor(float minX, float minY, float maxX, float maxY, float zLevel, int color1, int color2) {
        int a1 = color1 >> 24 & 0xFF;
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        CGGraphicsState state = this.state();
        Matrix4f pose = state.ctm().m_85850_().m_252922_();
        VertexConsumer buffer = state.buffers().m_6299_(SkinRenderType.GUI_COLOR);
        buffer.m_252986_(pose, minX, minY, zLevel).m_6122_(r1, g1, b1, a1).m_5752_();
        buffer.m_252986_(pose, minX, maxY, zLevel).m_6122_(r2, g2, b2, a2).m_5752_();
        buffer.m_252986_(pose, maxX, maxY, zLevel).m_6122_(r2, g2, b2, a2).m_5752_();
        buffer.m_252986_(pose, maxX, minY, zLevel).m_6122_(r1, g1, b1, a1).m_5752_();
        state.flush();
    }

    default public void drawBorder(float minX, float minY, float maxX, float maxY, float zLevel, float height, int color) {
        int a1 = color >> 24 & 0xFF;
        int r1 = color >> 16 & 0xFF;
        int g1 = color >> 8 & 0xFF;
        int b1 = color & 0xFF;
        CGGraphicsState state = this.state();
        Matrix4f pose = state.ctm().m_85850_().m_252922_();
        VertexConsumer buffer = state.buffers().m_6299_(SkinRenderType.lineStrip());
        buffer.m_252986_(pose, minX, minY, zLevel).m_6122_(r1, g1, b1, a1).m_5752_();
        buffer.m_252986_(pose, minX, maxY, zLevel).m_6122_(r1, g1, b1, a1).m_5752_();
        buffer.m_252986_(pose, maxX, maxY, zLevel).m_6122_(r1, g1, b1, a1).m_5752_();
        buffer.m_252986_(pose, maxX, minY, zLevel).m_6122_(r1, g1, b1, a1).m_5752_();
        buffer.m_252986_(pose, minX, minY, zLevel).m_6122_(r1, g1, b1, a1).m_5752_();
        state.flush();
    }
}

