/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.impl;

import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSTextPosition;
import com.apple.library.impl.KeyboardManagerImpl;
import com.apple.library.impl.TextStorageImpl;
import java.util.function.Predicate;

public class TextInputImpl {
    public Predicate<String> returnHandler;
    private boolean isEditable = true;
    private CGRect lastUserCursorRect;
    private final TextStorageImpl storage;

    public TextInputImpl(TextStorageImpl storage) {
        this.storage = storage;
    }

    public boolean mouseDown(CGPoint point) {
        float ty;
        float tx = Math.max(point.x - this.storage.offset.x, 0.0f);
        NSTextPosition pos = this.storage.positionAtPoint(new CGPoint(tx, ty = Math.max(point.y - this.storage.offset.y, 0.0f)));
        if (pos != null) {
            this.storage.moveCursorTo(pos, KeyboardManagerImpl.hasShiftDown());
        }
        return false;
    }

    public boolean keyDown(int key) {
        boolean hasShiftDown = KeyboardManagerImpl.hasShiftDown();
        boolean hasControlDown = KeyboardManagerImpl.hasControlDown();
        CGRect userCursorRect = this.lastUserCursorRect;
        this.lastUserCursorRect = null;
        if (KeyboardManagerImpl.isSelectAll(key)) {
            this.storage.setCursorAndHighlightPos(this.storage.endOfDocument(), this.storage.beginOfDocument());
            return true;
        }
        if (KeyboardManagerImpl.isCut(key)) {
            KeyboardManagerImpl.setClipboard(this.storage.highlightedText());
            if (this.isEditable) {
                this.storage.insertText("");
            }
            return true;
        }
        if (KeyboardManagerImpl.isCopy(key)) {
            KeyboardManagerImpl.setClipboard(this.storage.highlightedText());
            return true;
        }
        if (KeyboardManagerImpl.isPaste(key)) {
            if (this.isEditable) {
                this.storage.insertText(KeyboardManagerImpl.getClipboard());
            }
            return true;
        }
        switch (key) {
            case 259: {
                if (this.isEditable) {
                    if (hasControlDown) {
                        this.storage.deleteText(TextStorageImpl.TextTokenizer.WORLD_BEFORE, 1);
                    } else {
                        this.storage.deleteText(TextStorageImpl.TextTokenizer.CHAR_BEFORE, 1);
                    }
                }
                return true;
            }
            case 261: {
                if (this.isEditable) {
                    if (hasControlDown) {
                        this.storage.deleteText(TextStorageImpl.TextTokenizer.WORLD_AFTER, 1);
                    } else {
                        this.storage.deleteText(TextStorageImpl.TextTokenizer.CHAR_AFTER, 1);
                    }
                }
                return true;
            }
            case 260: 
            case 266: 
            case 267: {
                return false;
            }
            case 264: {
                if (this.storage.isMultipleLineMode()) {
                    this.moveToNextLine(userCursorRect, 1, hasShiftDown);
                }
                return false;
            }
            case 265: {
                if (this.storage.isMultipleLineMode()) {
                    this.moveToNextLine(userCursorRect, -1, hasShiftDown);
                }
                return false;
            }
            case 262: {
                if (hasControlDown) {
                    this.storage.moveCursorTo(TextStorageImpl.TextTokenizer.WORLD_AFTER, 1, hasShiftDown);
                } else {
                    this.storage.moveCursorTo(TextStorageImpl.TextTokenizer.CHAR_AFTER, 1, hasShiftDown);
                }
                return true;
            }
            case 263: {
                if (hasControlDown) {
                    this.storage.moveCursorTo(TextStorageImpl.TextTokenizer.WORLD_BEFORE, 1, hasShiftDown);
                } else {
                    this.storage.moveCursorTo(TextStorageImpl.TextTokenizer.CHAR_BEFORE, 1, hasShiftDown);
                }
                return true;
            }
            case 268: {
                this.storage.moveCursorTo(this.storage.beginOfDocument(), hasShiftDown);
                return true;
            }
            case 269: {
                this.storage.moveCursorTo(this.storage.endOfDocument(), hasShiftDown);
                return true;
            }
            case 257: {
                if (this.storage.isMultipleLineMode()) {
                    this.storage.insertText("\n");
                    return true;
                }
                return this.returnHandler != null && this.returnHandler.test(this.storage.value());
            }
        }
        return false;
    }

    public boolean charTyped(char ch) {
        if (this.storage.isAllowedChatCharacter(ch)) {
            this.storage.insertText(Character.toString(ch));
            return true;
        }
        return false;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean editable) {
        this.isEditable = editable;
    }

    private void moveToNextLine(CGRect userCursorRect, int step, boolean selectMode) {
        CGRect rect = this.storage.cursorRect();
        if (userCursorRect == null) {
            userCursorRect = rect;
        }
        if (rect == null) {
            return;
        }
        this.lastUserCursorRect = userCursorRect;
        NSTextPosition pos = this.storage.beginOfDocument();
        float ty = rect.getMidY() + rect.height * (float)step;
        if (ty >= 0.0f) {
            pos = this.storage.positionAtPoint(new CGPoint(userCursorRect.x, ty));
        }
        if (pos != null) {
            this.storage.moveCursorTo(pos, selectMode);
        }
    }
}

