/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.uikit;

import com.apple.library.coregraphics.CGAffineTransform;
import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.impl.InvokerResult;
import com.apple.library.impl.LBSIterator;
import com.apple.library.impl.ObjectUtilsImpl;
import com.apple.library.impl.WeakDispatcherImpl;
import com.apple.library.impl.WindowDispatcherImpl;
import com.apple.library.quartzcore.CATransaction;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UIEvent;
import com.apple.library.uikit.UIPresentationDelegate;
import com.apple.library.uikit.UIResponder;
import com.apple.library.uikit.UIScreen;
import com.apple.library.uikit.UIView;
import com.apple.library.uikit.UIWindowManager;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.Nullable;

public class UIWindow
extends UIView {
    private int level = 0;
    private UIView firstResponder;
    private UIView hoveredResponder;
    private UIView firstInputResponder;
    private UIView focusedResponder;
    private final HashMap<UIControl.Event, WeakDispatcherImpl<UIEvent>> dispatchers = new HashMap();
    private WeakReference<UIWindowManager> windowManager;

    public UIWindow(CGRect frame) {
        super(frame);
    }

    public void init() {
    }

    public void deinit() {
        if (this.firstInputResponder != null) {
            this.firstInputResponder.resignFirstResponder();
            this.firstInputResponder = null;
        }
        this._removeAllSubviews(this);
    }

    @Override
    public void mouseDown(UIEvent event) {
        event.cancel(InvokerResult.FAIL);
    }

    @Override
    public void mouseUp(UIEvent event) {
        event.cancel(InvokerResult.FAIL);
    }

    @Override
    public void mouseDragged(UIEvent event) {
        event.cancel(InvokerResult.FAIL);
    }

    @Override
    public void mouseMoved(UIEvent event) {
        event.cancel(InvokerResult.FAIL);
    }

    @Override
    public void mouseExited(UIEvent event) {
        event.cancel(InvokerResult.FAIL);
    }

    @Override
    public void mouseEntered(UIEvent event) {
        event.cancel(InvokerResult.FAIL);
    }

    @Override
    public void keyUp(UIEvent event) {
        event.cancel(InvokerResult.FAIL);
    }

    @Override
    public void keyDown(UIEvent event) {
        event.cancel(InvokerResult.FAIL);
    }

    public void screenWillTick() {
    }

    public void screenWillResize(CGSize size) {
        this.setCenter(new CGPoint(size.width / 2.0f, size.height / 2.0f));
    }

    public int level() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public <T> void addGlobalTarget(T target, UIControl.Event event, BiConsumer<T, UIEvent> consumer) {
        this._dispatcher(event).add(target, consumer);
    }

    public <T> void removeGlobalTarget(T target, UIControl.Event event) {
        UIWindowManager windowManager;
        this._dispatcher(event).remove(target);
        if (event == UIControl.Event.MOUSE_MOVED && (windowManager = this.getWindowManager()) != null) {
            windowManager._setNeedsUpdateFocus();
        }
    }

    public UIView firstResponder() {
        return this.firstResponder;
    }

    public UIView firstInputResponder() {
        return this.firstInputResponder;
    }

    public UIView firstTooltipResponder() {
        for (UIView view = this.hoveredResponder; view != null; view = view.superview()) {
            if (view.tooltip() == null) continue;
            return view;
        }
        return null;
    }

    protected void setFirstInputResponder(UIView view) {
        this.firstInputResponder = view;
        this._setFocusedResponder(view);
    }

    public UIWindowManager getWindowManager() {
        if (this.windowManager != null) {
            return (UIWindowManager)this.windowManager.get();
        }
        return null;
    }

    protected void setWindowManager(UIWindowManager manager) {
        this.windowManager = new WeakReference<UIWindowManager>(manager);
    }

    protected boolean shouldPassEventToNextWindow(UIEvent event) {
        return true;
    }

    protected void _didRemoveFromWindow(UIView view) {
        if (this.firstResponder == view) {
            this.firstResponder = null;
        }
        if (this.focusedResponder == view) {
            this._setFocusedResponder(null);
        }
        if (this.firstInputResponder == view) {
            this.firstInputResponder = null;
        }
        if (this.hoveredResponder == view) {
            this._setHoveredResponder(null, Dispatcher.NULL_EVENT);
        }
    }

    private void _removeAllSubviews(UIView view) {
        while (!view.subviews().isEmpty()) {
            UIView subview = view.subviews().get(0);
            subview.removeFromSuperview();
            this._removeAllSubviews(subview);
        }
    }

    private boolean _sendGlobalEvent(UIControl.Event event, UIEvent event1) {
        this._dispatcher(event).send(event1);
        return !event1.isCancelled();
    }

    private WeakDispatcherImpl<UIEvent> _dispatcher(UIControl.Event event) {
        return this.dispatchers.computeIfAbsent(event, k -> new WeakDispatcherImpl());
    }

    private void _setFocusedResponder(UIView view) {
        if (this.focusedResponder == view) {
            return;
        }
        if (this.focusedResponder != null) {
            Dispatcher.applyFocusedView(this.focusedResponder, false);
        }
        this.focusedResponder = view;
        if (this.focusedResponder != null) {
            Dispatcher.applyFocusedView(this.focusedResponder, true);
        }
    }

    private void _setInputResponder(UIView view) {
        if (this.firstInputResponder == view) {
            return;
        }
        if (this.firstInputResponder != null) {
            this.firstInputResponder.resignFirstResponder();
        }
        this.firstInputResponder = view;
        if (this.firstInputResponder != null) {
            this.firstInputResponder.becomeFirstResponder();
        }
    }

    private void _setHoveredResponder(UIView view, UIEvent event) {
        if (this.hoveredResponder == view) {
            return;
        }
        if (this.hoveredResponder != null) {
            Dispatcher.applyMouseHovered(this.hoveredResponder, false, event);
        }
        this.hoveredResponder = view;
        if (this.hoveredResponder != null) {
            Dispatcher.applyMouseHovered(this.hoveredResponder, true, event);
        }
    }

    public static class Dispatcher
    extends WindowDispatcherImpl {
        private static final UIEvent.Type[] MOUSE_BUTTONS = new UIEvent.Type[]{UIEvent.Type.MOUSE_LEFT_DOWN, UIEvent.Type.MOUSE_RIGHT_DOWN, UIEvent.Type.MOUSE_MIDDLE_DOWN, UIEvent.Type.MOUSE_LEFT_UP, UIEvent.Type.MOUSE_RIGHT_UP, UIEvent.Type.MOUSE_MIDDLE_UP};
        public static final UIEvent NULL_EVENT = new UIEvent(UIEvent.Type.MOUSE_MOVED, 0, 0, 0.0, CGPoint.ZERO);
        public final UIWindow window;

        public Dispatcher(UIWindow window) {
            this.window = window;
        }

        @Override
        public void init() {
            this.window.init();
        }

        @Override
        public void deinit() {
            this.window.deinit();
        }

        @Override
        public void tick() {
            if (this.window._flags.isDirty) {
                this.window.layoutIfNeeded();
            }
        }

        @Override
        public void layout(CGSize size) {
            this.window.screenWillResize(size);
            this.window.layoutIfNeeded();
        }

        @Override
        public void render(CGGraphicsContext context) {
            int level = this.window.level();
            if (level != 0) {
                context.saveGraphicsState();
                context.translateCTM(0.0f, 0.0f, level);
            }
            float mouseX = context.state().mousePos().getX();
            float mouseY = context.state().mousePos().getY();
            Dispatcher.applyAnimationPre();
            Dispatcher.applyRender(mouseX, mouseY, 0, this.window, context);
            if (level != 0) {
                context.restoreGraphicsState();
            }
        }

        @Override
        public InvokerResult keyUp(int key, int keyModifier, int j) {
            UIEvent event = this.makeKeyEvent(key, keyModifier, UIEvent.Type.KEY_UP);
            if (!this.window._sendGlobalEvent(UIControl.Event.of(event), event)) {
                return this.checkEvent(event);
            }
            return this.applyKeyEvent(event, UIResponder::keyUp);
        }

        @Override
        public InvokerResult keyDown(int key, int keyModifier, int j) {
            UIEvent event = this.makeKeyEvent(key, keyModifier, UIEvent.Type.KEY_DOWN);
            if (!this.window._sendGlobalEvent(UIControl.Event.of(event), event)) {
                return this.checkEvent(event);
            }
            return this.applyKeyEvent(event, UIResponder::keyDown);
        }

        @Override
        public InvokerResult charTyped(int ch, int keyModifier, int j) {
            UIEvent event = this.makeKeyEvent(ch, keyModifier, UIEvent.Type.CHAR_TYPED);
            if (!this.window._sendGlobalEvent(UIControl.Event.of(event), event)) {
                return this.checkEvent(event);
            }
            return this.applyKeyEvent(event, UIResponder::charTyped);
        }

        @Override
        public InvokerResult mouseDown(double mouseX, double mouseY, int button) {
            UIEvent event = this.makeMouseEvent(mouseX, mouseY, button, 0.0, MOUSE_BUTTONS[button % 3]);
            if (!this.window._sendGlobalEvent(UIControl.Event.of(event), event)) {
                return this.checkEvent(event);
            }
            this.window.firstResponder = Dispatcher.findFirstResponder((float)mouseX, (float)mouseY, event, this.window);
            if (this.window.focusedResponder != this.window.firstResponder) {
                this.window._setFocusedResponder(null);
            }
            if (this.window.firstInputResponder != this.window.firstResponder) {
                if (this.window.firstInputResponder != null) {
                    this.window.firstInputResponder.resignFirstResponder();
                }
                this.window.firstInputResponder = this.window.firstResponder;
            }
            if (this.window.firstResponder != null) {
                this.window.firstResponder.mouseDown(event);
                return this.checkEvent(event);
            }
            this.window.mouseDown(event);
            return this.checkEvent(event);
        }

        @Override
        public InvokerResult mouseMoved(double mouseX, double mouseY, int button) {
            UIEvent event = this.makeMouseEvent(mouseX, mouseY, button, 0.0, UIEvent.Type.MOUSE_MOVED);
            if (!this.window._sendGlobalEvent(UIControl.Event.MOUSE_MOVED, event)) {
                return this.checkEvent(event);
            }
            this.updateHoveredResponder((float)mouseX, (float)mouseY, event, true);
            if (this.window.firstResponder != null) {
                this.window.firstResponder.mouseDragged(event);
            }
            if (this.window.hoveredResponder != null) {
                this.window.hoveredResponder.mouseMoved(event);
            }
            this.window.mouseMoved(event);
            return this.checkEvent(event);
        }

        @Override
        public InvokerResult mouseUp(double mouseX, double mouseY, int button) {
            UIEvent event = this.makeMouseEvent(mouseX, mouseY, button, 0.0, MOUSE_BUTTONS[button % 3 + 3]);
            if (!this.window._sendGlobalEvent(UIControl.Event.of(event), event)) {
                return this.checkEvent(event);
            }
            if (this.window.firstResponder != null) {
                this.window.firstResponder.mouseUp(event);
                this.window.firstResponder = null;
                return this.checkEvent(event);
            }
            this.window.mouseUp(event);
            return this.checkEvent(event);
        }

        @Override
        public InvokerResult mouseWheel(double mouseX, double mouseY, double delta) {
            UIEvent event = this.makeMouseEvent(mouseX, mouseY, 0, delta, UIEvent.Type.MOUSE_WHEEL);
            if (!this.window._sendGlobalEvent(UIControl.Event.of(event), event)) {
                return this.checkEvent(event);
            }
            this.updateHoveredResponder((float)mouseX, (float)mouseY, event, false);
            if (this.window.hoveredResponder != null) {
                this.window.hoveredResponder.mouseWheel(event);
                if (!event.isCancelled()) {
                    this.mouseMoved(mouseX, mouseY, 0);
                }
                return this.checkEvent(event);
            }
            this.window.mouseWheel(event);
            return this.checkEvent(event);
        }

        @Override
        public InvokerResult mouseIsInside(double mouseX, double mouseY, int button) {
            UIEvent event = this.makeMouseEvent(mouseX, mouseY, button, 0.0, MOUSE_BUTTONS[button % 3]);
            CGRect frame = this.window.frame();
            UIView view = this.window.hitTest(new CGPoint((float)mouseX - frame.x, (float)mouseY - frame.y), event);
            if (view != null && view != this.window) {
                return InvokerResult.SUCCESS;
            }
            return InvokerResult.PASS;
        }

        @Override
        public InvokerResult changeKeyView(boolean bl) {
            LBSIterator<UIView> iterator;
            UIView responder;
            UIView superview;
            UIView view = this.window;
            UIView targetView = null;
            if (this.window.focusedResponder != null && (superview = this.window.focusedResponder.superview()) != null) {
                view = superview;
                targetView = this.window.focusedResponder;
            }
            if ((responder = Dispatcher.findFocusedResponder(view, targetView, iterator = new LBSIterator<UIView>(bl), false, targetView != null)) != null) {
                this.window._setInputResponder(responder);
                this.window._setFocusedResponder(responder);
                return InvokerResult.SUCCESS;
            }
            return InvokerResult.PASS;
        }

        @Override
        public UIView firstInputResponder() {
            return this.window.firstInputResponder();
        }

        @Override
        public UIView firstTooltipResponder() {
            return this.window.firstTooltipResponder();
        }

        @Override
        public int level() {
            return this.window.level();
        }

        private void updateHoveredResponder(float mouseX, float mouseY, UIEvent event, boolean force) {
            this.window._setHoveredResponder(Dispatcher.findFirstResponder(mouseX, mouseY, event, this.window), event);
        }

        private UIEvent makeMouseEvent(double mouseX, double mouseY, int key, double delta, UIEvent.Type type) {
            return this.makeEvent(mouseX, mouseY, key, 0, delta, type);
        }

        private UIEvent makeKeyEvent(int key, int keyModifier, UIEvent.Type type) {
            return this.makeEvent(0.0, 0.0, key, keyModifier, 0.0, type);
        }

        private UIEvent makeEvent(double mouseX, double mouseY, int key, int keyModifier, double delta, UIEvent.Type type) {
            CGRect frame = this.window.frame();
            CGPoint location = new CGPoint((float)mouseX - frame.x, (float)mouseY - frame.y);
            return new UIEvent(type, key, keyModifier, delta, location);
        }

        private InvokerResult checkEvent(UIEvent event) {
            if (!event.isCancelled()) {
                return InvokerResult.SUCCESS;
            }
            if (this.window.shouldPassEventToNextWindow(event)) {
                return InvokerResult.PASS;
            }
            return event.result();
        }

        private InvokerResult applyKeyEvent(UIEvent event, BiConsumer<UIResponder, UIEvent> consumer) {
            UIResponder[] responders;
            for (UIResponder responder : responders = new UIResponder[]{this.window.firstInputResponder, this.window.focusedResponder, this.window.hoveredResponder, this.window}) {
                if (responder == null) continue;
                consumer.accept(responder, event);
                break;
            }
            return this.checkEvent(event);
        }

        private static void applyRender(float mouseX, float mouseY, int depth, UIView view, CGGraphicsContext context) {
            boolean isOpaque;
            if (view.isHidden()) {
                return;
            }
            UIPresentationDelegate presentation = view._presentation;
            CGPoint center = presentation.center();
            CGRect bounds = presentation.bounds();
            CGAffineTransform transform = presentation.transform();
            float x = center.x;
            float y = center.y;
            float width = bounds.width;
            float height = bounds.height;
            if (transform != CGAffineTransform.IDENTITY) {
                CGSize size = new CGSize(width, height);
                size.apply(transform);
                width = size.width;
                height = size.height;
            }
            float ix = mouseX - (x -= width * 0.5f);
            float iy = mouseY - (y -= height * 0.5f);
            boolean needClips = view.isClipBounds();
            if (needClips) {
                context.addClipRect(UIScreen.convertRectFromView(bounds, view));
            }
            context.saveGraphicsState();
            context.translateCTM(x - bounds.x, y - bounds.y, view.zIndex());
            if (!transform.isIdentity()) {
                context.concatenateCTM(transform);
            }
            context.strokeDebugRect(depth, bounds);
            view.layerWillDraw(context);
            UIColor backgroundColor = view.backgroundColor();
            if (backgroundColor != null) {
                context.fillRect(backgroundColor, bounds);
            }
            if (!(isOpaque = view.isOpaque())) {
                context.enableBlend();
            }
            view.render(new CGPoint(ix, iy), context);
            for (UIView subview : view.subviews()) {
                if (needClips && !bounds.intersects(subview.frame())) continue;
                Dispatcher.applyRender(ix, iy, depth + 1, subview, context);
            }
            view.layerDidDraw(context);
            context.restoreGraphicsState();
            if (needClips) {
                context.removeClipRect();
            }
        }

        private static void applyAnimationPre() {
            CATransaction._updateAnimations(ObjectUtilsImpl.currentMediaTime());
        }

        private static UIView findFirstResponder(float mouseX, float mouseY, UIEvent event, UIView view) {
            CGRect frame = view.frame();
            CGPoint point = new CGPoint(mouseX - frame.x, mouseY - frame.y);
            return view.hitTest(point, event);
        }

        private static UIView findFocusedResponder(UIView view, @Nullable UIView currentView, LBSIterator<UIView> iterator, boolean ignoreSelf, boolean backToTop) {
            UIView focusedResponder;
            UIView superView;
            UIView focusedResponder2;
            List<UIView> subviews = view.subviews();
            for (UIView subview : iterator.remaining(subviews, currentView)) {
                if (ignoreSelf && subview == currentView) continue;
                if (subview != currentView && subview.canBecomeFocused()) {
                    return subview;
                }
                focusedResponder2 = Dispatcher.findFocusedResponder(subview, null, iterator, false, false);
                if (focusedResponder2 == null) continue;
                return focusedResponder2;
            }
            if (backToTop && (superView = view.superview()) != null && (focusedResponder = Dispatcher.findFocusedResponder(superView, view, iterator, true, true)) != null) {
                return focusedResponder;
            }
            for (UIView subview : iterator.skipping(subviews, currentView)) {
                if (subview != currentView && subview.canBecomeFocused()) {
                    return subview;
                }
                focusedResponder2 = Dispatcher.findFocusedResponder(subview, null, iterator, false, false);
                if (focusedResponder2 == null) continue;
                return focusedResponder2;
            }
            return null;
        }

        private static void applyMouseHovered(UIView view, boolean isHovered, UIEvent event) {
            if (view._flags.isHovered != isHovered) {
                view._flags.isHovered = isHovered;
                if (isHovered) {
                    view.mouseEntered(event);
                } else {
                    view.mouseExited(event);
                }
            }
        }

        private static void applyFocusedView(UIView view, boolean isFocused) {
            if (view._flags.isFocused != isFocused) {
                view._flags.isFocused = isFocused;
                view.focusesDidChange();
            }
        }
    }
}

